/*
 * Decompiled with CFR 0.152.
 */
package frost.identities;

import frost.MainFrame;
import frost.Mixed;
import frost.SettingsClass;
import frost.boards.TOF;
import frost.gui.model.MessageTableModel;
import frost.gui.objects.Board;
import frost.gui.objects.FrostMessageObject;
import frost.identities.BuddyList;
import frost.identities.IdentitiesDAO;
import frost.identities.Identity;
import frost.identities.LocalIdentity;
import frost.storage.DAOFactory;
import frost.storage.Savable;
import frost.storage.StorageException;
import frost.util.gui.MiscToolkit;
import frost.util.gui.translation.Language;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FrostIdentities
implements Savable {
    private static Logger logger = Logger.getLogger(FrostIdentities.class.getName());
    public static final int FRIEND = 1;
    public static final int NEUTRAL = 2;
    public static final int OBSERVE = 3;
    public static final int ENEMY = 4;
    private BuddyList friends = new BuddyList();
    private BuddyList neutrals = new BuddyList();
    private BuddyList observed = new BuddyList();
    private BuddyList enemies = new BuddyList();
    private Hashtable identities = new Hashtable();
    private LocalIdentity mySelf = null;
    private SettingsClass settings;

    public FrostIdentities(SettingsClass settingsClass) {
        this.settings = settingsClass;
    }

    public void initialize(boolean bl) throws StorageException {
        IdentitiesDAO identitiesDAO = DAOFactory.getFactory(1).getIdentitiesDAO();
        Language language = Language.getInstance();
        if (!identitiesDAO.exists()) {
            identitiesDAO.create();
            if (!bl) {
                MiscToolkit.getInstance().showMessage(language.getString("Core.loadIdentities.ConnectionNotEstablishedBody"), 0, language.getString("Core.loadIdentities.ConnectionNotEstablishedTitle"));
                System.exit(2);
            }
            try {
                String string = null;
                do {
                    if ((string = MiscToolkit.getInstance().showInputDialog(language.getString("Core.loadIdentities.ChooseName"))) == null || string.length() == 0 || string.indexOf("@") <= -1) continue;
                    MiscToolkit.getInstance().showMessage(language.getString("Core.loadIdentities.InvalidNameBody"), 0, language.getString("Core.loadIdentities.InvalidNameTitle"));
                    string = "";
                } while (string != null && string.length() == 0);
                if (string == null) {
                    logger.severe("Frost can't run without an identity.");
                    System.exit(1);
                }
                do {
                    this.mySelf = new LocalIdentity(string);
                } while (this.mySelf.getUniqueName().indexOf("//") != -1);
            }
            catch (Exception exception) {
                logger.severe("couldn't create new identitiy" + exception.toString());
            }
            this.settings.setValue("userName", this.mySelf.getUniqueName());
        } else {
            identitiesDAO.load(this);
            logger.info("ME = '" + this.mySelf.getUniqueName() + "'");
            if (!this.settings.getBoolValue("oneTimeUpdate.repairIdentities.didRun")) {
                this.repairIdentities();
                this.settings.setValue("oneTimeUpdate.repairIdentities.didRun", true);
            }
            this.convertOldListsToNew();
        }
    }

    public Identity getIdentity(String string) {
        if (string == null) {
            return null;
        }
        return (Identity)this.identities.get(string);
    }

    public boolean addIdentity(Identity identity) {
        String string = Mixed.makeFilename(identity.getUniqueName());
        if (this.identities.containsKey(string)) {
            return false;
        }
        this.identities.put(string, identity);
        return true;
    }

    public List getAllIdentitiesWithState(int n) {
        ArrayList<Identity> arrayList = new ArrayList<Identity>();
        for (Identity identity : this.identities.values()) {
            if (identity.getState() != n) continue;
            arrayList.add(identity);
        }
        return arrayList;
    }

    private void convertOldListsToNew() {
        Identity identity;
        for (String string : this.getFriends().getAllKeys()) {
            identity = this.getFriends().get(string);
            identity.setState(1);
            this.identities.put(string, identity);
        }
        this.getFriends().clearAll();
        for (String string : this.getObserved().getAllKeys()) {
            identity = this.getObserved().get(string);
            identity.setState(3);
            this.identities.put(string, identity);
        }
        this.getObserved().clearAll();
        for (String string : this.getNeutrals().getAllKeys()) {
            identity = this.getNeutrals().get(string);
            identity.setState(2);
            this.identities.put(string, identity);
        }
        this.getNeutrals().clearAll();
        for (String string : this.getEnemies().getAllKeys()) {
            identity = this.getEnemies().get(string);
            identity.setState(4);
            this.identities.put(string, identity);
        }
        this.getEnemies().clearAll();
    }

    private void convertNewListToOld() {
        this.getFriends().clearAll();
        this.getObserved().clearAll();
        this.getNeutrals().clearAll();
        this.getEnemies().clearAll();
        for (String string : this.identities.keySet()) {
            Identity identity = (Identity)this.identities.get(string);
            if (identity.getState() == 1) {
                this.getFriends().add(identity);
            }
            if (identity.getState() == 3) {
                this.getObserved().add(identity);
            }
            if (identity.getState() == 2) {
                this.getNeutrals().add(identity);
            }
            if (identity.getState() != 4) continue;
            this.getEnemies().add(identity);
        }
    }

    public void save() throws StorageException {
        this.convertNewListToOld();
        IdentitiesDAO identitiesDAO = DAOFactory.getFactory(1).getIdentitiesDAO();
        identitiesDAO.save(this);
    }

    public void changeTrust(String string, int n) {
        String string2;
        string = Mixed.makeFilename(string);
        if (n == 1) {
            string2 = "GOOD";
        } else if (n == 2) {
            string2 = "CHECK";
        } else if (n == 3) {
            string2 = "OBSERVE";
        } else if (n == 4) {
            string2 = "BAD";
        } else {
            logger.log(Level.SEVERE, "Invalid new state: " + n);
            return;
        }
        logger.info("Setting '" + string + "' to state '" + string2 + "'.");
        if (this.isMySelf(string) && n != 1) {
            logger.info("Ignored request to change my own ID to state '" + string2 + "'.");
            return;
        }
        Identity identity = this.getIdentity(string);
        if (identity == null) {
            logger.log(Level.SEVERE, "FROM not found in identities list: " + string);
            return;
        }
        identity.setState(n);
        Board board = MainFrame.getInstance().getTofTreeModel().getSelectedNode();
        if (board != null || !board.isFolder()) {
            MessageTableModel messageTableModel = MainFrame.getInstance().getMessageTableModel();
            for (int i = messageTableModel.getRowCount() - 1; i >= 0; --i) {
                FrostMessageObject frostMessageObject = (FrostMessageObject)messageTableModel.getRow(i);
                if (TOF.getInstance().blocked(frostMessageObject, board)) {
                    messageTableModel.deleteRow(frostMessageObject);
                    if (!frostMessageObject.isMessageNew()) continue;
                    board.decNewMessageCount();
                    continue;
                }
                messageTableModel.updateRow(frostMessageObject);
            }
            MainFrame.getInstance().updateMessageCountLabels(board);
        }
        TOF.getInstance().initialSearchNewMessages();
    }

    public boolean isMySelf(String string) {
        return this.getMyId().getUniqueName().equals(string);
    }

    public LocalIdentity getMyId() {
        return this.mySelf;
    }

    void setMyId(LocalIdentity localIdentity) {
        this.mySelf = localIdentity;
    }

    private void repairIdentities() {
        HashSet hashSet = new HashSet();
        Set set = this.getFriends().getAllKeys();
        hashSet.addAll(set);
        set = this.getNeutrals().getAllKeys();
        hashSet.addAll(set);
        set = this.getEnemies().getAllKeys();
        hashSet.addAll(set);
        for (String string : hashSet) {
            Identity identity = this.getIdentityFromAnyList(string);
            boolean bl = this.getFriends().containsKey(string);
            boolean bl2 = this.getNeutrals().containsKey(string);
            boolean bl3 = this.getEnemies().containsKey(string);
            if (bl2) {
                if (bl3 && bl) {
                    this.removeIdentityFromAnyList(string);
                    this.getFriends().add(identity);
                    continue;
                }
                if (bl3) {
                    this.removeIdentityFromAnyList(string);
                    this.getEnemies().add(identity);
                    continue;
                }
                if (!bl) continue;
                this.removeIdentityFromAnyList(string);
                this.getFriends().add(identity);
                continue;
            }
            if (!bl3 || !bl) continue;
            this.removeIdentityFromAnyList(string);
            this.getFriends().add(identity);
        }
    }

    private Identity getIdentityFromAnyList(String string) {
        Identity identity = null;
        identity = this.getNeutrals().get(string);
        if (identity != null) {
            return identity;
        }
        identity = this.getFriends().get(string);
        if (identity != null) {
            return identity;
        }
        identity = this.getObserved().get(string);
        if (identity != null) {
            return identity;
        }
        identity = this.getEnemies().get(string);
        if (identity != null) {
            return identity;
        }
        return null;
    }

    private void removeIdentityFromAnyList(String string) {
        this.getFriends().remove(string);
        this.getEnemies().remove(string);
        this.getNeutrals().remove(string);
        this.getObserved().remove(string);
    }

    BuddyList getEnemies() {
        return this.enemies;
    }

    BuddyList getFriends() {
        return this.friends;
    }

    BuddyList getObserved() {
        return this.observed;
    }

    BuddyList getNeutrals() {
        return this.neutrals;
    }
}

