/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.preferences;

import frost.SettingsClass;
import frost.util.gui.MiscToolkit;
import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class UploadPanel
extends JPanel {
    private SettingsClass settings = null;
    private Language language = null;
    private Listener listener = new Listener();
    private JCheckBox automaticIndexingCheckBox = new JCheckBox();
    private JLabel batchSizeExplanationLabel = new JLabel();
    private JLabel batchSizeLabel = new JLabel();
    private JTextField batchSizeTextField = new JTextField(8);
    private JCheckBox disableRequestsCheckBox = new JCheckBox();
    private JCheckBox helpFriendsCheckBox = new JCheckBox();
    private JLabel htlExplanationLabel = new JLabel();
    private JLabel htlLabel = new JLabel();
    private JTextField htlTextField = new JTextField(8);
    private JLabel indexFileRedundancyExplanationLabel = new JLabel();
    private JLabel indexFileRedundancyLabel = new JLabel();
    private JTextField indexFileRedundancyTextField = new JTextField(8);
    private JCheckBox restartFailedUploadsCheckBox = new JCheckBox();
    private JLabel maxRetriesLabel = new JLabel();
    private JTextField maxRetriesTextField = new JTextField(8);
    private JLabel waitTimeLabel = new JLabel();
    private JTextField waitTimeTextField = new JTextField(8);
    private JCheckBox shareDownloadsCheckBox = new JCheckBox();
    private JCheckBox signUploadsCheckBox = new JCheckBox();
    private JLabel splitfileThreadsExplanationLabel = new JLabel();
    private JLabel splitfileThreadsLabel = new JLabel();
    private JTextField splitfileThreadsTextField = new JTextField(8);
    private JLabel threadsLabel = new JLabel();
    private JTextField threadsTextField = new JTextField(8);

    protected UploadPanel(SettingsClass settingsClass) {
        this.language = Language.getInstance();
        this.settings = settingsClass;
        this.initialize();
        this.loadSettings();
    }

    private JPanel getRetriesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.maxRetriesLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.maxRetriesTextField, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.waitTimeLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.waitTimeTextField, gridBagConstraints);
        return jPanel;
    }

    private void initialize() {
        this.setName("UploadPanel");
        this.setLayout(new GridBagLayout());
        this.refreshLanguage();
        new TextComponentClipboardMenu(this.batchSizeTextField, this.language);
        new TextComponentClipboardMenu(this.htlTextField, this.language);
        new TextComponentClipboardMenu(this.indexFileRedundancyTextField, this.language);
        new TextComponentClipboardMenu(this.splitfileThreadsTextField, this.language);
        new TextComponentClipboardMenu(this.threadsTextField, this.language);
        new TextComponentClipboardMenu(this.maxRetriesTextField, this.language);
        new TextComponentClipboardMenu(this.waitTimeTextField, this.language);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(0, 5, 5, 5);
        Insets insets2 = new Insets(5, 5, 5, 5);
        Insets insets3 = new Insets(5, 30, 5, 5);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.disableRequestsCheckBox, gridBagConstraints);
        gridBagConstraints.insets = insets3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)this.restartFailedUploadsCheckBox, gridBagConstraints);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        this.add((Component)this.getRetriesPanel(), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = insets3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.automaticIndexingCheckBox, gridBagConstraints);
        gridBagConstraints.insets = insets2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)this.shareDownloadsCheckBox, gridBagConstraints);
        gridBagConstraints.insets = insets3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.signUploadsCheckBox, gridBagConstraints);
        gridBagConstraints.insets = insets2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)this.helpFriendsCheckBox, gridBagConstraints);
        gridBagConstraints.insets = insets3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.add((Component)this.htlLabel, gridBagConstraints);
        gridBagConstraints.insets = insets2;
        gridBagConstraints.gridx = 1;
        this.add((Component)this.htlTextField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.add((Component)this.htlExplanationLabel, gridBagConstraints);
        gridBagConstraints.insets = insets3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.add((Component)this.threadsLabel, gridBagConstraints);
        gridBagConstraints.insets = insets2;
        gridBagConstraints.gridx = 1;
        this.add((Component)this.threadsTextField, gridBagConstraints);
        gridBagConstraints.insets = insets3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.add((Component)this.splitfileThreadsLabel, gridBagConstraints);
        gridBagConstraints.insets = insets2;
        gridBagConstraints.gridx = 1;
        this.add((Component)this.splitfileThreadsTextField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.add((Component)this.splitfileThreadsExplanationLabel, gridBagConstraints);
        gridBagConstraints.insets = insets3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        this.add((Component)this.batchSizeLabel, gridBagConstraints);
        gridBagConstraints.insets = insets2;
        gridBagConstraints.gridx = 1;
        this.add((Component)this.batchSizeTextField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.add((Component)this.batchSizeExplanationLabel, gridBagConstraints);
        gridBagConstraints.insets = insets3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        this.add((Component)this.indexFileRedundancyLabel, gridBagConstraints);
        gridBagConstraints.insets = insets2;
        gridBagConstraints.gridx = 1;
        this.add((Component)this.indexFileRedundancyTextField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.add((Component)this.indexFileRedundancyExplanationLabel, gridBagConstraints);
        this.disableRequestsCheckBox.addActionListener(this.listener);
        this.restartFailedUploadsCheckBox.addChangeListener(this.listener);
    }

    private void loadSettings() {
        this.signUploadsCheckBox.setSelected(this.settings.getBoolValue("signUploads"));
        this.helpFriendsCheckBox.setSelected(this.settings.getBoolValue("helpFriends"));
        this.automaticIndexingCheckBox.setSelected(this.settings.getBoolValue("automaticIndexing"));
        this.shareDownloadsCheckBox.setSelected(this.settings.getBoolValue("shareDownloads"));
        this.htlTextField.setText(this.settings.getValue("htlUpload"));
        this.threadsTextField.setText(this.settings.getValue("uploadThreads"));
        this.batchSizeTextField.setText(this.settings.getValue("uploadBatchSize"));
        this.indexFileRedundancyTextField.setText(this.settings.getValue("indexFileRedundancy"));
        this.splitfileThreadsTextField.setText(this.settings.getValue("splitfileUploadThreads"));
        this.disableRequestsCheckBox.setSelected(this.settings.getBoolValue("disableRequests"));
        this.restartFailedUploadsCheckBox.setSelected(this.settings.getBoolValue("restartFailedUploads"));
        this.maxRetriesTextField.setText("" + this.settings.getIntValue("uploadMaxRetries"));
        this.waitTimeTextField.setText("" + this.settings.getIntValue("uploadRetriesWaitTime"));
        this.refreshComponentsState();
    }

    private void refreshComponentsState() {
        boolean bl;
        boolean bl2 = bl = !this.disableRequestsCheckBox.isSelected();
        if (bl) {
            this.setEnabled(true);
            this.maxRetriesTextField.setEnabled(this.restartFailedUploadsCheckBox.isSelected());
            this.waitTimeTextField.setEnabled(this.restartFailedUploadsCheckBox.isSelected());
            this.maxRetriesLabel.setEnabled(this.restartFailedUploadsCheckBox.isSelected());
            this.waitTimeLabel.setEnabled(this.restartFailedUploadsCheckBox.isSelected());
        } else {
            this.setEnabled(false);
        }
    }

    public void ok() {
        this.saveSettings();
    }

    private void refreshLanguage() {
        String string = this.language.getString("minutes");
        this.disableRequestsCheckBox.setText(this.language.getString("Disable uploads"));
        this.restartFailedUploadsCheckBox.setText(this.language.getString("Restart failed uploads"));
        this.waitTimeLabel.setText(this.language.getString("Waittime after each try") + " (" + string + "): ");
        this.maxRetriesLabel.setText(this.language.getString("Maximum number of retries") + ": ");
        this.signUploadsCheckBox.setText(this.language.getString("Sign shared files"));
        this.automaticIndexingCheckBox.setText(this.language.getString("Automatic Indexing"));
        this.shareDownloadsCheckBox.setText(this.language.getString("Share Downloads"));
        this.helpFriendsCheckBox.setText(this.language.getString("Help spread files from people marked GOOD"));
        this.htlLabel.setText(this.language.getString("Upload HTL") + " (21)");
        this.htlExplanationLabel.setText(this.language.getString("up htl explanation"));
        this.threadsLabel.setText(this.language.getString("Number of simultaneous uploads") + " (3)");
        this.splitfileThreadsLabel.setText(this.language.getString("Number of splitfile threads") + " (15)");
        this.splitfileThreadsExplanationLabel.setText(this.language.getString("splitfile explanation"));
        this.batchSizeLabel.setText(this.language.getString("Upload batch size"));
        this.batchSizeExplanationLabel.setText(this.language.getString("batch explanation"));
        this.indexFileRedundancyLabel.setText(this.language.getString("Index file redundancy"));
        this.indexFileRedundancyExplanationLabel.setText(this.language.getString("redundancy explanation"));
    }

    private void saveSettings() {
        this.settings.setValue("htlUpload", this.htlTextField.getText());
        this.settings.setValue("uploadThreads", this.threadsTextField.getText());
        this.settings.setValue("uploadBatchSize", this.batchSizeTextField.getText());
        this.settings.setValue("indexFileRedundancy", this.indexFileRedundancyTextField.getText());
        this.settings.setValue("splitfileUploadThreads", this.splitfileThreadsTextField.getText());
        this.settings.setValue("disableRequests", this.disableRequestsCheckBox.isSelected());
        this.settings.setValue("signUploads", this.signUploadsCheckBox.isSelected());
        this.settings.setValue("automaticIndexing", this.automaticIndexingCheckBox.isSelected());
        this.settings.setValue("shareDownloads", this.shareDownloadsCheckBox.isSelected());
        this.settings.setValue("helpFriends", this.helpFriendsCheckBox.isSelected());
        this.settings.setValue("restartFailedUploads", this.restartFailedUploadsCheckBox.isSelected());
        this.settings.setValue("uploadMaxRetries", this.maxRetriesTextField.getText());
        this.settings.setValue("uploadRetriesWaitTime", this.waitTimeTextField.getText());
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        ArrayList<JCheckBox> arrayList = new ArrayList<JCheckBox>();
        arrayList.add(this.disableRequestsCheckBox);
        MiscToolkit.getInstance().setContainerEnabled(this, bl, arrayList);
    }

    private class Listener
    implements ChangeListener,
    ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == UploadPanel.this.disableRequestsCheckBox) {
                UploadPanel.this.refreshComponentsState();
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == UploadPanel.this.restartFailedUploadsCheckBox) {
                UploadPanel.this.refreshComponentsState();
            }
        }
    }
}

