/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.preferences;

import frost.SettingsClass;
import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class SearchPanel
extends JPanel {
    private SettingsClass settings = null;
    private Language language = null;
    private JLabel archiveExtensionLabel = new JLabel();
    private JTextField archiveExtensionTextField = new JTextField();
    private JLabel audioExtensionLabel = new JLabel();
    private JTextField audioExtensionTextField = new JTextField();
    private JLabel documentExtensionLabel = new JLabel();
    private JTextField documentExtensionTextField = new JTextField();
    private JLabel executableExtensionLabel = new JLabel();
    private JTextField executableExtensionTextField = new JTextField();
    private JCheckBox hideAnonFilesCheckBox = new JCheckBox();
    private JCheckBox hideBadFilesCheckBox = new JCheckBox();
    private JLabel imageExtensionLabel = new JLabel();
    private JTextField imageExtensionTextField = new JTextField();
    private JLabel maxSearchResultsLabel = new JLabel();
    private JTextField maxSearchResultsTextField = new JTextField(8);
    private JLabel videoExtensionLabel = new JLabel();
    private JTextField videoExtensionTextField = new JTextField();

    protected SearchPanel(SettingsClass settingsClass) {
        this.language = Language.getInstance();
        this.settings = settingsClass;
        this.initialize();
        this.loadSettings();
    }

    private void initialize() {
        this.setName("SearchPanel");
        this.setLayout(new GridBagLayout());
        this.refreshLanguage();
        new TextComponentClipboardMenu(this.archiveExtensionTextField, this.language);
        new TextComponentClipboardMenu(this.audioExtensionTextField, this.language);
        new TextComponentClipboardMenu(this.documentExtensionTextField, this.language);
        new TextComponentClipboardMenu(this.executableExtensionTextField, this.language);
        new TextComponentClipboardMenu(this.imageExtensionTextField, this.language);
        new TextComponentClipboardMenu(this.maxSearchResultsTextField, this.language);
        new TextComponentClipboardMenu(this.videoExtensionTextField, this.language);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.imageExtensionLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        this.add((Component)this.imageExtensionTextField, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.videoExtensionLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        this.add((Component)this.videoExtensionTextField, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.archiveExtensionLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        this.add((Component)this.archiveExtensionTextField, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.documentExtensionLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        this.add((Component)this.documentExtensionTextField, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.audioExtensionLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        this.add((Component)this.audioExtensionTextField, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.executableExtensionLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        this.add((Component)this.executableExtensionTextField, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.maxSearchResultsLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        this.add((Component)this.maxSearchResultsTextField, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.hideBadFilesCheckBox, gridBagConstraints);
        gridBagConstraints.gridy = 8;
        this.add((Component)this.hideAnonFilesCheckBox, gridBagConstraints);
    }

    private void loadSettings() {
        this.audioExtensionTextField.setText(this.settings.getValue("audioExtension"));
        this.imageExtensionTextField.setText(this.settings.getValue("imageExtension"));
        this.videoExtensionTextField.setText(this.settings.getValue("videoExtension"));
        this.documentExtensionTextField.setText(this.settings.getValue("documentExtension"));
        this.executableExtensionTextField.setText(this.settings.getValue("executableExtension"));
        this.archiveExtensionTextField.setText(this.settings.getValue("archiveExtension"));
        this.maxSearchResultsTextField.setText(Integer.toString(this.settings.getIntValue("maxSearchResults")));
        this.hideBadFilesCheckBox.setSelected(this.settings.getBoolValue("hideBadFiles"));
        this.hideAnonFilesCheckBox.setSelected(this.settings.getBoolValue("hideAnonFiles"));
    }

    public void ok() {
        this.saveSettings();
    }

    private void refreshLanguage() {
        this.imageExtensionLabel.setText(this.language.getString("Image Extension"));
        this.videoExtensionLabel.setText(this.language.getString("Video Extension"));
        this.archiveExtensionLabel.setText(this.language.getString("Archive Extension"));
        this.documentExtensionLabel.setText(this.language.getString("Document Extension"));
        this.audioExtensionLabel.setText(this.language.getString("Audio Extension"));
        this.executableExtensionLabel.setText(this.language.getString("Executable Extension"));
        this.maxSearchResultsLabel.setText(this.language.getString("Maximum search results"));
        this.hideBadFilesCheckBox.setText(this.language.getString("Hide files from people marked BAD"));
        this.hideAnonFilesCheckBox.setText(this.language.getString("Hide files from anonymous users"));
    }

    private void saveSettings() {
        this.settings.setValue("audioExtension", this.audioExtensionTextField.getText().toLowerCase());
        this.settings.setValue("imageExtension", this.imageExtensionTextField.getText().toLowerCase());
        this.settings.setValue("videoExtension", this.videoExtensionTextField.getText().toLowerCase());
        this.settings.setValue("documentExtension", this.documentExtensionTextField.getText().toLowerCase());
        this.settings.setValue("executableExtension", this.executableExtensionTextField.getText().toLowerCase());
        this.settings.setValue("archiveExtension", this.archiveExtensionTextField.getText().toLowerCase());
        this.settings.setValue("maxSearchResults", this.maxSearchResultsTextField.getText());
        this.settings.setValue("hideBadFiles", this.hideBadFilesCheckBox.isSelected());
        this.settings.setValue("hideAnonFiles", this.hideAnonFilesCheckBox.isSelected());
    }
}

