/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.preferences;

import frost.SettingsClass;
import frost.gui.preferences.DisplayPanel;
import frost.gui.preferences.DownloadPanel;
import frost.gui.preferences.ExpirationPanel;
import frost.gui.preferences.MiscPanel;
import frost.gui.preferences.News2Panel;
import frost.gui.preferences.News3Panel;
import frost.gui.preferences.NewsPanel;
import frost.gui.preferences.SearchPanel;
import frost.gui.preferences.UploadPanel;
import frost.storage.StorageException;
import frost.util.gui.translation.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OptionsFrame
extends JDialog
implements ListSelectionListener {
    private static Logger logger = Logger.getLogger(OptionsFrame.class.getName());
    private SettingsClass frostSettings;
    private Language language;
    private JPanel buttonPanel = null;
    private boolean checkBlock;
    private boolean checkBlockBody;
    private boolean checkDisableRequests;
    private boolean checkHideBadMessages;
    private boolean checkHideCheckMessages;
    private boolean checkHideObserveMessages;
    private String checkMaxMessageDisplay;
    private boolean checkSignedOnly;
    private boolean checkShowDeletedMessages;
    private JPanel contentAreaPanel = null;
    private DisplayPanel displayPanel = null;
    private DownloadPanel downloadPanel = null;
    boolean exitState;
    private JPanel mainPanel = null;
    private MiscPanel miscPanel = null;
    private NewsPanel newsPanel = null;
    private News2Panel news2Panel = null;
    private News3Panel news3Panel = null;
    private ExpirationPanel expirationPanel = null;
    private JList optionsGroupsList = null;
    private JPanel optionsGroupsPanel = null;
    private SearchPanel searchPanel = null;
    boolean shouldReloadMessages = false;
    private boolean shouldRemoveDummyReqFiles = false;
    private UploadPanel uploadPanel = null;

    public OptionsFrame(Frame frame, SettingsClass settingsClass) {
        super(frame);
        this.setModal(true);
        this.language = Language.getInstance();
        this.frostSettings = settingsClass;
        this.setDataElements();
        this.enableEvents(64L);
        try {
            this.Init();
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Exception thrown in constructor", exception);
        }
        this.optionsGroupsList.setSelectedIndex(0);
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private void cancel() {
        this.exitState = false;
        if (this.displayPanel != null) {
            this.displayPanel.cancel();
        }
        this.dispose();
    }

    private void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.cancel();
    }

    protected Dimension computeMaxSize(ListModel listModel) {
        if (listModel == null || listModel.getSize() == 0) {
            return null;
        }
        int n = -1;
        int n2 = -1;
        JDialog jDialog = new JDialog();
        for (int i = 0; i < listModel.getSize(); ++i) {
            ListBoxData listBoxData = (ListBoxData)listModel.getElementAt(i);
            JPanel jPanel = listBoxData.getPanel();
            this.contentAreaPanel.removeAll();
            this.contentAreaPanel.add((Component)jPanel, "Center");
            jDialog.setContentPane(this.contentAreaPanel);
            jDialog.pack();
            int n3 = this.contentAreaPanel.getWidth();
            int n4 = this.contentAreaPanel.getHeight();
            n = Math.max(n, n3);
            n2 = Math.max(n2, n4);
        }
        jDialog = null;
        this.contentAreaPanel.removeAll();
        return new Dimension(n, n2);
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new FlowLayout(2, 10, 10));
            JButton jButton = new JButton(this.language.getString("OK"));
            JButton jButton2 = new JButton(this.language.getString("Cancel"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsFrame.this.okButton_actionPerformed(actionEvent);
                }
            });
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsFrame.this.cancelButton_actionPerformed(actionEvent);
                }
            });
            this.buttonPanel.add(jButton);
            this.buttonPanel.add(jButton2);
        }
        return this.buttonPanel;
    }

    private DisplayPanel getDisplayPanel() {
        if (this.displayPanel == null) {
            this.displayPanel = new DisplayPanel(this, this.frostSettings);
        }
        return this.displayPanel;
    }

    private DownloadPanel getDownloadPanel() {
        if (this.downloadPanel == null) {
            this.downloadPanel = new DownloadPanel(this, this.frostSettings);
        }
        return this.downloadPanel;
    }

    private MiscPanel getMiscPanel() {
        if (this.miscPanel == null) {
            this.miscPanel = new MiscPanel(this.frostSettings);
        }
        return this.miscPanel;
    }

    private News2Panel getNews2Panel() {
        if (this.news2Panel == null) {
            this.news2Panel = new News2Panel(this.frostSettings);
        }
        return this.news2Panel;
    }

    private News3Panel getNews3Panel() {
        if (this.news3Panel == null) {
            this.news3Panel = new News3Panel(this.frostSettings);
        }
        return this.news3Panel;
    }

    private ExpirationPanel getExpirationPanel() {
        if (this.expirationPanel == null) {
            this.expirationPanel = new ExpirationPanel(this.frostSettings);
        }
        return this.expirationPanel;
    }

    private NewsPanel getNewsPanel() {
        if (this.newsPanel == null) {
            this.newsPanel = new NewsPanel(this.frostSettings);
        }
        return this.newsPanel;
    }

    protected JPanel getOptionsGroupsPanel() {
        if (this.optionsGroupsPanel == null) {
            Vector<ListBoxData> vector = new Vector<ListBoxData>();
            vector.add(new ListBoxData(" " + this.language.getString("Downloads") + " ", this.getDownloadPanel()));
            vector.add(new ListBoxData(" " + this.language.getString("Uploads") + " ", this.getUploadPanel()));
            vector.add(new ListBoxData(" " + this.language.getString("News") + " (1) ", this.getNewsPanel()));
            vector.add(new ListBoxData(" " + this.language.getString("News") + " (2) ", this.getNews2Panel()));
            vector.add(new ListBoxData(" " + this.language.getString("News") + " (3) ", this.getNews3Panel()));
            vector.add(new ListBoxData(" " + this.language.getString("Expiration") + " ", this.getExpirationPanel()));
            vector.add(new ListBoxData(" " + this.language.getString("Search") + " ", this.getSearchPanel()));
            vector.add(new ListBoxData(" " + this.language.getString("Display") + " ", this.getDisplayPanel()));
            vector.add(new ListBoxData(" " + this.language.getString("Miscellaneous") + " ", this.getMiscPanel()));
            this.optionsGroupsList = new JList(vector);
            this.optionsGroupsList.setSelectionMode(1);
            this.optionsGroupsList.addListSelectionListener(this);
            this.optionsGroupsPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 0.7;
            gridBagConstraints.weighty = 0.7;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.optionsGroupsPanel.add((Component)this.optionsGroupsList, gridBagConstraints);
            this.optionsGroupsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createEtchedBorder()));
        }
        return this.optionsGroupsPanel;
    }

    private SearchPanel getSearchPanel() {
        if (this.searchPanel == null) {
            this.searchPanel = new SearchPanel(this.frostSettings);
        }
        return this.searchPanel;
    }

    private UploadPanel getUploadPanel() {
        if (this.uploadPanel == null) {
            this.uploadPanel = new UploadPanel(this.frostSettings);
        }
        return this.uploadPanel;
    }

    private void Init() throws Exception {
        this.setTitle(this.language.getString("Options"));
        this.setResizable(true);
        this.mainPanel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)this.mainPanel, null);
        this.contentAreaPanel = new JPanel(new BorderLayout());
        this.contentAreaPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.contentAreaPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5), this.contentAreaPanel.getBorder()));
        this.mainPanel.add((Component)this.getButtonPanel(), "South");
        this.mainPanel.add((Component)this.getOptionsGroupsPanel(), "West");
        Dimension dimension = this.computeMaxSize(this.optionsGroupsList.getModel());
        this.contentAreaPanel.setMinimumSize(dimension);
        this.contentAreaPanel.setPreferredSize(dimension);
        this.mainPanel.add((Component)this.contentAreaPanel, "Center");
    }

    private void ok() {
        this.exitState = true;
        if (this.displayPanel != null) {
            this.displayPanel.ok();
        }
        if (this.downloadPanel != null) {
            this.downloadPanel.ok();
        }
        if (this.searchPanel != null) {
            this.searchPanel.ok();
        }
        if (this.uploadPanel != null) {
            this.uploadPanel.ok();
        }
        if (this.miscPanel != null) {
            this.miscPanel.ok();
        }
        if (this.newsPanel != null) {
            this.newsPanel.ok();
        }
        if (this.news2Panel != null) {
            this.news2Panel.ok();
        }
        if (this.news3Panel != null) {
            this.news3Panel.ok();
        }
        if (this.expirationPanel != null) {
            this.expirationPanel.ok();
        }
        this.saveSettings();
        this.dispose();
    }

    private void okButton_actionPerformed(ActionEvent actionEvent) {
        this.ok();
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(windowEvent);
    }

    public boolean runDialog() {
        this.exitState = false;
        this.setVisible(true);
        return this.exitState;
    }

    private void saveSettings() {
        try {
            this.frostSettings.save();
        }
        catch (StorageException storageException) {
            logger.log(Level.SEVERE, "Error while saving the settings.", storageException);
        }
        if (this.checkDisableRequests && !this.frostSettings.getBoolValue("disableRequests")) {
            this.shouldRemoveDummyReqFiles = true;
        }
        if (!this.checkMaxMessageDisplay.equals(this.frostSettings.getValue("maxMessageDisplay")) || this.checkSignedOnly != this.frostSettings.getBoolValue("signedOnly") || this.checkHideBadMessages != this.frostSettings.getBoolValue("hideBadMessages") || this.checkHideCheckMessages != this.frostSettings.getBoolValue("hideCheckMessages") || this.checkHideObserveMessages != this.frostSettings.getBoolValue("hideObserveMessages") || this.checkBlock != this.frostSettings.getBoolValue("blockMessageChecked") || this.checkBlockBody != this.frostSettings.getBoolValue("blockMessageBodyChecked") || this.checkShowDeletedMessages != this.frostSettings.getBoolValue("showDeletedMessages")) {
            this.shouldReloadMessages = true;
        }
    }

    private void setDataElements() {
        this.checkDisableRequests = this.frostSettings.getBoolValue("disableRequests");
        this.checkMaxMessageDisplay = this.frostSettings.getValue("maxMessageDisplay");
        this.checkSignedOnly = this.frostSettings.getBoolValue("signedOnly");
        this.checkHideBadMessages = this.frostSettings.getBoolValue("hideBadMessages");
        this.checkHideCheckMessages = this.frostSettings.getBoolValue("hideCheckMessages");
        this.checkHideObserveMessages = this.frostSettings.getBoolValue("hideObserveMessages");
        this.checkBlock = this.frostSettings.getBoolValue("blockMessageChecked");
        this.checkBlockBody = this.frostSettings.getBoolValue("blockMessageBodyChecked");
        this.checkShowDeletedMessages = this.frostSettings.getBoolValue("showDeletedMessages");
    }

    public boolean shouldReloadMessages() {
        return this.shouldReloadMessages;
    }

    public boolean shouldRemoveDummyReqFiles() {
        return this.shouldRemoveDummyReqFiles;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        JList jList = (JList)listSelectionEvent.getSource();
        Object e = jList.getSelectedValue();
        this.contentAreaPanel.removeAll();
        if (e instanceof ListBoxData) {
            ListBoxData listBoxData = (ListBoxData)e;
            JPanel jPanel = listBoxData.getPanel();
            this.contentAreaPanel.add((Component)jPanel, "Center");
            jPanel.revalidate();
            jPanel.repaint();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                OptionsFrame.this.contentAreaPanel.revalidate();
            }
        });
    }

    class ListBoxData {
        String name;
        JPanel panel;

        public ListBoxData(String string, JPanel jPanel) {
            this.panel = jPanel;
            this.name = string;
        }

        public JPanel getPanel() {
            return this.panel;
        }

        public String toString() {
            return this.name;
        }
    }
}

