/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.preferences;

import frost.FileAccess;
import frost.SettingsClass;
import frost.util.gui.AntialiasedTextArea;
import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.Language;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

class NewsPanel
extends JPanel {
    private static Logger logger = Logger.getLogger(NewsPanel.class.getName());
    private SettingsClass settings = null;
    private Language language = null;
    private JLabel uploadHtlLabel = new JLabel();
    private JLabel downloadHtlLabel = new JLabel();
    private JLabel displayDaysLabel = new JLabel();
    private JLabel downloadDaysLabel = new JLabel();
    private JLabel messageBaseLabel = new JLabel();
    private JLabel signatureLabel = new JLabel();
    private JTextField uploadHtlTextField = new JTextField(8);
    private JTextField downloadHtlTextField = new JTextField(8);
    private JTextField displayDaysTextField = new JTextField(8);
    private JTextField downloadDaysTextField = new JTextField(8);
    private JTextField messageBaseTextField = new JTextField(16);
    private AntialiasedTextArea signatureTextArea;

    protected NewsPanel(SettingsClass settingsClass) {
        this.language = Language.getInstance();
        this.settings = settingsClass;
        this.initialize();
        this.loadSettings();
    }

    private void initialize() {
        this.setName("NewsPanel");
        this.setLayout(new GridBagLayout());
        this.refreshLanguage();
        new TextComponentClipboardMenu(this.uploadHtlTextField, this.language);
        new TextComponentClipboardMenu(this.downloadHtlTextField, this.language);
        new TextComponentClipboardMenu(this.displayDaysTextField, this.language);
        new TextComponentClipboardMenu(this.downloadDaysTextField, this.language);
        new TextComponentClipboardMenu(this.messageBaseTextField, this.language);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        Insets insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.uploadHtlLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.6;
        gridBagConstraints.gridx = 1;
        this.add((Component)this.uploadHtlTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.downloadHtlLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.downloadHtlTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.displayDaysLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.displayDaysTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.downloadDaysLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.downloadDaysTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.messageBaseLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.messageBaseTextField, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.signatureLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        JScrollPane jScrollPane = new JScrollPane(this.getSignatureTextArea());
        this.add((Component)jScrollPane, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JLabel(""), gridBagConstraints);
    }

    private AntialiasedTextArea getSignatureTextArea() {
        if (this.signatureTextArea == null) {
            int n;
            int n2;
            this.signatureTextArea = new AntialiasedTextArea(6, 50);
            String string = this.settings.getValue("messageBodyFontName");
            Font font = new Font(string, n2 = this.settings.getIntValue("messageBodyFontStyle"), n = this.settings.getIntValue("messageBodyFontSize"));
            if (!font.getFamily().equals(string)) {
                logger.severe("The selected font was not found in your system\nThat selection will be changed to \"Monospaced\".");
                this.settings.setValue("messageBodyFontName", "Monospaced");
                font = new Font("Monospaced", n2, n);
            }
            this.signatureTextArea.setFont(font);
            this.signatureTextArea.setAntiAliasEnabled(this.settings.getBoolValue("messageBodyAA"));
        }
        return this.signatureTextArea;
    }

    private void loadSettings() {
        this.uploadHtlTextField.setText(this.settings.getValue("tofUploadHtl"));
        this.downloadHtlTextField.setText(this.settings.getValue("tofDownloadHtl"));
        this.displayDaysTextField.setText(this.settings.getValue("maxMessageDisplay"));
        this.downloadDaysTextField.setText(this.settings.getValue("maxMessageDownload"));
        this.messageBaseTextField.setText(this.settings.getValue("messageBase"));
        File file = new File("signature.txt");
        if (file.isFile()) {
            this.getSignatureTextArea().setText(FileAccess.readFile("signature.txt", "UTF-8"));
        }
    }

    public void ok() {
        this.saveSettings();
    }

    private void refreshLanguage() {
        this.uploadHtlLabel.setText(this.language.getString("Message upload HTL") + " (21)");
        this.downloadHtlLabel.setText(this.language.getString("Message download HTL") + " (23)");
        this.displayDaysLabel.setText(this.language.getString("Number of days to display") + " (15)");
        this.downloadDaysLabel.setText(this.language.getString("Number of days to download backwards") + " (5)");
        this.messageBaseLabel.setText(this.language.getString("Message base") + " (news)");
        this.signatureLabel.setText(this.language.getString("Signature"));
    }

    private void saveSettings() {
        this.settings.setValue("tofUploadHtl", this.uploadHtlTextField.getText());
        this.settings.setValue("tofDownloadHtl", this.downloadHtlTextField.getText());
        this.settings.setValue("maxMessageDisplay", this.displayDaysTextField.getText());
        this.settings.setValue("maxMessageDownload", this.downloadDaysTextField.getText());
        this.settings.setValue("messageBase", this.messageBaseTextField.getText().trim().toLowerCase());
        FileAccess.writeFile(this.getSignatureTextArea().getText(), "signature.txt", "UTF-8");
    }
}

