/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.preferences;

import frost.MainFrame;
import frost.SettingsClass;
import frost.util.gui.MiscToolkit;
import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.Language;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;

class News3Panel
extends JPanel {
    private SettingsClass settings = null;
    private Language language = null;
    private JLabel autoUpdateLabel = new JLabel();
    private JLabel minimumIntervalLabel = new JLabel();
    private JTextField minimumIntervalTextField = new JTextField(8);
    private JLabel concurrentUpdatesLabel = new JLabel();
    private JTextField concurrentUpdatesTextField = new JTextField(8);
    private JCheckBox showUpdateCheckBox = new JCheckBox();
    private JCheckBox automaticBoardUpdateCheckBox = new JCheckBox();
    private JButton selectedColorButton = new JButton();
    private JLabel selectedColorTextLabel = new JLabel();
    private JLabel selectedColorLabel = new JLabel();
    private JButton notSelectedColorButton = new JButton();
    private JLabel notSelectedColorTextLabel = new JLabel();
    private JLabel notSelectedColorLabel = new JLabel();
    private JCheckBox silentlyRetryCheckBox = new JCheckBox();
    private JCheckBox showDeletedMessagesCheckBox = new JCheckBox();
    private JPanel colorPanel = null;
    private Listener listener = new Listener();
    private Color selectedColor = null;
    private Color notSelectedColor = null;

    protected News3Panel(SettingsClass settingsClass) {
        this.language = Language.getInstance();
        this.settings = settingsClass;
        this.initialize();
        this.loadSettings();
    }

    private Component getColorPanel() {
        if (this.colorPanel == null) {
            this.colorPanel = new JPanel(new GridBagLayout());
            this.colorPanel.setBorder(new EmptyBorder(5, 30, 5, 5));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.5;
            this.colorPanel.add((Component)this.selectedColorTextLabel, gridBagConstraints);
            gridBagConstraints.fill = 3;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.2;
            this.colorPanel.add((Component)this.selectedColorLabel, gridBagConstraints);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.5;
            this.colorPanel.add((Component)this.selectedColorButton, gridBagConstraints);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.5;
            this.colorPanel.add((Component)this.notSelectedColorTextLabel, gridBagConstraints);
            gridBagConstraints.fill = 3;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.2;
            this.colorPanel.add((Component)this.notSelectedColorLabel, gridBagConstraints);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.5;
            this.colorPanel.add((Component)this.notSelectedColorButton, gridBagConstraints);
            this.selectedColorLabel.setOpaque(true);
            this.notSelectedColorLabel.setOpaque(true);
            this.selectedColorLabel.setBorder(new BevelBorder(1));
            this.notSelectedColorLabel.setBorder(new BevelBorder(1));
            this.selectedColorLabel.setHorizontalAlignment(0);
            this.notSelectedColorLabel.setHorizontalAlignment(0);
        }
        return this.colorPanel;
    }

    private Component getUpdatePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(5, 30, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.5;
        jPanel.add((Component)this.minimumIntervalLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.minimumIntervalTextField, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.5;
        jPanel.add((Component)this.concurrentUpdatesLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.concurrentUpdatesTextField, gridBagConstraints);
        return jPanel;
    }

    private void initialize() {
        Insets insets;
        this.setName("News3Panel");
        this.setLayout(new GridBagLayout());
        this.refreshLanguage();
        new TextComponentClipboardMenu(this.minimumIntervalTextField, this.language);
        new TextComponentClipboardMenu(this.concurrentUpdatesTextField, this.language);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.autoUpdateLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.automaticBoardUpdateCheckBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add(this.getUpdatePanel(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.showUpdateCheckBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add(this.getColorPanel(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.silentlyRetryCheckBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.showDeletedMessagesCheckBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)new JLabel(""), gridBagConstraints);
        this.showUpdateCheckBox.addActionListener(this.listener);
        this.selectedColorButton.addActionListener(this.listener);
        this.notSelectedColorButton.addActionListener(this.listener);
    }

    private void loadSettings() {
        this.minimumIntervalTextField.setText(this.settings.getValue("automaticUpdate.boardsMinimumUpdateInterval"));
        this.concurrentUpdatesTextField.setText(this.settings.getValue("automaticUpdate.concurrentBoardUpdates"));
        this.showUpdateCheckBox.setSelected(this.settings.getBoolValue("boardUpdateVisualization"));
        this.refreshUpdateState();
        this.automaticBoardUpdateCheckBox.setSelected(MainFrame.getInstance().isAutomaticBoardUpdateEnabled());
        this.selectedColor = (Color)this.settings.getObjectValue("boardUpdatingSelectedBackgroundColor");
        this.notSelectedColor = (Color)this.settings.getObjectValue("boardUpdatingNonSelectedBackgroundColor");
        this.selectedColorLabel.setBackground(this.selectedColor);
        this.notSelectedColorLabel.setBackground(this.notSelectedColor);
        this.silentlyRetryCheckBox.setSelected(this.settings.getBoolValue("silentlyRetryMessages"));
        this.showDeletedMessagesCheckBox.setSelected(this.settings.getBoolValue("showDeletedMessages"));
    }

    private void notSelectedColorPressed() {
        Color color = JColorChooser.showDialog(this.getTopLevelAncestor(), this.language.getString("Choose updating color of NON-SELECTED boards"), this.notSelectedColor);
        if (color != null) {
            this.notSelectedColor = color;
            this.notSelectedColorButton.setBackground(this.notSelectedColor);
        }
    }

    public void ok() {
        this.saveSettings();
    }

    private void refreshLanguage() {
        String string = this.language.getString("minutes");
        String string2 = this.language.getString("Color");
        String string3 = this.language.getString("On");
        this.autoUpdateLabel.setText(this.language.getString("Automatic update options"));
        this.minimumIntervalLabel.setText(this.language.getString("Minimum update interval of a board") + " (" + string + ") (45)");
        this.concurrentUpdatesLabel.setText(this.language.getString("Number of concurrently updating boards") + " (6)");
        this.automaticBoardUpdateCheckBox.setText(this.language.getString("Automatic message update"));
        this.showUpdateCheckBox.setText(this.language.getString("Show board update visualization") + " (" + string3 + ")");
        this.selectedColorTextLabel.setText(this.language.getString("Background color if updating board is selected"));
        this.selectedColorLabel.setText("    " + string2 + "    ");
        this.selectedColorButton.setText(this.language.getString("Choose"));
        this.notSelectedColorTextLabel.setText(this.language.getString("Background color if updating board is not selected"));
        this.notSelectedColorLabel.setText("    " + string2 + "    ");
        this.notSelectedColorButton.setText(this.language.getString("Choose"));
        this.silentlyRetryCheckBox.setText(this.language.getString("Silently retry failed messages"));
        this.showDeletedMessagesCheckBox.setText(this.language.getString("Show deleted messages"));
    }

    private void refreshUpdateState() {
        MiscToolkit.getInstance().setContainerEnabled(this.colorPanel, this.showUpdateCheckBox.isSelected());
    }

    private void saveSettings() {
        this.settings.setValue("automaticUpdate.concurrentBoardUpdates", this.concurrentUpdatesTextField.getText());
        this.settings.setValue("automaticUpdate.boardsMinimumUpdateInterval", this.minimumIntervalTextField.getText());
        this.settings.setValue("boardUpdateVisualization", this.showUpdateCheckBox.isSelected());
        MainFrame.getInstance().setAutomaticBoardUpdateEnabled(this.automaticBoardUpdateCheckBox.isSelected());
        this.settings.setObjectValue("boardUpdatingSelectedBackgroundColor", this.selectedColor);
        this.settings.setObjectValue("boardUpdatingNonSelectedBackgroundColor", this.notSelectedColor);
        this.settings.setValue("silentlyRetryMessages", this.silentlyRetryCheckBox.isSelected());
        this.settings.setValue("showDeletedMessages", this.showDeletedMessagesCheckBox.isSelected());
    }

    private void selectedColorPressed() {
        Color color = JColorChooser.showDialog(this.getTopLevelAncestor(), this.language.getString("Choose updating color of SELECTED boards"), this.selectedColor);
        if (color != null) {
            this.selectedColor = color;
            this.selectedColorButton.setBackground(this.selectedColor);
        }
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == News3Panel.this.showUpdateCheckBox) {
                News3Panel.this.refreshUpdateState();
            }
            if (actionEvent.getSource() == News3Panel.this.selectedColorButton) {
                News3Panel.this.selectedColorPressed();
            }
            if (actionEvent.getSource() == News3Panel.this.notSelectedColorButton) {
                News3Panel.this.notSelectedColorPressed();
            }
        }
    }
}

