/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.preferences;

import frost.SettingsClass;
import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

class News2Panel
extends JPanel {
    private SettingsClass settings = null;
    private Language language = null;
    private JCheckBox blockBoardCheckBox = new JCheckBox();
    private JTextField blockBoardTextField = new JTextField();
    private JCheckBox blockBodyCheckBox = new JCheckBox();
    private JTextField blockBodyTextField = new JTextField();
    private JCheckBox blockSubjectCheckBox = new JCheckBox();
    private JTextField blockSubjectTextField = new JTextField();
    private JCheckBox doBoardBackoffCheckBox = new JCheckBox();
    private JCheckBox hideBadMessagesCheckBox = new JCheckBox();
    private JCheckBox hideCheckMessagesCheckBox = new JCheckBox();
    private JCheckBox hideObserveMessagesCheckBox = new JCheckBox();
    private JLabel intervalLabel = new JLabel();
    private Listener listener = new Listener();
    private JTextField sampleIntervalTextField = new JTextField(8);
    private JCheckBox signedOnlyCheckBox = new JCheckBox();
    private JTextField spamTresholdTextField = new JTextField(8);
    private JLabel tresholdLabel = new JLabel();

    protected News2Panel(SettingsClass settingsClass) {
        this.language = Language.getInstance();
        this.settings = settingsClass;
        this.initialize();
        this.loadSettings();
    }

    private void blockBoardPressed() {
        this.blockBoardTextField.setEnabled(this.blockBoardCheckBox.isSelected());
    }

    private void blockBodyPressed() {
        this.blockBodyTextField.setEnabled(this.blockBodyCheckBox.isSelected());
    }

    private void blockSubjectPressed() {
        this.blockSubjectTextField.setEnabled(this.blockSubjectCheckBox.isSelected());
    }

    private JPanel getSpamPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(5, 30, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.5;
        jPanel.add((Component)this.intervalLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.sampleIntervalTextField, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        jPanel.add((Component)this.tresholdLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.spamTresholdTextField, gridBagConstraints);
        return jPanel;
    }

    private void initialize() {
        this.setName("News2Panel");
        this.setLayout(new GridBagLayout());
        this.refreshLanguage();
        new TextComponentClipboardMenu(this.blockBoardTextField, this.language);
        new TextComponentClipboardMenu(this.blockBodyTextField, this.language);
        new TextComponentClipboardMenu(this.blockSubjectTextField, this.language);
        new TextComponentClipboardMenu(this.spamTresholdTextField, this.language);
        new TextComponentClipboardMenu(this.sampleIntervalTextField, this.language);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(5, 5, 5, 5);
        Insets insets2 = new Insets(5, 30, 5, 5);
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.blockSubjectCheckBox, gridBagConstraints);
        gridBagConstraints.insets = insets2;
        ++gridBagConstraints.gridy;
        this.add((Component)this.blockSubjectTextField, gridBagConstraints);
        gridBagConstraints.insets = insets;
        ++gridBagConstraints.gridy;
        this.add((Component)this.blockBodyCheckBox, gridBagConstraints);
        gridBagConstraints.insets = insets2;
        ++gridBagConstraints.gridy;
        this.add((Component)this.blockBodyTextField, gridBagConstraints);
        gridBagConstraints.insets = insets;
        ++gridBagConstraints.gridy;
        this.add((Component)this.blockBoardCheckBox, gridBagConstraints);
        gridBagConstraints.insets = insets2;
        ++gridBagConstraints.gridy;
        this.add((Component)this.blockBoardTextField, gridBagConstraints);
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.signedOnlyCheckBox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.hideBadMessagesCheckBox, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.hideCheckMessagesCheckBox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.hideObserveMessagesCheckBox, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.doBoardBackoffCheckBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.getSpamPanel(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JLabel(""), gridBagConstraints);
        this.blockSubjectCheckBox.addActionListener(this.listener);
        this.blockBodyCheckBox.addActionListener(this.listener);
        this.blockBoardCheckBox.addActionListener(this.listener);
        this.doBoardBackoffCheckBox.addActionListener(this.listener);
    }

    private void loadSettings() {
        this.signedOnlyCheckBox.setSelected(this.settings.getBoolValue("signedOnly"));
        this.hideBadMessagesCheckBox.setSelected(this.settings.getBoolValue("hideBadMessages"));
        this.hideCheckMessagesCheckBox.setSelected(this.settings.getBoolValue("hideCheckMessages"));
        this.hideObserveMessagesCheckBox.setSelected(this.settings.getBoolValue("hideObserveMessages"));
        this.blockSubjectCheckBox.setSelected(this.settings.getBoolValue("blockMessageChecked"));
        this.blockSubjectTextField.setEnabled(this.blockSubjectCheckBox.isSelected());
        this.blockSubjectTextField.setText(this.settings.getValue("blockMessage"));
        this.blockBodyCheckBox.setSelected(this.settings.getBoolValue("blockMessageBodyChecked"));
        this.blockBodyTextField.setEnabled(this.blockBodyCheckBox.isSelected());
        this.blockBodyTextField.setText(this.settings.getValue("blockMessageBody"));
        this.blockBoardCheckBox.setSelected(this.settings.getBoolValue("blockMessageBoardChecked"));
        this.blockBoardTextField.setEnabled(this.blockBoardCheckBox.isSelected());
        this.blockBoardTextField.setText(this.settings.getValue("blockMessageBoard"));
        this.doBoardBackoffCheckBox.setSelected(this.settings.getBoolValue("doBoardBackoff"));
        this.sampleIntervalTextField.setText(this.settings.getValue("sampleInterval"));
        this.spamTresholdTextField.setText(this.settings.getValue("spamTreshold"));
        this.refreshSpamDetectionState();
    }

    public void ok() {
        this.saveSettings();
    }

    private void refreshLanguage() {
        String string = this.language.getString("hours");
        String string2 = this.language.getString("Off");
        this.intervalLabel.setText(this.language.getString("Sample interval") + " (" + string + ")");
        this.tresholdLabel.setText(this.language.getString("Threshold of blocked messages"));
        this.signedOnlyCheckBox.setText(this.language.getString("Hide unsigned messages"));
        this.hideBadMessagesCheckBox.setText(this.language.getString("Hide messages flagged BAD") + " (" + string2 + ")");
        this.hideCheckMessagesCheckBox.setText(this.language.getString("Hide messages flagged CHECK") + " (" + string2 + ")");
        this.hideObserveMessagesCheckBox.setText(this.language.getString("Hide messages flagged OBSERVE") + " (" + string2 + ")");
        this.blockSubjectCheckBox.setText(this.language.getString("Block messages with subject containing (separate by ';' )") + ": ");
        this.blockBodyCheckBox.setText(this.language.getString("Block messages with body containing (separate by ';' )") + ": ");
        this.blockBoardCheckBox.setText(this.language.getString("Block messages with these attached boards (separate by ';' )") + ": ");
        this.doBoardBackoffCheckBox.setText(this.language.getString("Do spam detection"));
    }

    private void refreshSpamDetectionState() {
        boolean bl = this.doBoardBackoffCheckBox.isSelected();
        this.sampleIntervalTextField.setEnabled(bl);
        this.spamTresholdTextField.setEnabled(bl);
        this.tresholdLabel.setEnabled(bl);
        this.intervalLabel.setEnabled(bl);
    }

    private void saveSettings() {
        this.settings.setValue("blockMessage", this.blockSubjectTextField.getText().trim().toLowerCase());
        this.settings.setValue("blockMessageChecked", this.blockSubjectCheckBox.isSelected());
        this.settings.setValue("blockMessageBody", this.blockBodyTextField.getText().trim().toLowerCase());
        this.settings.setValue("blockMessageBodyChecked", this.blockBodyCheckBox.isSelected());
        this.settings.setValue("blockMessageBoard", this.blockBoardTextField.getText().trim().toLowerCase());
        this.settings.setValue("blockMessageBoardChecked", this.blockBoardCheckBox.isSelected());
        this.settings.setValue("doBoardBackoff", this.doBoardBackoffCheckBox.isSelected());
        this.settings.setValue("spamTreshold", this.spamTresholdTextField.getText());
        this.settings.setValue("sampleInterval", this.sampleIntervalTextField.getText());
        this.settings.setValue("signedOnly", this.signedOnlyCheckBox.isSelected());
        this.settings.setValue("hideBadMessages", this.hideBadMessagesCheckBox.isSelected());
        this.settings.setValue("hideCheckMessages", this.hideCheckMessagesCheckBox.isSelected());
        this.settings.setValue("hideObserveMessages", this.hideObserveMessagesCheckBox.isSelected());
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == News2Panel.this.blockSubjectCheckBox) {
                News2Panel.this.blockSubjectPressed();
            }
            if (actionEvent.getSource() == News2Panel.this.blockBodyCheckBox) {
                News2Panel.this.blockBodyPressed();
            }
            if (actionEvent.getSource() == News2Panel.this.blockBoardCheckBox) {
                News2Panel.this.blockBoardPressed();
            }
            if (actionEvent.getSource() == News2Panel.this.doBoardBackoffCheckBox) {
                News2Panel.this.refreshSpamDetectionState();
            }
        }
    }
}

