/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.preferences;

import frost.SettingsClass;
import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.JTranslatableComboBox;
import frost.util.gui.translation.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class MiscPanel
extends JPanel {
    private static Logger logger = Logger.getLogger(MiscPanel.class.getName());
    private SettingsClass settings = null;
    private Language language = null;
    private JCheckBox allowEvilBertCheckBox = new JCheckBox();
    private JCheckBox altEditCheckBox = new JCheckBox();
    private JTextField altEditTextField = new JTextField();
    private JLabel autoSaveIntervalLabel = new JLabel();
    private JTextField autoSaveIntervalTextField = new JTextField(8);
    private JLabel availableNodesLabel1 = new JLabel();
    private JLabel availableNodesLabel2 = new JLabel();
    private JTextField availableNodesTextField = new JTextField();
    private JCheckBox enableLoggingCheckBox = new JCheckBox();
    private JLabel keyDownloadHtlLabel = new JLabel();
    private JTextField keyDownloadHtlTextField = new JTextField(8);
    private JLabel keyUploadHtlLabel = new JLabel();
    private JTextField keyUploadHtlTextField = new JTextField(8);
    private Listener listener = new Listener();
    private JLabel logFileSizeLabel = new JLabel();
    private JTextField logFileSizeTextField = new JTextField(8);
    private JTranslatableComboBox logLevelComboBox = null;
    private JLabel logLevelLabel = new JLabel();
    private JLabel maxKeysLabel = new JLabel();
    private JTextField maxKeysTextField = new JTextField(8);
    private JCheckBox showSystrayIconCheckBox = new JCheckBox();
    private JCheckBox splashScreenCheckBox = new JCheckBox();

    protected MiscPanel(SettingsClass settingsClass) {
        this.language = Language.getInstance();
        this.settings = settingsClass;
        this.initialize();
        this.loadSettings();
    }

    private void altEditChanged() {
        this.altEditTextField.setEnabled(this.altEditCheckBox.isSelected());
    }

    private JPanel getLoggingPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(5, 0, 5, 5);
        Insets insets2 = new Insets(5, 30, 5, 0);
        Insets insets3 = new Insets(5, 30, 5, 5);
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.enableLoggingCheckBox, gridBagConstraints);
        gridBagConstraints.insets = insets3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.logLevelLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        String[] stringArray = new String[]{"Very low", "Low", "Medium", "High", "Very high"};
        this.logLevelComboBox = new JTranslatableComboBox(this.language, stringArray);
        jPanel.add((Component)this.logLevelComboBox, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.logFileSizeLabel, gridBagConstraints);
        gridBagConstraints.insets = insets2;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.logFileSizeTextField, gridBagConstraints);
        return jPanel;
    }

    private void initialize() {
        this.setName("MiscPanel");
        this.setLayout(new GridBagLayout());
        this.refreshLanguage();
        new TextComponentClipboardMenu(this.altEditTextField, this.language);
        new TextComponentClipboardMenu(this.autoSaveIntervalTextField, this.language);
        new TextComponentClipboardMenu(this.availableNodesTextField, this.language);
        new TextComponentClipboardMenu(this.keyDownloadHtlTextField, this.language);
        new TextComponentClipboardMenu(this.keyUploadHtlTextField, this.language);
        new TextComponentClipboardMenu(this.logFileSizeTextField, this.language);
        new TextComponentClipboardMenu(this.maxKeysTextField, this.language);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.keyUploadHtlLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.keyUploadHtlTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.keyDownloadHtlLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.keyDownloadHtlTextField, gridBagConstraints);
        gridBagConstraints.anchor = 15;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.availableNodesLabel1, gridBagConstraints);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridy = 3;
        this.add((Component)this.availableNodesLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.availableNodesTextField, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.add((Component)this.maxKeysLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.maxKeysTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.add((Component)this.altEditCheckBox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.altEditTextField, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.add((Component)this.autoSaveIntervalLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.autoSaveIntervalTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        this.add((Component)this.allowEvilBertCheckBox, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        this.add((Component)this.splashScreenCheckBox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.showSystrayIconCheckBox, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        this.add((Component)this.getLoggingPanel(), gridBagConstraints);
        this.enableLoggingCheckBox.addActionListener(this.listener);
        this.altEditCheckBox.addChangeListener(this.listener);
    }

    private void loadSettings() {
        this.allowEvilBertCheckBox.setSelected(this.settings.getBoolValue("allowEvilBert"));
        this.altEditCheckBox.setSelected(this.settings.getBoolValue("useAltEdit"));
        this.altEditTextField.setEnabled(this.altEditCheckBox.isSelected());
        this.keyUploadHtlTextField.setText(this.settings.getValue("keyUploadHtl"));
        this.keyDownloadHtlTextField.setText(this.settings.getValue("keyDownloadHtl"));
        this.showSystrayIconCheckBox.setSelected(this.settings.getBoolValue("showSystrayIcon"));
        this.availableNodesTextField.setText(this.settings.getValue("availableNodes"));
        this.altEditTextField.setText(this.settings.getValue("altEdit"));
        this.maxKeysTextField.setText(this.settings.getValue("maxKeys"));
        this.autoSaveIntervalTextField.setText(Integer.toString(this.settings.getIntValue("autoSaveInterval")));
        this.enableLoggingCheckBox.setSelected(this.settings.getBoolValue("logToFile"));
        this.logFileSizeTextField.setText(Integer.toString(this.settings.getIntValue("logFileSizeLimit")));
        this.logLevelComboBox.setSelectedKey(this.settings.getDefaultValue("logLevel"));
        this.logLevelComboBox.setSelectedKey(this.settings.getValue("logLevel"));
        File file = new File("nosplash.chk");
        if (file.exists()) {
            this.splashScreenCheckBox.setSelected(true);
        } else {
            this.splashScreenCheckBox.setSelected(false);
        }
        this.refreshLoggingState();
    }

    public void ok() {
        this.saveSettings();
    }

    private void refreshLanguage() {
        this.keyUploadHtlLabel.setText(this.language.getString("Keyfile upload HTL") + " (21)");
        this.keyDownloadHtlLabel.setText(this.language.getString("Keyfile download HTL") + " (24)");
        this.availableNodesLabel1.setText(this.language.getString("list of nodes"));
        this.availableNodesLabel2.setText(this.language.getString("list of nodes 2"));
        this.maxKeysLabel.setText(this.language.getString("Maximum number of keys to store") + " (100000)");
        this.autoSaveIntervalLabel.setText(this.language.getString("Automatic saving interval") + " (15)");
        this.splashScreenCheckBox.setText(this.language.getString("Disable splashscreen"));
        this.showSystrayIconCheckBox.setText(this.language.getString("Show systray icon"));
        String string = this.language.getString("Off");
        this.allowEvilBertCheckBox.setText(this.language.getString("Allow 2 byte characters") + " (" + string + ")");
        this.altEditCheckBox.setText(this.language.getString("Use editor for writing messages") + " (" + string + ")");
        this.enableLoggingCheckBox.setText(this.language.getString("Enable logging"));
        this.logLevelLabel.setText(this.language.getString("Logging level") + " (" + this.language.getString("Low") + ") ");
        this.logFileSizeLabel.setText(this.language.getString("Log file size limit (in KB)"));
    }

    private void refreshLoggingState() {
        boolean bl = this.enableLoggingCheckBox.isSelected();
        this.logLevelLabel.setEnabled(bl);
        this.logLevelComboBox.setEnabled(bl);
        this.logFileSizeLabel.setEnabled(bl);
        this.logFileSizeTextField.setEnabled(bl);
    }

    private void saveSettings() {
        this.settings.setValue("keyUploadHtl", this.keyUploadHtlTextField.getText());
        this.settings.setValue("keyDownloadHtl", this.keyDownloadHtlTextField.getText());
        this.settings.setValue("availableNodes", this.availableNodesTextField.getText());
        this.settings.setValue("maxKeys", this.maxKeysTextField.getText());
        this.settings.setValue("showSystrayIcon", this.showSystrayIconCheckBox.isSelected());
        this.settings.setValue("allowEvilBert", this.allowEvilBertCheckBox.isSelected());
        this.settings.setValue("useAltEdit", this.altEditCheckBox.isSelected());
        this.settings.setValue("altEdit", this.altEditTextField.getText());
        this.settings.setValue("autoSaveInterval", this.autoSaveIntervalTextField.getText());
        this.settings.setValue("logToFile", this.enableLoggingCheckBox.isSelected());
        this.settings.setValue("logFileSizeLimit", this.logFileSizeTextField.getText());
        this.settings.setValue("logLevel", this.logLevelComboBox.getSelectedKey());
        try {
            File file = new File("nosplash.chk");
            if (this.splashScreenCheckBox.isSelected()) {
                file.createNewFile();
            } else {
                file.delete();
            }
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Could not create splashscreen checkfile", iOException);
        }
    }

    private class Listener
    implements ChangeListener,
    ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == MiscPanel.this.enableLoggingCheckBox) {
                MiscPanel.this.refreshLoggingState();
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == MiscPanel.this.altEditCheckBox) {
                MiscPanel.this.altEditChanged();
            }
        }
    }
}

