/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.preferences;

import frost.SettingsClass;
import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

class ExpirationPanel
extends JPanel {
    private SettingsClass settings = null;
    private Language language = null;
    private JRadioButton RbKeepExpiredMessages = new JRadioButton();
    private JRadioButton RbArchiveExpiredMessages = new JRadioButton();
    private JRadioButton RbDeleteExpiredMessages = new JRadioButton();
    private ButtonGroup BgExpiredMessages = new ButtonGroup();
    private JLabel LmessageExpireDays = new JLabel();
    private JTextField TfMessageExpireDays = new JTextField(8);
    private JLabel LarchiveFolder = new JLabel();
    private JTextField TfArchiveFolder = new JTextField(30);
    private Listener listener = new Listener();

    protected ExpirationPanel(SettingsClass settingsClass) {
        this.language = Language.getInstance();
        this.settings = settingsClass;
        this.initialize();
        this.loadSettings();
    }

    private void initialize() {
        this.setName("ExpirationPanel");
        this.setLayout(new GridBagLayout());
        this.refreshLanguage();
        new TextComponentClipboardMenu(this.TfMessageExpireDays, this.language);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        Insets insets = new Insets(5, 5, 5, 5);
        Insets insets2 = new Insets(5, 30, 5, 5);
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.LmessageExpireDays, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.TfMessageExpireDays, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.RbKeepExpiredMessages, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.RbArchiveExpiredMessages, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = insets2;
        this.add((Component)this.LarchiveFolder, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = insets;
        this.add((Component)this.TfArchiveFolder, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.RbDeleteExpiredMessages, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JLabel(""), gridBagConstraints);
        this.RbKeepExpiredMessages.addActionListener(this.listener);
        this.RbArchiveExpiredMessages.addActionListener(this.listener);
        this.RbDeleteExpiredMessages.addActionListener(this.listener);
        this.BgExpiredMessages.add(this.RbKeepExpiredMessages);
        this.BgExpiredMessages.add(this.RbArchiveExpiredMessages);
        this.BgExpiredMessages.add(this.RbDeleteExpiredMessages);
    }

    private void loadSettings() {
        this.TfMessageExpireDays.setText(this.settings.getValue("messageExpireDays"));
        this.TfArchiveFolder.setText(this.settings.getValue("archive.dir"));
        String string = this.settings.getValue("messageExpirationMode");
        if (string.toUpperCase().equals("KEEP")) {
            this.RbKeepExpiredMessages.doClick();
        } else if (string.toUpperCase().equals("ARCHIVE")) {
            this.RbArchiveExpiredMessages.doClick();
        } else if (string.toUpperCase().equals("DELETE")) {
            this.RbDeleteExpiredMessages.doClick();
        } else {
            this.RbKeepExpiredMessages.doClick();
        }
    }

    private void saveSettings() {
        this.settings.setValue("messageExpireDays", this.TfMessageExpireDays.getText());
        this.settings.setValue("archive.dir", this.TfArchiveFolder.getText());
        if (this.RbKeepExpiredMessages.isSelected()) {
            this.settings.setValue("messageExpirationMode", "KEEP");
        } else if (this.RbArchiveExpiredMessages.isSelected()) {
            this.settings.setValue("messageExpirationMode", "ARCHIVE");
        } else if (this.RbDeleteExpiredMessages.isSelected()) {
            this.settings.setValue("messageExpirationMode", "DELETE");
        } else {
            this.settings.setValue("messageExpirationMode", "KEEP");
        }
    }

    public void ok() {
        this.saveSettings();
    }

    private void refreshLanguage() {
        this.RbKeepExpiredMessages.setText(this.language.getString("Keep expired messages in keypool"));
        this.RbArchiveExpiredMessages.setText(this.language.getString("Archive expired messages"));
        this.RbDeleteExpiredMessages.setText(this.language.getString("Delete expired messages from keypool"));
        this.LmessageExpireDays.setText(this.language.getString("Number of days before a message expires") + " (30)");
        this.LarchiveFolder.setText(this.language.getString("Archive folder"));
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ExpirationPanel.this.RbKeepExpiredMessages) {
                this.radioButtonChanged();
            }
            if (actionEvent.getSource() == ExpirationPanel.this.RbArchiveExpiredMessages) {
                this.radioButtonChanged();
            }
            if (actionEvent.getSource() == ExpirationPanel.this.RbDeleteExpiredMessages) {
                this.radioButtonChanged();
            }
        }

        private void radioButtonChanged() {
            ExpirationPanel.this.LarchiveFolder.setEnabled(ExpirationPanel.this.RbArchiveExpiredMessages.isSelected());
            ExpirationPanel.this.TfArchiveFolder.setEnabled(ExpirationPanel.this.RbArchiveExpiredMessages.isSelected());
        }
    }
}

