/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.preferences;

import frost.SettingsClass;
import frost.util.gui.MiscToolkit;
import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class DownloadPanel
extends JPanel {
    private JDialog owner = null;
    private SettingsClass settings = null;
    private Language language = null;
    private JButton browseDirectoryButton = new JButton();
    private JCheckBox decodeAfterEachSegmentCheckBox = new JCheckBox();
    private JLabel directoryLabel = new JLabel();
    private JTextField directoryTextField = new JTextField();
    private JCheckBox disableDownloadsCheckBox = new JCheckBox();
    private JCheckBox enableRequestingCheckBox = new JCheckBox();
    private Listener listener = new Listener();
    private JLabel maxRetriesLabel = new JLabel();
    private JTextField maxRetriesTextField = new JTextField(8);
    private JCheckBox removeFinishedDownloadsCheckBox = new JCheckBox();
    private JLabel requestAfterTriesLabel = new JLabel();
    private JTextField requestAfterTriesTextField = new JTextField(8);
    private JCheckBox restartFailedDownloadsCheckBox = new JCheckBox();
    private JLabel splitfileThreadsLabel = new JLabel();
    private JTextField splitfileThreadsTextField = new JTextField(8);
    private JTextField threadsTextField = new JTextField(8);
    private JLabel threadsTextLabel = new JLabel();
    private JCheckBox tryAllSegmentsCheckBox = new JCheckBox();
    private JLabel waitTimeLabel = new JLabel();
    private JTextField waitTimeTextField = new JTextField(8);

    protected DownloadPanel(JDialog jDialog, SettingsClass settingsClass) {
        this.owner = jDialog;
        this.language = Language.getInstance();
        this.settings = settingsClass;
        this.initialize();
        this.loadSettings();
    }

    private void browseDirectoryPressed() {
        JFileChooser jFileChooser = new JFileChooser(this.settings.getValue("lastUsedDirectory"));
        jFileChooser.setDialogTitle(this.language.getString("Select download directory"));
        jFileChooser.setFileHidingEnabled(true);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showOpenDialog(this.owner);
        if (n == 0) {
            String string = System.getProperty("file.separator");
            File file = jFileChooser.getSelectedFile();
            this.settings.setValue("lastUsedDirectory", file.getParent());
            this.directoryTextField.setText(file.getPath() + string);
        }
    }

    private JPanel getRequestPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.requestAfterTriesLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.requestAfterTriesTextField, gridBagConstraints);
        return jPanel;
    }

    private JPanel getRetriesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.maxRetriesLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.maxRetriesTextField, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.waitTimeLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.waitTimeTextField, gridBagConstraints);
        return jPanel;
    }

    private void initialize() {
        this.setName("DownloadPanel");
        this.setLayout(new GridBagLayout());
        this.refreshLanguage();
        new TextComponentClipboardMenu(this.directoryTextField, this.language);
        new TextComponentClipboardMenu(this.maxRetriesTextField, this.language);
        new TextComponentClipboardMenu(this.requestAfterTriesTextField, this.language);
        new TextComponentClipboardMenu(this.splitfileThreadsTextField, this.language);
        new TextComponentClipboardMenu(this.threadsTextField, this.language);
        new TextComponentClipboardMenu(this.waitTimeTextField, this.language);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(0, 5, 5, 5);
        Insets insets2 = new Insets(5, 5, 5, 5);
        Insets insets3 = new Insets(5, 30, 5, 5);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.disableDownloadsCheckBox, gridBagConstraints);
        gridBagConstraints.insets = insets3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)this.directoryLabel, gridBagConstraints);
        gridBagConstraints.insets = insets2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.directoryTextField, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)this.browseDirectoryButton, gridBagConstraints);
        gridBagConstraints.insets = insets3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)this.restartFailedDownloadsCheckBox, gridBagConstraints);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        this.add((Component)this.getRetriesPanel(), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = insets3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.enableRequestingCheckBox, gridBagConstraints);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.getRequestPanel(), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = insets3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.threadsTextLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.threadsTextField, gridBagConstraints);
        gridBagConstraints.insets = insets3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.splitfileThreadsLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.splitfileThreadsTextField, gridBagConstraints);
        gridBagConstraints.insets = insets3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.removeFinishedDownloadsCheckBox, gridBagConstraints);
        gridBagConstraints.gridy = 8;
        this.add((Component)this.tryAllSegmentsCheckBox, gridBagConstraints);
        gridBagConstraints.gridy = 9;
        this.add((Component)this.decodeAfterEachSegmentCheckBox, gridBagConstraints);
        this.enableRequestingCheckBox.addChangeListener(this.listener);
        this.restartFailedDownloadsCheckBox.addChangeListener(this.listener);
        this.disableDownloadsCheckBox.addActionListener(this.listener);
        this.browseDirectoryButton.addActionListener(this.listener);
    }

    private void loadSettings() {
        this.removeFinishedDownloadsCheckBox.setSelected(this.settings.getBoolValue("removeFinishedDownloads"));
        this.directoryTextField.setText(this.settings.getValue("downloadDirectory"));
        this.threadsTextField.setText(this.settings.getValue("downloadThreads"));
        this.splitfileThreadsTextField.setText(this.settings.getValue("splitfileDownloadThreads"));
        this.disableDownloadsCheckBox.setSelected(this.settings.getBoolValue("disableDownloads"));
        this.restartFailedDownloadsCheckBox.setSelected(this.settings.getBoolValue("downloadRestartFailedDownloads"));
        this.enableRequestingCheckBox.setSelected(this.settings.getBoolValue("downloadEnableRequesting"));
        this.requestAfterTriesTextField.setText("" + this.settings.getIntValue("downloadRequestAfterTries"));
        this.maxRetriesTextField.setText("" + this.settings.getIntValue("downloadMaxRetries"));
        this.waitTimeTextField.setText("" + this.settings.getIntValue("downloadWaittime"));
        this.tryAllSegmentsCheckBox.setSelected(this.settings.getBoolValue("downloadTryAllSegments"));
        this.decodeAfterEachSegmentCheckBox.setSelected(this.settings.getBoolValue("downloadDecodeAfterEachSegment"));
        this.refreshComponentsState();
    }

    public void ok() {
        this.saveSettings();
    }

    private void refreshComponentsState() {
        boolean bl;
        boolean bl2 = bl = !this.disableDownloadsCheckBox.isSelected();
        if (bl) {
            this.setEnabled(true);
            this.requestAfterTriesTextField.setEnabled(this.enableRequestingCheckBox.isSelected());
            this.maxRetriesTextField.setEnabled(this.restartFailedDownloadsCheckBox.isSelected());
            this.waitTimeTextField.setEnabled(this.restartFailedDownloadsCheckBox.isSelected());
            this.requestAfterTriesLabel.setEnabled(this.enableRequestingCheckBox.isSelected());
            this.maxRetriesLabel.setEnabled(this.restartFailedDownloadsCheckBox.isSelected());
            this.waitTimeLabel.setEnabled(this.restartFailedDownloadsCheckBox.isSelected());
        } else {
            this.setEnabled(false);
        }
    }

    private void refreshLanguage() {
        String string = this.language.getString("Off");
        String string2 = this.language.getString("On");
        String string3 = this.language.getString("minutes");
        this.removeFinishedDownloadsCheckBox.setText(this.language.getString("Remove finished downloads every 5 minutes") + " (" + string + ")");
        this.restartFailedDownloadsCheckBox.setText(this.language.getString("Restart failed downloads"));
        this.waitTimeLabel.setText(this.language.getString("Waittime after each try") + " (" + string3 + "): ");
        this.maxRetriesLabel.setText(this.language.getString("Maximum number of retries") + ": ");
        this.requestAfterTriesLabel.setText(this.language.getString("Request file after this count of retries") + ": ");
        this.enableRequestingCheckBox.setText(this.language.getString("Enable requesting of failed download files") + " (" + string2 + ")");
        this.tryAllSegmentsCheckBox.setText(this.language.getString("Try to download all segments, even if one fails") + " (" + string2 + ")");
        this.decodeAfterEachSegmentCheckBox.setText(this.language.getString("Decode each segment immediately after its download"));
        this.disableDownloadsCheckBox.setText(this.language.getString("Disable downloads"));
        this.directoryLabel.setText(this.language.getString("Download directory") + ": ");
        this.browseDirectoryButton.setText(this.language.getString("Browse") + "...");
        this.threadsTextLabel.setText(this.language.getString("Number of simultaneous downloads") + " (3)");
        this.splitfileThreadsLabel.setText(this.language.getString("Number of splitfile threads") + " (30)");
    }

    private void saveSettings() {
        String string;
        String string2 = this.directoryTextField.getText();
        if (string2.lastIndexOf(string = System.getProperty("file.separator")) != string2.length() - 1 || string2.lastIndexOf(string) < 0) {
            this.settings.setValue("downloadDirectory", string2 + string);
        } else {
            this.settings.setValue("downloadDirectory", string2);
        }
        this.settings.setValue("downloadThreads", this.threadsTextField.getText());
        this.settings.setValue("removeFinishedDownloads", this.removeFinishedDownloadsCheckBox.isSelected());
        this.settings.setValue("splitfileDownloadThreads", this.splitfileThreadsTextField.getText());
        this.settings.setValue("disableDownloads", this.disableDownloadsCheckBox.isSelected());
        this.settings.setValue("downloadRestartFailedDownloads", this.restartFailedDownloadsCheckBox.isSelected());
        this.settings.setValue("downloadEnableRequesting", this.enableRequestingCheckBox.isSelected());
        this.settings.setValue("downloadRequestAfterTries", this.requestAfterTriesTextField.getText());
        this.settings.setValue("downloadMaxRetries", this.maxRetriesTextField.getText());
        this.settings.setValue("downloadWaittime", this.waitTimeTextField.getText());
        this.settings.setValue("downloadTryAllSegments", this.tryAllSegmentsCheckBox.isSelected());
        this.settings.setValue("downloadDecodeAfterEachSegment", this.decodeAfterEachSegmentCheckBox.isSelected());
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        ArrayList<JCheckBox> arrayList = new ArrayList<JCheckBox>();
        arrayList.add(this.disableDownloadsCheckBox);
        MiscToolkit.getInstance().setContainerEnabled(this, bl, arrayList);
    }

    public class Listener
    implements ChangeListener,
    ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == DownloadPanel.this.disableDownloadsCheckBox) {
                DownloadPanel.this.refreshComponentsState();
            }
            if (actionEvent.getSource() == DownloadPanel.this.browseDirectoryButton) {
                DownloadPanel.this.browseDirectoryPressed();
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == DownloadPanel.this.enableRequestingCheckBox) {
                DownloadPanel.this.refreshComponentsState();
            }
            if (changeEvent.getSource() == DownloadPanel.this.restartFailedDownloadsCheckBox) {
                DownloadPanel.this.refreshComponentsState();
            }
        }
    }
}

