/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.preferences;

import frost.SettingsClass;
import frost.util.gui.FontChooser;
import frost.util.gui.SkinChooser;
import frost.util.gui.translation.Language;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

class DisplayPanel
extends JPanel {
    private JDialog owner = null;
    private SettingsClass settings = null;
    private Language language = null;
    private Listener listener = new Listener();
    private JLabel fontsLabel = new JLabel();
    private JLabel moreSkinsLabel = new JLabel();
    private JCheckBox messageBodyAACheckBox = new JCheckBox();
    private JLabel messageBodyLabel = new JLabel();
    private JLabel fileListLabel = new JLabel();
    private JLabel messageListLabel = new JLabel();
    private JButton fileListButton = new JButton();
    private JButton messageListButton = new JButton();
    private JButton messageBodyButton = new JButton();
    private JLabel selectedFileListFontLabel = new JLabel();
    private JLabel selectedMessageBodyFontLabel = new JLabel();
    private JLabel selectedMessageListFontLabel = new JLabel();
    private Font selectedBodyFont = null;
    private Font selectedFileListFont = null;
    private Font selectedMessageListFont = null;
    private SkinChooser skinChooser = null;

    protected DisplayPanel(JDialog jDialog, SettingsClass settingsClass) {
        this.owner = jDialog;
        this.language = Language.getInstance();
        this.settings = settingsClass;
        this.initialize();
        this.loadSettings();
    }

    public void cancel() {
        this.skinChooser.cancelChanges();
    }

    private void fileListButtonPressed() {
        FontChooser fontChooser = new FontChooser((Dialog)this.owner, this.language);
        fontChooser.setModal(true);
        fontChooser.setSelectedFont(this.selectedFileListFont);
        fontChooser.setVisible(true);
        Font font = fontChooser.getSelectedFont();
        if (font != null) {
            this.selectedFileListFont = font;
            this.selectedFileListFontLabel.setText(this.getFontLabel(this.selectedFileListFont));
        }
    }

    private String getFontLabel(Font font) {
        if (font == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(font.getFamily());
        if (font.isBold()) {
            stringBuffer.append(" " + this.language.getString("Bold"));
        }
        if (font.isItalic()) {
            stringBuffer.append(" " + this.language.getString("Italic"));
        }
        stringBuffer.append(", " + font.getSize());
        return stringBuffer.toString();
    }

    private JPanel getFontsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(5, 80, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        Insets insets = new Insets(1, 5, 1, 5);
        Insets insets2 = new Insets(1, 5, 1, 9);
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.8;
        jPanel.add((Component)this.messageBodyLabel, gridBagConstraints);
        gridBagConstraints.insets = insets2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.1;
        jPanel.add((Component)this.messageBodyButton, gridBagConstraints);
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.selectedMessageBodyFontLabel, gridBagConstraints);
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.8;
        jPanel.add((Component)this.messageListLabel, gridBagConstraints);
        gridBagConstraints.insets = insets2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.1;
        jPanel.add((Component)this.messageListButton, gridBagConstraints);
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.selectedMessageListFontLabel, gridBagConstraints);
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.8;
        jPanel.add((Component)this.fileListLabel, gridBagConstraints);
        gridBagConstraints.insets = insets2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.1;
        jPanel.add((Component)this.fileListButton, gridBagConstraints);
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.selectedFileListFontLabel, gridBagConstraints);
        return jPanel;
    }

    private void initialize() {
        Insets insets;
        this.setName("DisplayPanel");
        this.setLayout(new GridBagLayout());
        this.refreshLanguage();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        Insets insets2 = new Insets(5, 5, 1, 1);
        gridBagConstraints.insets = insets = new Insets(1, 5, 1, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.skinChooser = new SkinChooser(this.language.getResourceBundle());
        this.add((Component)this.skinChooser, gridBagConstraints);
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.moreSkinsLabel.setHorizontalAlignment(4);
        this.add((Component)this.moreSkinsLabel, gridBagConstraints);
        gridBagConstraints.insets = insets2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.add((Component)this.fontsLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.add((Component)this.getFontsPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.add((Component)this.messageBodyAACheckBox, gridBagConstraints);
        this.messageBodyButton.addActionListener(this.listener);
        this.messageListButton.addActionListener(this.listener);
        this.fileListButton.addActionListener(this.listener);
    }

    private void loadSettings() {
        boolean bl = this.settings.getBoolValue("skinsEnabled");
        this.skinChooser.setSkinsEnabled(bl);
        String string = this.settings.getValue("selectedSkin");
        this.skinChooser.setSelectedSkin(string);
        String string2 = this.settings.getValue("messageBodyFontName");
        int n = this.settings.getIntValue("messageBodyFontSize");
        int n2 = this.settings.getIntValue("messageBodyFontStyle");
        this.selectedBodyFont = new Font(string2, n2, n);
        this.selectedMessageBodyFontLabel.setText(this.getFontLabel(this.selectedBodyFont));
        string2 = this.settings.getValue("messageListFontName");
        n = this.settings.getIntValue("messageListFontSize");
        n2 = this.settings.getIntValue("messageListFontStyle");
        this.selectedMessageListFont = new Font(string2, n2, n);
        this.selectedMessageListFontLabel.setText(this.getFontLabel(this.selectedMessageListFont));
        string2 = this.settings.getValue("fileListFontName");
        n = this.settings.getIntValue("fileListFontSize");
        n2 = this.settings.getIntValue("fileListFontStyle");
        this.selectedFileListFont = new Font(string2, n2, n);
        this.selectedFileListFontLabel.setText(this.getFontLabel(this.selectedFileListFont));
        this.messageBodyAACheckBox.setSelected(this.settings.getBoolValue("messageBodyAA"));
    }

    private void messageBodyButtonPressed() {
        FontChooser fontChooser = new FontChooser((Dialog)this.owner, this.language);
        fontChooser.setModal(true);
        fontChooser.setSelectedFont(this.selectedBodyFont);
        fontChooser.setVisible(true);
        Font font = fontChooser.getSelectedFont();
        if (font != null) {
            this.selectedBodyFont = font;
            this.selectedMessageBodyFontLabel.setText(this.getFontLabel(this.selectedBodyFont));
        }
    }

    private void messageListButtonPressed() {
        FontChooser fontChooser = new FontChooser((Dialog)this.owner, this.language);
        fontChooser.setModal(true);
        fontChooser.setSelectedFont(this.selectedMessageListFont);
        fontChooser.setVisible(true);
        Font font = fontChooser.getSelectedFont();
        if (font != null) {
            this.selectedMessageListFont = font;
            this.selectedMessageListFontLabel.setText(this.getFontLabel(this.selectedMessageListFont));
        }
    }

    public void ok() {
        this.skinChooser.commitChanges();
        this.saveSettings();
    }

    private void refreshLanguage() {
        this.moreSkinsLabel.setText(this.language.getString("MoreSkinsAt") + " http://javootoo.l2fprod.com/plaf/skinlf/");
        this.fontsLabel.setText(this.language.getString("Fonts"));
        this.messageBodyLabel.setText(this.language.getString("Message Body"));
        this.messageBodyButton.setText(this.language.getString("Choose"));
        this.selectedMessageBodyFontLabel.setText(this.getFontLabel(this.selectedBodyFont));
        this.messageListLabel.setText(this.language.getString("Message List"));
        this.messageListButton.setText(this.language.getString("Choose"));
        this.selectedMessageListFontLabel.setText(this.getFontLabel(this.selectedMessageListFont));
        this.fileListLabel.setText(this.language.getString("File List"));
        this.fileListButton.setText(this.language.getString("Choose"));
        this.selectedFileListFontLabel.setText(this.getFontLabel(this.selectedFileListFont));
        this.messageBodyAACheckBox.setText(this.language.getString("EnableMessageBodyAA"));
    }

    private void saveSettings() {
        boolean bl = this.skinChooser.isSkinsEnabled();
        this.settings.setValue("skinsEnabled", bl);
        String string = this.skinChooser.getSelectedSkin();
        if (string == null) {
            this.settings.setValue("selectedSkin", "none");
        } else {
            this.settings.setValue("selectedSkin", string);
        }
        if (this.selectedBodyFont != null) {
            this.settings.setValue("messageBodyFontName", this.selectedBodyFont.getFamily());
            this.settings.setValue("messageBodyFontStyle", this.selectedBodyFont.getStyle());
            this.settings.setValue("messageBodyFontSize", this.selectedBodyFont.getSize());
        }
        if (this.selectedMessageListFont != null) {
            this.settings.setValue("messageListFontName", this.selectedMessageListFont.getFamily());
            this.settings.setValue("messageListFontStyle", this.selectedMessageListFont.getStyle());
            this.settings.setValue("messageListFontSize", this.selectedMessageListFont.getSize());
        }
        if (this.selectedFileListFont != null) {
            this.settings.setValue("fileListFontName", this.selectedFileListFont.getFamily());
            this.settings.setValue("fileListFontStyle", this.selectedFileListFont.getStyle());
            this.settings.setValue("fileListFontSize", this.selectedFileListFont.getSize());
        }
        this.settings.setValue("messageBodyAA", this.messageBodyAACheckBox.isSelected());
    }

    public class Listener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == DisplayPanel.this.messageBodyButton) {
                DisplayPanel.this.messageBodyButtonPressed();
            }
            if (actionEvent.getSource() == DisplayPanel.this.messageListButton) {
                DisplayPanel.this.messageListButtonPressed();
            }
            if (actionEvent.getSource() == DisplayPanel.this.fileListButton) {
                DisplayPanel.this.fileListButtonPressed();
            }
        }
    }
}

