/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.objects;

import frost.gui.objects.Board;
import java.util.Collections;
import javax.swing.tree.DefaultMutableTreeNode;

public class TofTreeNode
extends DefaultMutableTreeNode
implements Comparable {
    private Board board;
    private boolean isFolder = false;
    private String name;

    public TofTreeNode(String string) {
        this.name = string;
        this.isFolder = true;
    }

    public TofTreeNode(Board board) {
        this.board = board;
        this.isFolder = false;
        this.name = board.getName();
    }

    public Board getBoard() {
        return this.board;
    }

    public int compareTo(Object object) {
        if (object instanceof TofTreeNode) {
            TofTreeNode tofTreeNode = (TofTreeNode)object;
            if (tofTreeNode.isFolder() == this.isFolder()) {
                return this.getName().compareToIgnoreCase(tofTreeNode.getName());
            }
            return this.isFolder() ? -1 : 1;
        }
        return 0;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public String getName() {
        return this.name;
    }

    public boolean isLeaf() {
        return !this.isFolder();
    }

    public void sortChildren() {
        Collections.sort(this.children);
    }
}

