/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.objects;

import frost.boards.TofTreeModel;
import frost.gui.objects.Board;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;

public class TargetFolderChooser
extends JDialog {
    private JPanel jContentPane = null;
    private JPanel buttonsPanel = null;
    private JTree folderTree = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private DefaultTreeModel treeModel;
    private Board choosedFolder = null;
    private JScrollPane jScrollPane = null;

    public TargetFolderChooser(TofTreeModel tofTreeModel) {
        MyTreeNode myTreeNode = this.buildTree(tofTreeModel);
        this.treeModel = new DefaultTreeModel(myTreeNode);
        this.initialize();
    }

    private MyTreeNode buildTree(TofTreeModel tofTreeModel) {
        MyTreeNode myTreeNode = new MyTreeNode((Board)tofTreeModel.getRoot());
        this.addNodesRecursiv(myTreeNode, (DefaultMutableTreeNode)tofTreeModel.getRoot());
        return myTreeNode;
    }

    private void addNodesRecursiv(MyTreeNode myTreeNode, DefaultMutableTreeNode defaultMutableTreeNode) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            Board board = (Board)defaultMutableTreeNode.getChildAt(i);
            if (!board.isFolder()) continue;
            MyTreeNode myTreeNode2 = new MyTreeNode(board);
            myTreeNode.add(myTreeNode2);
            this.addNodesRecursiv(myTreeNode2, board);
        }
    }

    private void initialize() {
        int n = 350;
        int n2 = 400;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = (dimension.width - n) / 2;
        int n4 = (dimension.height - n2) / 2;
        this.setBounds(n3, n4, n, n2);
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setTitle("Choose a target folder");
        this.setContentPane(this.getJContentPane());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TargetFolderChooser.this.cancelButtonPressed();
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJScrollPane(), "Center");
            this.jContentPane.add((Component)this.getButtonsPanel(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setLayout(flowLayout);
            this.buttonsPanel.add((Component)this.getOkButton(), null);
            this.buttonsPanel.add((Component)this.getCancelButton(), null);
        }
        return this.buttonsPanel;
    }

    private JTree getFolderTree() {
        if (this.folderTree == null) {
            this.folderTree = new JTree(this.treeModel);
            this.folderTree.setCellRenderer(new CellRenderer());
            this.folderTree.setSelectionRow(0);
        }
        return this.folderTree;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("Ok");
            this.okButton.setSelected(false);
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TargetFolderChooser.this.okButtonPressed();
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TargetFolderChooser.this.cancelButtonPressed();
                }
            });
        }
        return this.cancelButton;
    }

    private void okButtonPressed() {
        this.choosedFolder = ((MyTreeNode)this.getFolderTree().getSelectionPath().getLastPathComponent()).getFolder();
        this.setVisible(false);
    }

    private void cancelButtonPressed() {
        this.choosedFolder = null;
        this.setVisible(false);
    }

    public Board startDialog() {
        this.setVisible(true);
        return this.choosedFolder;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setBackground(Color.white);
            this.jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createEtchedBorder(1)));
            this.jScrollPane.setViewportView(this.getFolderTree());
        }
        return this.jScrollPane;
    }

    private class MyTreeNode
    extends DefaultMutableTreeNode {
        Board folder;

        public MyTreeNode(Object object) {
            super(object);
            this.folder = (Board)object;
        }

        public String toString() {
            return this.folder.getName();
        }

        public Board getFolder() {
            return this.folder;
        }
    }

    private class CellRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon boardIcon = new ImageIcon(this.getClass().getResource("/data/open.gif"));

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setIcon(this.boardIcon);
            return this;
        }
    }
}

