/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.objects;

import frost.Core;
import frost.MainFrame;
import frost.Mixed;
import java.io.File;
import java.util.Collections;
import javax.swing.tree.DefaultMutableTreeNode;

public class Board
extends DefaultMutableTreeNode
implements Comparable {
    private boolean autoUpdateEnabled = true;
    private String b64FileName = null;
    private String boardDescription = null;
    private String boardFileName = null;
    private String boardName = null;
    private Boolean hideBad = null;
    private Boolean hideCheck = null;
    private Boolean hideObserve = null;
    private boolean isConfigured = false;
    private boolean isFolder = false;
    private boolean isUpdating = false;
    private long lastUpdateStartMillis = -1L;
    private Integer maxMessageDisplay = null;
    private int newMessageCount = 0;
    private int numberBlocked = 0;
    private String privateKey = null;
    private String publicKey = null;
    private Boolean showSignedOnly = null;
    private boolean spammed = false;

    public Board(String string, String string2) {
        this.boardName = string;
        this.boardDescription = string2;
        this.boardFileName = Mixed.makeFilename(this.boardName.toLowerCase());
        if (Mixed.containsForeign(string)) {
            this.b64FileName = Core.getCrypto().encode64(string);
        }
    }

    public Board(String string, boolean bl) {
        this(string, null);
        this.isFolder = bl;
    }

    public Board(String string, String string2, String string3, String string4) {
        this(string, string4);
        this.setPublicKey(string2);
        this.setPrivateKey(string3);
    }

    public int compareTo(Object object) {
        if (object instanceof Board) {
            Board board = (Board)object;
            if (board.isFolder() == this.isFolder()) {
                return this.getName().toLowerCase().compareTo(board.getName().toLowerCase());
            }
            return this.isFolder() ? -1 : 1;
        }
        return 0;
    }

    public boolean containsNewMessages() {
        if (!this.isFolder) {
            return this.getNewMessageCount() > 0;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            Board board = (Board)this.getChildAt(i);
            if (!board.containsNewMessages()) continue;
            return true;
        }
        return false;
    }

    public void decNewMessageCount() {
        --this.newMessageCount;
    }

    public boolean getAutoUpdateEnabled() {
        if (!this.isConfigured()) {
            return true;
        }
        return this.autoUpdateEnabled;
    }

    public int getBlockedCount() {
        return this.numberBlocked;
    }

    public String getBoardFilename() {
        return this.b64FileName == null ? this.boardFileName : this.b64FileName;
    }

    public String getName() {
        return this.boardName;
    }

    public String getDescription() {
        return this.boardDescription;
    }

    public boolean getHideBad() {
        if (!this.isConfigured() || this.hideBad == null) {
            return MainFrame.frostSettings.getBoolValue("hideBadMessages");
        }
        return this.hideBad;
    }

    public Boolean getHideBadObj() {
        return this.hideBad;
    }

    public boolean getHideCheck() {
        if (!this.isConfigured() || this.hideCheck == null) {
            return MainFrame.frostSettings.getBoolValue("hideCheckMessages");
        }
        return this.hideCheck;
    }

    public Boolean getHideCheckObj() {
        return this.hideCheck;
    }

    public boolean getHideObserve() {
        if (!this.isConfigured() || this.hideObserve == null) {
            return MainFrame.frostSettings.getBoolValue("hideObserveMessages");
        }
        return this.hideObserve;
    }

    public Boolean getHideObserveObj() {
        return this.hideObserve;
    }

    public long getLastUpdateStartMillis() {
        return this.lastUpdateStartMillis;
    }

    public int getMaxMessageDisplay() {
        if (!this.isConfigured() || this.maxMessageDisplay == null) {
            return MainFrame.frostSettings.getIntValue("maxMessageDisplay");
        }
        return this.maxMessageDisplay;
    }

    public Integer getMaxMessageDisplayObj() {
        return this.maxMessageDisplay;
    }

    public int getNewMessageCount() {
        return this.newMessageCount;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public boolean getShowSignedOnly() {
        if (!this.isConfigured() || this.showSignedOnly == null) {
            return MainFrame.frostSettings.getBoolValue("signedOnly");
        }
        return this.showSignedOnly;
    }

    public Boolean getShowSignedOnlyObj() {
        return this.showSignedOnly;
    }

    public String getStateString() {
        if (this.isReadAccessBoard()) {
            return "read access";
        }
        if (this.isWriteAccessBoard()) {
            return "write access";
        }
        if (this.isPublicBoard()) {
            return "public board";
        }
        return "*ERROR*";
    }

    public void incBlocked() {
        ++this.numberBlocked;
    }

    public void incNewMessageCount() {
        ++this.newMessageCount;
    }

    public boolean isConfigured() {
        return this.isConfigured;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public boolean isLeaf() {
        return !this.isFolder();
    }

    public boolean isPublicBoard() {
        return this.publicKey == null && this.privateKey == null;
    }

    public boolean isReadAccessBoard() {
        return this.publicKey != null && this.privateKey == null;
    }

    public boolean isWriteAccessBoard() {
        return this.publicKey != null && this.privateKey != null;
    }

    public boolean isSpammed() {
        return this.spammed;
    }

    public boolean isUpdating() {
        return this.isUpdating;
    }

    public void resetBlocked() {
        this.numberBlocked = 0;
    }

    public void setAutoUpdateEnabled(boolean bl) {
        this.autoUpdateEnabled = bl;
    }

    public void setName(String string) {
        this.boardName = string;
        this.boardFileName = Mixed.makeFilename(this.boardName.toLowerCase());
        this.b64FileName = Mixed.containsForeign(string) ? Core.getCrypto().encode64(string) : null;
        File file = new File(MainFrame.keypool + this.boardFileName);
        if (!file.exists() || !file.isDirectory()) {
            this.boardFileName = Core.getCrypto().encode64(string);
        }
    }

    public void setConfigured(boolean bl) {
        this.isConfigured = bl;
    }

    public void setHideBad(Boolean bl) {
        this.hideBad = bl;
    }

    public void setHideCheck(Boolean bl) {
        this.hideCheck = bl;
    }

    public void setHideObserve(Boolean bl) {
        this.hideObserve = bl;
    }

    public void setLastUpdateStartMillis(long l) {
        this.lastUpdateStartMillis = l;
    }

    public void setMaxMessageDays(Integer n) {
        this.maxMessageDisplay = n;
    }

    public void setNewMessageCount(int n) {
        this.newMessageCount = n;
    }

    public void setPrivateKey(String string) {
        if (string != null) {
            string = string.trim();
        }
        this.privateKey = string;
    }

    public void setPublicKey(String string) {
        if (string != null) {
            string = string.trim();
        }
        this.publicKey = string;
    }

    public void setShowSignedOnly(Boolean bl) {
        this.showSignedOnly = bl;
    }

    public void setSpammed(boolean bl) {
        this.spammed = bl;
    }

    public void setUpdating(boolean bl) {
        this.isUpdating = bl;
    }

    public void sortChildren() {
        Collections.sort(this.children);
    }
}

