/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.model;

import frost.gui.SortedTable;
import frost.gui.model.TableMember;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Logger;
import javax.swing.table.DefaultTableModel;

public class SortedTableModel
extends DefaultTableModel {
    private static Logger logger = Logger.getLogger(SortedTableModel.class.getName());
    private boolean bWasResized = false;
    private ArrayList rows = null;
    private SortedTable parentTable = null;
    private ColumnComparator colComparator = new ColumnComparator(0, true);

    public SortedTableModel() {
        this.rows = new ArrayList();
    }

    public void setParentTable(SortedTable sortedTable) {
        this.parentTable = sortedTable;
    }

    public boolean isSortable(int n) {
        return true;
    }

    public int getRowCount() {
        if (this.rows == null) {
            return 0;
        }
        return this.rows.size();
    }

    public void sortModelColumn(int n, boolean bl) {
        this.sortColumn(n, bl);
    }

    private void sortColumn(int n, boolean bl) {
        this.colComparator = new ColumnComparator(n, bl);
        if (this.rows.size() > 1) {
            Collections.sort(this.rows, this.colComparator);
        }
    }

    public void addRow(TableMember tableMember) {
        int n = Collections.binarySearch(this.rows, tableMember, this.colComparator);
        if (n < 0) {
            n = (n + 1) * -1;
        } else {
            n = Collections.lastIndexOfSubList(this.rows, Collections.singletonList(this.rows.get(n)));
            ++n;
        }
        this.insertRowAt(tableMember, n);
    }

    public void insertRowAt(TableMember tableMember, int n) {
        if (n <= this.rows.size()) {
            this.rows.add(n, tableMember);
            this.fireTableRowsInserted(n, n);
        }
    }

    public void deleteRow(TableMember tableMember) {
        if (tableMember != null) {
            int n = this.rows.indexOf(tableMember);
            this.rows.remove(tableMember);
            if (n != -1) {
                this.fireTableRowsDeleted(n, n);
            }
        }
    }

    public void updateRow(TableMember tableMember) {
        int n;
        if (tableMember != null && (n = this.rows.indexOf(tableMember)) != -1) {
            this.fireTableRowsUpdated(n, n);
            this.resortTable();
        }
    }

    private void resortTable() {
        if (this.parentTable != null) {
            this.parentTable.resortTable();
        }
    }

    public TableMember getRow(int n) {
        Object e;
        if (n < this.getRowCount() && (e = this.rows.get(n)) instanceof TableMember) {
            return (TableMember)e;
        }
        return null;
    }

    public void removeRow(int n) {
        Object e;
        if (n < this.getRowCount() && (e = this.rows.get(n)) instanceof TableMember) {
            this.deleteRow((TableMember)e);
        }
    }

    public Object getValueAt(int n, int n2) {
        if (n >= this.getRowCount() || n < 0) {
            return null;
        }
        TableMember tableMember = (TableMember)this.rows.get(n);
        if (tableMember == null) {
            return null;
        }
        return tableMember.getValueAt(n2);
    }

    public void clearDataModel() {
        int n = this.rows.size();
        if (n > 0) {
            this.rows = new ArrayList();
            this.fireTableRowsDeleted(0, n);
        }
    }

    public void tableEntriesChanged() {
        this.fireTableRowsUpdated(0, this.getRowCount());
    }

    public void tableEntriesChanged(int n, int n2) {
        this.fireTableRowsUpdated(n, n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        logger.severe("setValueAt() - ERROR: NOT IMPLEMENTED");
    }

    public boolean wasResized() {
        return this.bWasResized;
    }

    public void setResized(boolean bl) {
        this.bWasResized = bl;
    }

    public class ColumnComparator
    implements Comparator {
        protected int index;
        protected boolean ascending;

        public ColumnComparator(int n, boolean bl) {
            this.index = n;
            this.ascending = bl;
        }

        public int compare(Object object, Object object2) {
            try {
                TableMember tableMember = (TableMember)object;
                TableMember tableMember2 = (TableMember)object2;
                if (this.ascending) {
                    return tableMember.compareTo(tableMember2, this.index);
                }
                return tableMember2.compareTo(tableMember, this.index);
            }
            catch (Exception exception) {
                return 1;
            }
        }
    }
}

