/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.model;

import frost.messages.FileAttachment;
import frost.messages.SharedFileObject;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import java.util.List;
import javax.swing.table.DefaultTableModel;

public class AttachedFilesTableModel
extends DefaultTableModel
implements LanguageListener {
    private Language language = Language.getInstance();
    protected static final String[] columnNames = new String[2];
    protected static final Class[] columnClasses = new Class[]{String.class, String.class};

    public AttachedFilesTableModel() {
        this.language.addLanguageListener(this);
        this.refreshLanguage();
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void languageChanged(LanguageEvent languageEvent) {
        this.refreshLanguage();
    }

    private void refreshLanguage() {
        AttachedFilesTableModel.columnNames[0] = this.language.getString("Filename");
        AttachedFilesTableModel.columnNames[1] = this.language.getString("Size");
        this.fireTableStructureChanged();
    }

    public void setData(List list) {
        this.setRowCount(0);
        for (FileAttachment fileAttachment : list) {
            SharedFileObject sharedFileObject = fileAttachment.getFileObj();
            if (sharedFileObject.getKey() == null || sharedFileObject.getKey().length() <= 40 || sharedFileObject.getFilename() == null || sharedFileObject.getFilename().length() <= 0) continue;
            Object[] objectArray = new Object[]{sharedFileObject.getFilename(), sharedFileObject.getSize()};
            this.addRow(objectArray);
        }
    }

    public String getColumnName(int n) {
        if (n >= 0 && n < columnNames.length) {
            return columnNames[n];
        }
        return null;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public Class getColumnClass(int n) {
        if (n >= 0 && n < columnClasses.length) {
            return columnClasses[n];
        }
        return null;
    }
}

