/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.model;

import frost.gui.objects.Board;
import frost.messages.BoardAttachment;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import java.util.List;
import javax.swing.table.DefaultTableModel;

public class AttachedBoardTableModel
extends DefaultTableModel
implements LanguageListener {
    private Language language = Language.getInstance();
    protected static final String[] columnNames = new String[3];
    protected static final Class[] columnClasses = new Class[]{String.class, String.class, String.class};

    public AttachedBoardTableModel() {
        this.language.addLanguageListener(this);
        this.refreshLanguage();
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void languageChanged(LanguageEvent languageEvent) {
        this.refreshLanguage();
    }

    private void refreshLanguage() {
        AttachedBoardTableModel.columnNames[0] = this.language.getString("Board Name");
        AttachedBoardTableModel.columnNames[1] = this.language.getString("Access rights");
        AttachedBoardTableModel.columnNames[2] = this.language.getString("Description");
        this.fireTableStructureChanged();
    }

    public void setData(List list) {
        this.setRowCount(0);
        for (BoardAttachment boardAttachment : list) {
            Board board = boardAttachment.getBoardObj();
            Object[] objectArray = new Object[3];
            if (board.getName() == null) continue;
            objectArray[0] = board.getName();
            objectArray[1] = board.getPublicKey() == null && board.getPrivateKey() == null ? "public" : (board.getPublicKey() != null && board.getPrivateKey() == null ? "read - only" : "read / write");
            objectArray[2] = board.getDescription() == null ? "Not present" : board.getDescription();
            this.addRow(objectArray);
        }
    }

    public String getColumnName(int n) {
        if (n >= 0 && n < columnNames.length) {
            return columnNames[n];
        }
        return null;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public Class getColumnClass(int n) {
        if (n >= 0 && n < columnClasses.length) {
            return columnClasses[n];
        }
        return null;
    }
}

