/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class Splashscreen
extends JDialog {
    private static String SPLASH_LOGO_FILENAME = "/data/splash.png";
    private static String NO_SPLASH_FILENAME = "nosplash.chk";
    private ImageIcon frostLogo = new ImageIcon(Splashscreen.class.getResource(SPLASH_LOGO_FILENAME));
    JPanel mainPanel = new JPanel(new BorderLayout());
    JLabel pictureLabel = new JLabel();
    JProgressBar progressBar = new JProgressBar(0, 100);
    private boolean noSplash;

    public Splashscreen() {
        File file = new File(NO_SPLASH_FILENAME);
        if (file.exists()) {
            this.noSplash = true;
        } else {
            this.noSplash = false;
            this.init();
        }
    }

    public void closeMe() {
        if (!this.noSplash) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void init() {
        this.setUndecorated(true);
        this.setResizable(false);
        this.pictureLabel.setIcon(this.frostLogo);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("Starting...");
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.add((Component)this.pictureLabel, "Center");
        this.mainPanel.add((Component)this.progressBar, "South");
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    public void setProgress(int n) {
        if (!this.noSplash) {
            this.progressBar.setValue(n);
        }
    }

    public void setText(String string) {
        if (!this.noSplash) {
            this.progressBar.setString(string);
        }
    }

    public void setVisible(boolean bl) {
        if (!this.noSplash) {
            super.setVisible(bl);
        }
    }
}

