/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.gui.SortHeaderRenderer;
import frost.gui.model.SortedTableModel;
import frost.gui.model.TableMember;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SortedTable
extends JTable {
    protected int sortedColumnIndex = 0;
    protected boolean sortedColumnAscending = true;
    private SortHeaderRenderer columnHeadersRenderer = new SortHeaderRenderer();

    public SortedTable(SortedTableModel sortedTableModel) {
        super(sortedTableModel);
        sortedTableModel.setParentTable(this);
        this.initSortHeader();
    }

    public void sortColumn(int n, boolean bl) {
        SortedTableModel sortedTableModel = null;
        sortedTableModel = (SortedTableModel)this.getModel();
        ArrayList arrayList = this.getListOfSelectedItems();
        this.clearSelection();
        sortedTableModel.sortModelColumn(n, bl);
        this.setSelectedItems(arrayList);
    }

    public void resortTable() {
        this.sortColumn(this.sortedColumnIndex, this.sortedColumnAscending);
        Object var1_1 = null;
        ((SortedTableModel)this.getModel()).tableEntriesChanged();
    }

    protected void setSelectedItems(ArrayList arrayList) {
        if (!(this.getModel() instanceof SortedTableModel)) {
            return;
        }
        SortedTableModel sortedTableModel = (SortedTableModel)this.getModel();
        for (int i = 0; i < sortedTableModel.getRowCount(); ++i) {
            TableMember tableMember = sortedTableModel.getRow(i);
            for (Object e : arrayList) {
                if (tableMember != e) continue;
                this.getSelectionModel().addSelectionInterval(i, i);
            }
        }
    }

    protected ArrayList getListOfSelectedItems() {
        ArrayList<TableMember> arrayList = new ArrayList<TableMember>();
        if (!(this.getModel() instanceof SortedTableModel)) {
            return arrayList;
        }
        SortedTableModel sortedTableModel = (SortedTableModel)this.getModel();
        int[] nArray = this.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(sortedTableModel.getRow(nArray[i]));
        }
        return arrayList;
    }

    public void setSavedSettings(int n, boolean bl) {
        if (!(this.getModel() instanceof SortedTableModel)) {
            return;
        }
        this.sortedColumnIndex = n;
        this.sortedColumnAscending = bl;
        SortedTableModel sortedTableModel = (SortedTableModel)this.getModel();
        this.sortColumn(this.sortedColumnIndex, this.sortedColumnAscending);
    }

    protected void initSortHeader() {
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setHeaderRenderer(this.columnHeadersRenderer);
        }
        this.getTableHeader().addMouseListener(new HeaderMouseListener());
    }

    public int getSortedColumnIndex() {
        return this.sortedColumnIndex;
    }

    public boolean isSortedColumnAscending() {
        return this.sortedColumnAscending;
    }

    public SortedTable instance() {
        return this;
    }

    class HeaderMouseListener
    implements MouseListener {
        HeaderMouseListener() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                return;
            }
            TableColumnModel tableColumnModel = SortedTable.this.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = tableColumnModel.getColumn(n).getModelIndex();
            SortedTableModel sortedTableModel = null;
            sortedTableModel = (SortedTableModel)SortedTable.this.getModel();
            boolean bl = false;
            if (sortedTableModel != null && sortedTableModel.isSortable(n2)) {
                bl = true;
            }
            if (bl) {
                if (SortedTable.this.sortedColumnIndex == n2) {
                    SortedTable.this.sortedColumnAscending = !SortedTable.this.sortedColumnAscending;
                }
                SortedTable.this.sortedColumnIndex = n2;
                SortedTable.this.sortColumn(n2, SortedTable.this.sortedColumnAscending);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

