/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.gui.SortedTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class SortHeaderRenderer
extends DefaultTableCellRenderer {
    public static Icon NONSORTED = new SortArrowIcon(0);
    public static Icon ASCENDING = new SortArrowIcon(2);
    public static Icon DECENDING = new SortArrowIcon(1);

    public SortHeaderRenderer() {
        this.setHorizontalTextPosition(2);
        this.setHorizontalAlignment(0);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        TableCellRenderer tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        if (tableCellRenderer == null) {
            if (jTable instanceof SortedTable) {
                Icon icon = this.getArrow((SortedTable)jTable, n2);
                this.setIcon(icon);
            }
            this.setText(object == null ? "" : object.toString());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
        if (tableCellRenderer instanceof JLabel && jTable instanceof SortedTable) {
            Icon icon = this.getArrow((SortedTable)jTable, n2);
            ((JLabel)((Object)tableCellRenderer)).setIcon(icon);
        }
        return tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
    }

    private Icon getArrow(SortedTable sortedTable, int n) {
        int n2 = -1;
        int n3 = -1;
        boolean bl = true;
        n2 = sortedTable.getSortedColumnIndex();
        bl = sortedTable.isSortedColumnAscending();
        TableColumnModel tableColumnModel = sortedTable.getColumnModel();
        n3 = tableColumnModel.getColumn(n).getModelIndex();
        Icon icon = bl ? ASCENDING : DECENDING;
        return n3 == n2 ? icon : NONSORTED;
    }

    static class SortArrowIcon
    implements Icon {
        public static final int NONE = 0;
        public static final int DECENDING = 1;
        public static final int ASCENDING = 2;
        protected int direction;
        protected int width = 8;
        protected int height = 8;

        public SortArrowIcon(int n) {
            this.direction = n;
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = component.getBackground();
            Color color2 = color.brighter();
            Color color3 = color.darker();
            int n3 = this.width;
            int n4 = this.height;
            int n5 = n3 / 2;
            if (this.direction == 2) {
                graphics.setColor(color3);
                graphics.drawLine(n, n2, n + n3, n2);
                graphics.drawLine(n, n2, n + n5, n2 + n4);
                graphics.setColor(color2);
                graphics.drawLine(n + n3, n2, n + n5, n2 + n4);
            }
            if (this.direction == 1) {
                graphics.setColor(color3);
                graphics.drawLine(n + n5, n2, n, n2 + n4);
                graphics.setColor(color2);
                graphics.drawLine(n, n2 + n4, n + n3, n2 + n4);
                graphics.drawLine(n + n5, n2, n + n3, n2 + n4);
            }
        }
    }
}

