/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.SettingsClass;
import frost.messages.MessageObject;
import frost.util.gui.AntialiasedTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

public class MessageWindow
extends JFrame {
    private static Logger logger = Logger.getLogger(MessageWindow.class.getName());
    private final MessageObject message;
    private AntialiasedTextArea messageTextArea;
    private JScrollPane scrollpane;
    private MessageWindow messageWindow;
    private Listener listener;
    private SettingsClass settings;
    private Window parentWindow;

    public MessageWindow(SettingsClass settingsClass, Window window, MessageObject messageObject, Dimension dimension) {
        this.setSize(dimension);
        this.message = messageObject;
        this.parentWindow = window;
        this.settings = settingsClass;
        this.initialize();
    }

    private void initialize() {
        this.listener = new Listener();
        this.messageWindow = this;
        this.setTitle(this.message.getSubject());
        this.messageTextArea = new AntialiasedTextArea();
        this.messageTextArea.setAntiAliasEnabled(this.settings.getBoolValue("messageBodyAA"));
        this.messageTextArea.setWrapStyleWord(true);
        this.messageTextArea.setLineWrap(true);
        this.messageTextArea.setEditable(false);
        this.messageTextArea.setText(this.message.getContent());
        this.messageTextArea.addKeyListener(this.listener);
        this.addKeyListener(this.listener);
        this.addWindowListener(this.listener);
        this.settings.addPropertyChangeListener("messageBodyFontName", this.listener);
        this.settings.addPropertyChangeListener("messageBodyFontSize", this.listener);
        this.settings.addPropertyChangeListener("messageBodyFontStyle", this.listener);
        this.settings.addPropertyChangeListener("messageBodyAA", this.listener);
        this.fontChanged();
        this.scrollpane = new JScrollPane();
        this.scrollpane.getViewport().add(this.messageTextArea);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.scrollpane, "Center");
        ImageIcon imageIcon = new ImageIcon(MessageWindow.class.getResource("/data/messagebright.gif"));
        this.setIconImage(imageIcon.getImage());
        this.setLocationRelativeTo(this.parentWindow);
    }

    private void fontChanged() {
        int n;
        int n2;
        String string = this.settings.getValue("messageBodyFontName");
        Font font = new Font(string, n2 = this.settings.getIntValue("messageBodyFontStyle"), n = this.settings.getIntValue("messageBodyFontSize"));
        if (!font.getFamily().equals(string)) {
            logger.severe("The selected font was not found in your system\nThat selection will be changed to \"Monospaced\".");
            this.settings.setValue("messageBodyFontName", "Monospaced");
            font = new Font("Monospaced", n2, n);
        }
        this.messageTextArea.setFont(font);
        string = this.settings.getValue("messageListFontName");
        n2 = this.settings.getIntValue("messageListFontStyle");
        n = this.settings.getIntValue("messageListFontSize");
        font = new Font(string, n2, n);
        if (!font.getFamily().equals(string)) {
            logger.severe("The selected font was not found in your system\nThat selection will be changed to \"SansSerif\".");
            this.settings.setValue("messageListFontName", "SansSerif");
            font = new Font("SansSerif", n2, n);
        }
    }

    private void close() {
        this.settings.removePropertyChangeListener("messageBodyFontName", this.listener);
        this.settings.removePropertyChangeListener("messageBodyFontSize", this.listener);
        this.settings.removePropertyChangeListener("messageBodyFontStyle", this.listener);
        this.settings.removePropertyChangeListener("messageBodyAA", this.listener);
        this.dispose();
    }

    private class Listener
    extends WindowAdapter
    implements KeyListener,
    PropertyChangeListener,
    WindowListener {
        private Listener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.maybeDoSomething(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            MessageWindow.this.close();
        }

        public void maybeDoSomething(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\u001b') {
                MessageWindow.this.close();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("messageBodyFontName")) {
                MessageWindow.this.fontChanged();
            }
            if (propertyChangeEvent.getPropertyName().equals("messageBodyFontSize")) {
                MessageWindow.this.fontChanged();
            }
            if (propertyChangeEvent.getPropertyName().equals("messageBodyFontStyle")) {
                MessageWindow.this.fontChanged();
            }
        }
    }
}

