/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.util.gui.translation.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class MessageUploadFailedDialog
extends JDialog {
    private static final int SECONDS_TO_WAIT = 30;
    public static final int NO_VALUE = 0;
    public static final int RETRY_VALUE = 1;
    public static final int RETRY_NEXT_STARTUP_VALUE = 2;
    public static final int DISCARD_VALUE = 3;
    private JPanel messagePanel;
    private JButton retryButton;
    private JButton discardButton;
    private JButton tryOnNextStartupButton;
    private String retryButtonText;
    private RetryButtonTimer timer;
    private int userAnswer = 0;

    public MessageUploadFailedDialog(Frame frame) {
        super(frame, true);
        Language language = Language.getInstance();
        this.retryButtonText = language.getString("Retry") + " - ";
        this.setTitle(language.getString("Upload of message failed"));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.getContentPane().add(jPanel);
        BorderLayout borderLayout = new BorderLayout(0, 15);
        jPanel.setLayout(borderLayout);
        this.timer = new RetryButtonTimer(30);
        Icon icon = UIManager.getIcon("OptionPane.warningIcon");
        String string = "  " + language.getString("Frost was not able to upload your message.");
        jPanel.add((Component)new JLabel(string, icon, 2), "North");
        jPanel.add((Component)this.getButtonPanel(language), "South");
        ButtonListener buttonListener = new ButtonListener();
        this.retryButton.addActionListener(buttonListener);
        this.tryOnNextStartupButton.addActionListener(buttonListener);
        this.discardButton.addActionListener(buttonListener);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    public int startDialog() {
        this.retryButton.requestFocus();
        this.timer.start();
        this.setModal(true);
        this.setVisible(true);
        return this.userAnswer;
    }

    private JPanel getButtonPanel(Language language) {
        JPanel jPanel = new JPanel(new FlowLayout(1, 15, 0));
        this.retryButton = new JButton(this.retryButtonText + 30);
        this.discardButton = new JButton(language.getString("Discard message"));
        this.tryOnNextStartupButton = new JButton(language.getString("Retry on next startup"));
        jPanel.add(this.retryButton);
        jPanel.add(this.tryOnNextStartupButton);
        jPanel.add(this.discardButton);
        return jPanel;
    }

    public void dispose() {
        this.timer.cancel();
        super.dispose();
    }

    private class RetryButtonTimer
    extends Timer {
        private int secs;

        public RetryButtonTimer(int n) {
            this.secs = n;
        }

        public void start() {
            this.scheduleAtFixedRate(new TimerTask(){

                public void run() {
                    RetryButtonTimer.this.timerTriggered();
                }
            }, 1000L, 1000L);
        }

        private void timerTriggered() {
            --this.secs;
            MessageUploadFailedDialog.this.retryButton.setText(MessageUploadFailedDialog.this.retryButtonText + this.secs);
            if (this.secs == 0) {
                MessageUploadFailedDialog.this.userAnswer = 1;
                MessageUploadFailedDialog.this.dispose();
            }
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == MessageUploadFailedDialog.this.retryButton) {
                MessageUploadFailedDialog.this.userAnswer = 1;
            } else if (actionEvent.getSource() == MessageUploadFailedDialog.this.tryOnNextStartupButton) {
                MessageUploadFailedDialog.this.userAnswer = 2;
            } else if (actionEvent.getSource() == MessageUploadFailedDialog.this.discardButton) {
                MessageUploadFailedDialog.this.userAnswer = 3;
            }
            MessageUploadFailedDialog.this.dispose();
        }
    }
}

