/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.gui.SortedTable;
import frost.gui.model.MessageTableModel;
import frost.gui.objects.FrostMessageObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class MessageTable
extends SortedTable {
    private CellRenderer cellRenderer = new CellRenderer();

    public MessageTable(MessageTableModel messageTableModel) {
        super(messageTableModel);
        this.setDefaultRenderer(Object.class, this.cellRenderer);
        this.sortedColumnIndex = 4;
        this.sortedColumnAscending = false;
        this.resortTable();
    }

    public void createDefaultColumnsFromModel() {
        super.createDefaultColumnsFromModel();
        int[] nArray = new int[]{30, 150, 250, 50, 150};
        for (int i = 0; i < nArray.length; ++i) {
            this.getColumnModel().getColumn(i).setPreferredWidth(nArray[i]);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.cellRenderer != null) {
            this.cellRenderer.setFont(font);
        }
        this.setRowHeight(font.getSize() + 5);
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        private Font boldFont = null;
        private Font normalFont = null;
        private boolean isDeleted = false;
        private final Color col_good = new Color(0, 128, 0);
        private final Color col_check = new Color(255, 204, 0);
        private final Color col_observe = new Color(0, 208, 0);
        private final Color col_bad = new Color(255, 0, 0);

        public CellRenderer() {
            Font font = MessageTable.this.getFont();
            this.normalFont = font.deriveFont(0);
            this.boldFont = font.deriveFont(1);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.isDeleted) {
                Dimension dimension = this.getSize();
                graphics.drawLine(0, dimension.height / 2, dimension.width, dimension.height / 2);
            }
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            MessageTableModel messageTableModel = (MessageTableModel)MessageTable.this.getModel();
            FrostMessageObject frostMessageObject = (FrostMessageObject)messageTableModel.getRow(n);
            TableColumn tableColumn = MessageTable.this.getColumnModel().getColumn(n2);
            n2 = tableColumn.getModelIndex();
            if (n2 == 1) {
                if (frostMessageObject.isMessageNew()) {
                    this.setFont(this.boldFont);
                } else {
                    this.setFont(this.normalFont);
                }
                if (!bl) {
                    if (frostMessageObject.getRecipient() != null && frostMessageObject.getRecipient().length() > 0) {
                        this.setForeground(Color.RED);
                    } else if (frostMessageObject.containsAttachments()) {
                        this.setForeground(Color.BLUE);
                    } else {
                        this.setForeground(Color.BLACK);
                    }
                }
            } else if (n2 == 3) {
                int n3 = frostMessageObject.getMsgStatus();
                if (n3 == 1) {
                    this.setFont(this.boldFont);
                    this.setForeground(this.col_good);
                } else if (n3 == 2) {
                    this.setFont(this.boldFont);
                    this.setForeground(this.col_check);
                } else if (n3 == 4) {
                    this.setFont(this.boldFont);
                    this.setForeground(this.col_observe);
                } else if (n3 == 3) {
                    this.setFont(this.boldFont);
                    this.setForeground(this.col_bad);
                } else {
                    this.setFont(this.normalFont);
                    if (!bl) {
                        this.setForeground(Color.BLACK);
                    }
                }
            } else {
                this.setFont(this.normalFont);
                if (!bl) {
                    this.setForeground(Color.BLACK);
                }
            }
            this.setDeleted(frostMessageObject.isDeleted());
            return this;
        }

        public void setFont(Font font) {
            super.setFont(font);
            this.normalFont = font.deriveFont(0);
            this.boldFont = font.deriveFont(1);
        }

        public void setDeleted(boolean bl) {
            this.isDeleted = bl;
        }
    }
}

