/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.Core;
import frost.DateFun;
import frost.FileAccess;
import frost.MainFrame;
import frost.Mixed;
import frost.SettingsClass;
import frost.boards.TofTree;
import frost.gui.SortedTable;
import frost.gui.model.SortedTableModel;
import frost.gui.model.TableMember;
import frost.gui.objects.Board;
import frost.identities.Identity;
import frost.identities.LocalIdentity;
import frost.messages.BoardAttachment;
import frost.messages.FECRedirectFileObject;
import frost.messages.FileAttachment;
import frost.messages.MessageObject;
import frost.messages.SharedFileObject;
import frost.storage.StorageException;
import frost.util.gui.AntialiasedTextArea;
import frost.util.gui.ImmutableArea;
import frost.util.gui.ImmutableAreasDocument;
import frost.util.gui.JSkinnablePopupMenu;
import frost.util.gui.MiscToolkit;
import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class MessageFrame
extends JFrame {
    private LocalIdentity myId;
    private static Logger logger = Logger.getLogger(MessageFrame.class.getName());
    private Language language;
    private Listener listener = new Listener();
    private boolean initialized = false;
    private Board board;
    private String from;
    private String subject;
    private String lastUsedDirectory;
    private String keypool;
    private boolean state;
    private SettingsClass frostSettings;
    private MFAttachedBoardsTable boardsTable;
    private MFAttachedFilesTable filesTable;
    private MFAttachedBoardsTableModel boardsTableModel;
    private MFAttachedFilesTableModel filesTableModel;
    private JSplitPane messageSplitPane = null;
    private JSplitPane attachmentsSplitPane = null;
    private JScrollPane filesTableScrollPane;
    private JScrollPane boardsTableScrollPane;
    private JSkinnablePopupMenu attFilesPopupMenu;
    private JSkinnablePopupMenu attBoardsPopupMenu;
    private MessageBodyPopupMenu messageBodyPopupMenu;
    private JButton Bsend = new JButton(new ImageIcon(this.getClass().getResource("/data/send.gif")));
    private JButton Bcancel = new JButton(new ImageIcon(this.getClass().getResource("/data/remove.gif")));
    private JButton BattachFile = new JButton(new ImageIcon(this.getClass().getResource("/data/attachment.gif")));
    private JButton BattachBoard = new JButton(new ImageIcon(MainFrame.class.getResource("/data/attachmentBoard.gif")));
    private JCheckBox sign = new JCheckBox();
    JCheckBox encrypt = new JCheckBox();
    JComboBox buddies;
    private JCheckBox addAttachedFilesToUploadTable = new JCheckBox();
    private JLabel Lboard = new JLabel();
    private JLabel Lfrom = new JLabel();
    private JLabel Lsubject = new JLabel();
    private JTextField TFboard = new JTextField();
    private JTextField fromTextField = new JTextField();
    private JTextField subjectTextField = new JTextField();
    private AntialiasedTextArea messageTextArea = new AntialiasedTextArea();
    private ImmutableArea headerArea = null;
    private String oldSender = null;
    private String signature = null;
    private TofTree tofTree;
    private Window parentWindow;

    public MessageFrame(SettingsClass settingsClass, Window window, LocalIdentity localIdentity) {
        this.parentWindow = window;
        this.language = Language.getInstance();
        this.myId = localIdentity;
        this.state = false;
        this.frostSettings = settingsClass;
        this.lastUsedDirectory = this.frostSettings.getValue("lastUsedDirectory");
        this.keypool = this.frostSettings.getValue("keypool.dir");
        String string = this.frostSettings.getValue("messageBodyFontName");
        int n = this.frostSettings.getIntValue("messageBodyFontStyle");
        int n2 = this.frostSettings.getIntValue("messageBodyFontSize");
        Font font = new Font(string, n, n2);
        if (!font.getFamily().equals(string)) {
            logger.severe("The selected font was not found in your system\nThat selection will be changed to \"Monospaced\".");
            this.frostSettings.setValue("messageBodyFontName", "Monospaced");
            font = new Font("Monospaced", n, n2);
        }
        this.messageTextArea.setFont(font);
        this.messageTextArea.setAntiAliasEnabled(this.frostSettings.getBoolValue("messageBodyAA"));
        ImmutableAreasDocument immutableAreasDocument = new ImmutableAreasDocument();
        this.headerArea = new ImmutableArea(immutableAreasDocument);
        immutableAreasDocument.addImmutableArea(this.headerArea);
        this.messageTextArea.setDocument(immutableAreasDocument);
    }

    private void attachBoards_actionPerformed(ActionEvent actionEvent) {
        Vector vector = MainFrame.getInstance().getTofTreeModel().getAllBoards();
        if (vector.size() == 0) {
            return;
        }
        Collections.sort(vector);
        AttachBoardsChooser attachBoardsChooser = new AttachBoardsChooser(vector);
        attachBoardsChooser.setLocationRelativeTo(this);
        Vector vector2 = attachBoardsChooser.runDialog();
        if (vector2 == null || vector2.size() == 0) {
            return;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            int n;
            Board board = (Board)vector2.get(i);
            String string = board.getPrivateKey();
            if (string != null && (n = JOptionPane.showConfirmDialog(this, this.language.getString("MessageFrame.ConfirmBody1") + board.getName() + this.language.getString("MessageFrame.ConfirmBody2"), this.language.getString("MessageFrame.ConfirmTitle"), 0)) == 1) {
                string = null;
            }
            Board board2 = new Board(board.getName(), board.getPublicKey(), string, board.getDescription());
            MFAttachedBoard mFAttachedBoard = new MFAttachedBoard(board2);
            this.boardsTableModel.addRow(mFAttachedBoard);
        }
        this.positionDividers();
    }

    private void attachFile_actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this.lastUsedDirectory);
        jFileChooser.setDialogTitle(this.language.getString("Choose file(s) / directory(s) to attach"));
        jFileChooser.setFileHidingEnabled(false);
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setMultiSelectionEnabled(true);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File[] fileArray = jFileChooser.getSelectedFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.lastUsedDirectory = fileArray[i].getPath();
                ArrayList arrayList = FileAccess.getAllEntries(fileArray[i], "");
                for (int j = 0; j < arrayList.size(); ++j) {
                    File file = (File)arrayList.get(j);
                    if (!file.isFile() || file.length() <= 0L) continue;
                    MFAttachedFile mFAttachedFile = new MFAttachedFile(file);
                    this.filesTableModel.addRow(mFAttachedFile);
                }
            }
        } else {
            logger.fine("Open command cancelled by user.");
        }
        this.positionDividers();
    }

    private void cancel_actionPerformed(ActionEvent actionEvent) {
        this.state = false;
        this.dispose();
    }

    private void composeMessage(Board board, String string, String string2, String string3, boolean bl, Identity identity) {
        this.headerArea.setEnabled(false);
        this.board = board;
        this.from = string;
        this.subject = string2;
        String string4 = string3;
        String string5 = DateFun.getExtendedDate() + " - " + DateFun.getFullExtendedTime() + "GMT";
        if (bl) {
            string4 = string4 + "\n\n";
        }
        int n = string4.length();
        string4 = string4 + "----- " + this.from + " ----- " + string5 + " -----\n\n";
        int n2 = string4.length() - 2;
        this.oldSender = this.from;
        int n3 = string4.length();
        File file = new File("signature.txt");
        if (file.isFile()) {
            this.signature = FileAccess.readFile("signature.txt", "UTF-8").trim();
            if (this.signature != null) {
                this.signature = this.signature.trim();
                this.signature = this.signature.length() > 0 ? "\n-- \n" + this.signature : null;
            }
        }
        this.enableEvents(64L);
        try {
            this.initialize();
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Exception thrown in composeMessage(...)", exception);
        }
        if (identity != null) {
            this.sign.setSelected(true);
            this.encrypt.setSelected(true);
            this.buddies.removeAllItems();
            this.buddies.addItem(identity);
            this.buddies.setSelectedItem(identity);
        }
        if (this.sign.isSelected() && this.signature != null) {
            string4 = string4 + this.signature;
        }
        this.messageTextArea.setText(string4);
        this.headerArea.setStartPos(n);
        this.headerArea.setEndPos(n2);
        this.headerArea.setEnabled(true);
        this.setVisible(true);
        this.positionDividers();
        this.messageTextArea.requestFocusInWindow();
        this.messageTextArea.getCaret().setDot(n3);
        this.messageTextArea.getCaret().setVisible(true);
    }

    public void composeNewMessage(Board board, String string, String string2, String string3) {
        this.composeMessage(board, string, string2, string3, false, null);
    }

    public void composeReply(Board board, String string, String string2, String string3) {
        this.composeMessage(board, string, string2, string3, true, null);
    }

    public void composeEncryptedReply(Board board, String string, String string2, String string3, Identity identity) {
        this.composeMessage(board, string, string2, string3, true, identity);
    }

    public void dispose() {
        if (this.initialized) {
            this.language.removeLanguageListener(this.listener);
            this.initialized = false;
        }
        super.dispose();
    }

    private MessageBodyPopupMenu getMessageBodyPopupMenu() {
        if (this.messageBodyPopupMenu == null) {
            this.messageBodyPopupMenu = new MessageBodyPopupMenu(this.messageTextArea);
        }
        return this.messageBodyPopupMenu;
    }

    private void initialize() throws Exception {
        if (!this.initialized) {
            this.refreshLanguage();
            this.language.addLanguageListener(this.listener);
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/data/newmessage.gif"));
            this.setIconImage(imageIcon.getImage());
            this.setResizable(true);
            this.boardsTableModel = new MFAttachedBoardsTableModel();
            this.boardsTable = new MFAttachedBoardsTable(this.boardsTableModel);
            this.boardsTableScrollPane = new JScrollPane(this.boardsTable);
            this.boardsTable.addMouseListener(this.listener);
            this.filesTableModel = new MFAttachedFilesTableModel();
            this.filesTable = new MFAttachedFilesTable(this.filesTableModel);
            this.filesTableScrollPane = new JScrollPane(this.filesTable);
            this.filesTable.addMouseListener(this.listener);
            List list = Core.getInstance().getIdentities().getAllIdentitiesWithState(1);
            Vector vector = new Vector(list);
            if (vector.size() > 0) {
                Collections.sort(vector, new BuddyComparator());
                this.buddies = new JComboBox(vector);
                this.buddies.setSelectedItem(vector.get(0));
            } else {
                this.buddies = new JComboBox();
            }
            this.buddies.setMaximumSize(new Dimension(300, 25));
            MiscToolkit miscToolkit = MiscToolkit.getInstance();
            miscToolkit.configureButton(this.Bsend, "Send message", "/data/send_rollover.gif", this.language);
            miscToolkit.configureButton(this.Bcancel, "Cancel", "/data/remove_rollover.gif", this.language);
            miscToolkit.configureButton(this.BattachFile, "Add attachment(s)", "/data/attachment_rollover.gif", this.language);
            miscToolkit.configureButton(this.BattachBoard, "Add Board(s)", "/data/attachmentBoard_rollover.gif", this.language);
            this.TFboard.setEditable(false);
            this.TFboard.setText(this.board.getName());
            this.fromTextField.setText(this.from);
            new TextComponentClipboardMenu(this.TFboard, this.language);
            new TextComponentClipboardMenu(this.fromTextField, this.language);
            new TextComponentClipboardMenu(this.subjectTextField, this.language);
            this.subjectTextField.setText(this.subject);
            this.messageTextArea.setLineWrap(true);
            this.messageTextArea.setWrapStyleWord(true);
            this.messageTextArea.addMouseListener(this.listener);
            if (this.from.equals(this.myId.getUniqueName())) {
                this.fromTextField.setEditable(false);
                this.sign.setSelected(true);
            }
            if (this.sign.isSelected() && this.buddies.getItemCount() > 0) {
                this.encrypt.setEnabled(true);
            } else {
                this.encrypt.setEnabled(false);
            }
            this.encrypt.setSelected(false);
            this.buddies.setEnabled(false);
            this.addAttachedFilesToUploadTable.setSelected(false);
            this.Bsend.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MessageFrame.this.send_actionPerformed(actionEvent);
                }
            });
            this.Bcancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MessageFrame.this.cancel_actionPerformed(actionEvent);
                }
            });
            this.BattachFile.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MessageFrame.this.attachFile_actionPerformed(actionEvent);
                }
            });
            this.BattachBoard.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MessageFrame.this.attachBoards_actionPerformed(actionEvent);
                }
            });
            this.sign.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MessageFrame.this.sign_ActionPerformed(actionEvent);
                }
            });
            this.encrypt.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MessageFrame.this.encrypt_ActionPerformed(actionEvent);
                }
            });
            this.fromTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    MessageFrame.this.updateHeaderArea();
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    MessageFrame.this.updateHeaderArea();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    MessageFrame.this.updateHeaderArea();
                }
            });
            AbstractDocument abstractDocument = (AbstractDocument)this.fromTextField.getDocument();
            abstractDocument.setDocumentFilter(new DocumentFilter(){

                public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
                    if (MessageFrame.this.fromTextField.isEditable()) {
                        string = string.replaceAll("@", "");
                    }
                    super.insertString(filterBypass, n, string, attributeSet);
                }

                public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                    if (MessageFrame.this.fromTextField.isEditable()) {
                        string = string.replaceAll("@", "");
                    }
                    super.replace(filterBypass, n, n2, string, attributeSet);
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new BorderLayout());
            JPanel jPanel3 = new JPanel(new BorderLayout());
            JPanel jPanel4 = new JPanel(new BorderLayout());
            JPanel jPanel5 = new JPanel(new FlowLayout(0, 6, 0));
            JScrollPane jScrollPane = new JScrollPane(this.messageTextArea);
            jScrollPane.setMinimumSize(new Dimension(100, 50));
            jPanel4.add((Component)this.Lboard, "North");
            jPanel4.add((Component)this.Lfrom, "Center");
            jPanel4.add((Component)this.Lsubject, "South");
            jPanel2.add((Component)this.TFboard, "North");
            jPanel2.add((Component)this.fromTextField, "Center");
            jPanel2.add((Component)this.subjectTextField, "South");
            jPanel5.add(this.Bsend);
            jPanel5.add(this.Bcancel);
            jPanel5.add(this.BattachFile);
            jPanel5.add(this.BattachBoard);
            jPanel5.add(this.sign);
            jPanel5.add(this.encrypt);
            jPanel5.add(this.buddies);
            jPanel5.add(this.addAttachedFilesToUploadTable);
            JPanel jPanel6 = new JPanel(new BorderLayout());
            jPanel6.add((Component)jPanel4, "West");
            jPanel6.add((Component)jPanel2, "Center");
            jPanel3.add((Component)jPanel5, "North");
            jPanel3.add((Component)jPanel6, "South");
            this.attachmentsSplitPane = new JSplitPane(0, this.filesTableScrollPane, this.boardsTableScrollPane);
            this.attachmentsSplitPane.setResizeWeight(0.5);
            this.attachmentsSplitPane.setDividerSize(3);
            this.attachmentsSplitPane.setDividerLocation(0.5);
            this.messageSplitPane = new JSplitPane(0, jScrollPane, this.attachmentsSplitPane);
            this.messageSplitPane.setDividerSize(0);
            this.messageSplitPane.setDividerLocation(1.0);
            this.messageSplitPane.setResizeWeight(1.0);
            jPanel.add((Component)jPanel3, "North");
            jPanel.add((Component)this.messageSplitPane, "Center");
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)jPanel, "Center");
            this.initPopupMenu();
            this.pack();
            int n = this.getWidth();
            if (n < (int)((double)this.parentWindow.getWidth() * 0.75)) {
                n = (int)((double)this.parentWindow.getWidth() * 0.75);
            }
            this.setSize(n, (int)((double)this.parentWindow.getHeight() * 0.75));
            this.setLocationRelativeTo(this.parentWindow);
            this.initialized = true;
        }
    }

    protected void initPopupMenu() {
        this.attFilesPopupMenu = new JSkinnablePopupMenu();
        this.attBoardsPopupMenu = new JSkinnablePopupMenu();
        JMenuItem jMenuItem = new JMenuItem(this.language.getString("Remove"));
        JMenuItem jMenuItem2 = new JMenuItem(this.language.getString("Remove"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageFrame.this.removeSelectedItemsFromTable(MessageFrame.this.filesTable);
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageFrame.this.removeSelectedItemsFromTable(MessageFrame.this.boardsTable);
            }
        });
        this.attFilesPopupMenu.add(jMenuItem);
        this.attBoardsPopupMenu.add(jMenuItem2);
    }

    private void positionDividers() {
        int n = this.filesTableModel.getRowCount();
        int n2 = this.boardsTableModel.getRowCount();
        if (n == 0 && n2 == 0) {
            this.messageSplitPane.setBottomComponent(null);
            this.messageSplitPane.setDividerSize(0);
            return;
        }
        this.messageSplitPane.setDividerSize(3);
        this.messageSplitPane.setDividerLocation(0.75);
        if (n != 0 && n2 == 0) {
            this.messageSplitPane.setBottomComponent(this.filesTableScrollPane);
            return;
        }
        if (n == 0 && n2 != 0) {
            this.messageSplitPane.setBottomComponent(this.boardsTableScrollPane);
            return;
        }
        if (n != 0 && n2 != 0) {
            this.messageSplitPane.setBottomComponent(this.attachmentsSplitPane);
            this.attachmentsSplitPane.setTopComponent(this.filesTableScrollPane);
            this.attachmentsSplitPane.setBottomComponent(this.boardsTableScrollPane);
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.dispose();
        }
        super.processWindowEvent(windowEvent);
    }

    private void refreshLanguage() {
        this.setTitle(this.language.getString("Create message"));
        this.Bsend.setToolTipText(this.language.getString("Send message"));
        this.Bcancel.setToolTipText(this.language.getString("Cancel"));
        this.BattachFile.setToolTipText(this.language.getString("Add attachment(s)"));
        this.BattachBoard.setToolTipText(this.language.getString("Add Board(s)"));
        this.sign.setText(this.language.getString("Sign"));
        this.encrypt.setText(this.language.getString("Encrypt for"));
        this.addAttachedFilesToUploadTable.setText(this.language.getString("Indexed attachments"));
        this.addAttachedFilesToUploadTable.setToolTipText(this.language.getString("Should file attachments be added to upload table?"));
        this.Lboard.setText(this.language.getString("Board") + ": ");
        this.Lfrom.setText(this.language.getString("From") + ": ");
        this.Lsubject.setText(this.language.getString("Subject") + ": ");
    }

    protected void removeSelectedItemsFromTable(JTable jTable) {
        SortedTableModel sortedTableModel = (SortedTableModel)jTable.getModel();
        int[] nArray = jTable.getSelectedRows();
        for (int i = nArray.length - 1; i >= 0; --i) {
            sortedTableModel.removeRow(nArray[i]);
        }
        this.positionDividers();
    }

    private void send_actionPerformed(ActionEvent actionEvent) {
        BoardAttachment boardAttachment;
        Comparable<File> comparable;
        Object object;
        int n;
        int n2;
        this.from = this.fromTextField.getText().trim();
        this.fromTextField.setText(this.from);
        this.subject = this.subjectTextField.getText().trim();
        this.subjectTextField.setText(this.subject);
        String string = this.messageTextArea.getText().trim();
        if (this.subject.equals("No subject") && (n2 = JOptionPane.showConfirmDialog(this, this.language.getString("Do you want to enter a subject?"), this.language.getString("No subject specified!"), 0, 3)) == 0) {
            return;
        }
        if (this.subject.length() == 0) {
            JOptionPane.showMessageDialog(this, this.language.getString("You must enter a subject!"), this.language.getString("No subject specified!"), 64);
            return;
        }
        if (this.from.length() == 0) {
            JOptionPane.showMessageDialog(this, this.language.getString("You must enter a sender name!"), this.language.getString("No 'From' specified!"), 64);
            return;
        }
        n2 = 65536;
        if (string.length() > n2) {
            JOptionPane.showMessageDialog(this, "The text of the message is too large (" + string.length() + " characters, " + n2 + " allowed)!", "Message text too large!", 0);
            return;
        }
        this.frostSettings.setValue("userName", this.from);
        MessageObject messageObject = new MessageObject();
        messageObject.setBoard(this.board.getName());
        messageObject.setFrom(this.from);
        messageObject.setSubject(this.subject);
        messageObject.setContent(string);
        if (this.sign.isSelected()) {
            messageObject.setPublicKey(this.myId.getKey());
        }
        for (n = 0; n < this.filesTableModel.getRowCount(); ++n) {
            object = (MFAttachedFile)this.filesTableModel.getRow(n);
            comparable = ((MFAttachedFile)object).getFile();
            boardAttachment = null;
            SharedFileObject sharedFileObject = ((File)comparable).length() > 786432L ? new FECRedirectFileObject((File)comparable, (Board)((Object)boardAttachment)) : new SharedFileObject((File)comparable, (Board)((Object)boardAttachment));
            if (this.addAttachedFilesToUploadTable.isSelected()) {
                sharedFileObject.setOwner(this.sign.isSelected() ? Mixed.makeFilename(this.myId.getUniqueName()) : "Anonymous");
            }
            FileAttachment fileAttachment = new FileAttachment(sharedFileObject);
            messageObject.addAttachment(fileAttachment);
        }
        for (n = 0; n < this.boardsTableModel.getRowCount(); ++n) {
            object = (MFAttachedBoard)this.boardsTableModel.getRow(n);
            comparable = ((MFAttachedBoard)object).getBoardObject();
            boardAttachment = new BoardAttachment((Board)comparable);
            messageObject.addAttachment(boardAttachment);
        }
        Identity identity = null;
        if (this.encrypt.isEnabled() && this.encrypt.isSelected()) {
            identity = (Identity)this.buddies.getSelectedItem();
            if (identity == null) {
                JOptionPane.showMessageDialog(this, "Can't encrypt, no recipient choosed!", "ERROR", 64);
                return;
            }
            messageObject.setRecipient(identity.getUniqueName());
        }
        object = null;
        try {
            object = File.createTempFile("msgframe_", "_tmp", new File(this.frostSettings.getValue("temp.dir")));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (object == null) {
            object = new File("msgframe_tmp_" + System.currentTimeMillis());
        }
        ((File)object).deleteOnExit();
        if (messageObject.saveToFile((File)object)) {
            comparable = new File(((File)object).getPath() + ".zipped");
            ((File)comparable).delete();
            ((File)comparable).deleteOnExit();
            FileAccess.writeZipFile(FileAccess.readByteArray((File)object), "entry", comparable);
            long l = ((File)comparable).length();
            ((File)object).delete();
            ((File)comparable).delete();
            if (l > 30000L) {
                JOptionPane.showMessageDialog(this, "The zipped message is too large (" + l + " bytes, " + 30000 + " allowed)! Remove some text.", "Message text too large!", 0);
                return;
            }
        } else {
            JOptionPane.showMessageDialog(this, "Error verifying the resulting message size.", "Error!", 0);
            return;
        }
        this.tofTree.getRunningBoardUpdateThreads().startMessageUpload(this.board, messageObject, null, identity);
        this.frostSettings.setValue("lastUsedDirectory", this.lastUsedDirectory);
        try {
            this.frostSettings.save();
        }
        catch (StorageException storageException) {
            logger.log(Level.SEVERE, "Error while saving the settings.", storageException);
        }
        this.state = true;
        this.setVisible(false);
        this.dispose();
    }

    private void sign_ActionPerformed(ActionEvent actionEvent) {
        String string;
        if (this.sign.isSelected()) {
            string = this.myId.getUniqueName();
            this.fromTextField.setEditable(false);
            if (this.buddies.getItemCount() > 0) {
                this.encrypt.setEnabled(true);
                if (this.encrypt.isSelected()) {
                    this.buddies.setEnabled(true);
                } else {
                    this.buddies.setEnabled(true);
                }
            }
            String string2 = this.messageTextArea.getText();
            if (this.signature != null && !this.messageTextArea.getText().endsWith(this.signature)) {
                try {
                    this.messageTextArea.getDocument().insertString(string2.length(), this.signature, null);
                }
                catch (BadLocationException badLocationException) {
                    logger.log(Level.SEVERE, "Error while updating the signature ", badLocationException);
                }
            }
        } else {
            string = "Anonymous";
            this.fromTextField.setEditable(true);
            this.encrypt.setEnabled(false);
            this.buddies.setEnabled(false);
            if (this.signature != null && this.messageTextArea.getText().endsWith(this.signature)) {
                try {
                    this.messageTextArea.getDocument().remove(this.messageTextArea.getText().length() - this.signature.length(), this.signature.length());
                }
                catch (BadLocationException badLocationException) {
                    logger.log(Level.SEVERE, "Error while updating the signature ", badLocationException);
                }
            }
        }
        this.fromTextField.setText(string);
    }

    private void encrypt_ActionPerformed(ActionEvent actionEvent) {
        if (this.encrypt.isSelected()) {
            this.buddies.setEnabled(true);
        } else {
            this.buddies.setEnabled(false);
        }
    }

    private void updateHeaderArea() {
        this.headerArea.setEnabled(false);
        String string = this.fromTextField.getText();
        try {
            this.messageTextArea.getDocument().remove(this.headerArea.getStartPos() + 6, this.oldSender.length());
            this.messageTextArea.getDocument().insertString(this.headerArea.getStartPos() + 6, string, null);
            this.oldSender = string;
            this.headerArea.setEnabled(true);
        }
        catch (BadLocationException badLocationException) {
            logger.log(Level.SEVERE, "Error while updating the message header", badLocationException);
        }
    }

    public void setTofTree(TofTree tofTree) {
        this.tofTree = tofTree;
    }

    private class MFAttachedFilesTableModel
    extends SortedTableModel {
        protected final Class[] columnClasses = new Class[]{String.class, String.class};
        protected final String[] columnNames = new String[]{"Filename", "Size"};

        public Class getColumnClass(int n) {
            if (n >= 0 && n < this.columnClasses.length) {
                return this.columnClasses[n];
            }
            return null;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int n) {
            if (n >= 0 && n < this.columnNames.length) {
                return this.columnNames[n];
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
        }
    }

    private class MFAttachedFilesTable
    extends SortedTable {
        public MFAttachedFilesTable(MFAttachedFilesTableModel mFAttachedFilesTableModel) {
            super(mFAttachedFilesTableModel);
            int[] nArray = new int[]{250, 80};
            for (int i = 0; i < nArray.length; ++i) {
                this.getColumnModel().getColumn(i).setPreferredWidth(nArray[i]);
            }
            this.sortedColumnIndex = 0;
            this.sortedColumnAscending = true;
            this.resortTable();
        }
    }

    private class MFAttachedFile
    implements TableMember {
        File aFile;

        public MFAttachedFile(File file) {
            this.aFile = file;
        }

        public int compareTo(TableMember tableMember, int n) {
            Comparable comparable = (Comparable)this.getValueAt(n);
            Comparable comparable2 = (Comparable)tableMember.getValueAt(n);
            return comparable.compareTo(comparable2);
        }

        public File getFile() {
            return this.aFile;
        }

        public Object getValueAt(int n) {
            switch (n) {
                case 0: {
                    return this.aFile.getName();
                }
                case 1: {
                    return "" + this.aFile.length();
                }
            }
            return "*ERR*";
        }
    }

    private class MFAttachedBoardsTableModel
    extends SortedTableModel {
        protected final Class[] columnClasses = new Class[]{String.class, String.class, String.class, String.class};
        protected final String[] columnNames = new String[]{"Boardname", "public key", "Private key", "Description"};

        public Class getColumnClass(int n) {
            if (n >= 0 && n < this.columnClasses.length) {
                return this.columnClasses[n];
            }
            return null;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int n) {
            if (n >= 0 && n < this.columnNames.length) {
                return this.columnNames[n];
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
        }
    }

    private class MFAttachedBoardsTable
    extends SortedTable {
        public MFAttachedBoardsTable(MFAttachedBoardsTableModel mFAttachedBoardsTableModel) {
            super(mFAttachedBoardsTableModel);
            int[] nArray = new int[]{250, 80, 80};
            for (int i = 0; i < nArray.length; ++i) {
                this.getColumnModel().getColumn(i).setPreferredWidth(nArray[i]);
            }
            this.sortedColumnIndex = 0;
            this.sortedColumnAscending = true;
            this.resortTable();
        }
    }

    private class MFAttachedBoard
    implements TableMember {
        Board aBoard;

        public MFAttachedBoard(Board board) {
            this.aBoard = board;
        }

        public int compareTo(TableMember tableMember, int n) {
            Comparable comparable = (Comparable)this.getValueAt(n);
            Comparable comparable2 = (Comparable)tableMember.getValueAt(n);
            return comparable.compareTo(comparable2);
        }

        public Board getBoardObject() {
            return this.aBoard;
        }

        public Object getValueAt(int n) {
            switch (n) {
                case 0: {
                    return this.aBoard.getName();
                }
                case 1: {
                    return this.aBoard.getPublicKey() == null ? "N/A" : this.aBoard.getPublicKey();
                }
                case 2: {
                    return this.aBoard.getPrivateKey() == null ? "N/A" : this.aBoard.getPrivateKey();
                }
                case 3: {
                    return this.aBoard.getDescription() == null ? "N/A" : this.aBoard.getDescription();
                }
            }
            return "*ERR*";
        }
    }

    private class MessageBodyPopupMenu
    extends JSkinnablePopupMenu
    implements ActionListener,
    ClipboardOwner {
        private Clipboard clipboard;
        private JTextComponent sourceTextComponent;
        private JMenuItem cutItem = new JMenuItem();
        private JMenuItem copyItem = new JMenuItem();
        private JMenuItem pasteItem = new JMenuItem();
        private JMenuItem cancelItem = new JMenuItem();

        public MessageBodyPopupMenu(JTextComponent jTextComponent) {
            this.sourceTextComponent = jTextComponent;
            this.initialize();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.cutItem) {
                this.cutSelectedText();
            }
            if (actionEvent.getSource() == this.copyItem) {
                this.copySelectedText();
            }
            if (actionEvent.getSource() == this.pasteItem) {
                this.pasteText();
            }
        }

        private void copySelectedText() {
            StringSelection stringSelection = new StringSelection(this.sourceTextComponent.getSelectedText());
            this.clipboard.setContents(stringSelection, this);
        }

        private void cutSelectedText() {
            StringSelection stringSelection = new StringSelection(this.sourceTextComponent.getSelectedText());
            this.clipboard.setContents(stringSelection, this);
            int n = this.sourceTextComponent.getSelectionStart();
            int n2 = this.sourceTextComponent.getSelectionEnd();
            try {
                this.sourceTextComponent.getDocument().remove(n, n2 - n);
            }
            catch (BadLocationException badLocationException) {
                logger.log(Level.SEVERE, "Problem while cutting text.", badLocationException);
            }
        }

        private void pasteText() {
            Transferable transferable = this.clipboard.getContents(this);
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                Caret caret = this.sourceTextComponent.getCaret();
                int n = Math.min(caret.getDot(), caret.getMark());
                int n2 = Math.max(caret.getDot(), caret.getMark());
                Document document = this.sourceTextComponent.getDocument();
                if (document instanceof PlainDocument) {
                    ((PlainDocument)document).replace(n, n2 - n, string, null);
                } else {
                    if (n != n2) {
                        document.remove(n, n2 - n);
                    }
                    document.insertString(n, string, null);
                }
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, "Problem while pasting text.", iOException);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                logger.log(Level.SEVERE, "Problem while pasting text.", unsupportedFlavorException);
            }
            catch (BadLocationException badLocationException) {
                logger.log(Level.SEVERE, "Problem while pasting text.", badLocationException);
            }
        }

        private void initialize() {
            this.refreshLanguage();
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.clipboard = toolkit.getSystemClipboard();
            this.cutItem.addActionListener(this);
            this.copyItem.addActionListener(this);
            this.pasteItem.addActionListener(this);
            this.add(this.cutItem);
            this.add(this.copyItem);
            this.add(this.pasteItem);
            this.addSeparator();
            this.add(this.cancelItem);
        }

        private void refreshLanguage() {
            this.cutItem.setText(MessageFrame.this.language.getString("Cut"));
            this.copyItem.setText(MessageFrame.this.language.getString("Copy"));
            this.pasteItem.setText(MessageFrame.this.language.getString("Paste"));
            this.cancelItem.setText(MessageFrame.this.language.getString("Cancel"));
        }

        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }

        public void show(Component component, int n, int n2) {
            if (this.sourceTextComponent.getSelectedText() != null) {
                this.cutItem.setEnabled(true);
                this.copyItem.setEnabled(true);
            } else {
                this.cutItem.setEnabled(false);
                this.copyItem.setEnabled(false);
            }
            Transferable transferable = this.clipboard.getContents(this);
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                this.pasteItem.setEnabled(true);
            } else {
                this.pasteItem.setEnabled(false);
            }
            super.show(component, n, n2);
        }
    }

    private class Listener
    implements MouseListener,
    LanguageListener {
        private Listener() {
        }

        protected void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                if (mouseEvent.getSource() == MessageFrame.this.boardsTable) {
                    MessageFrame.this.attBoardsPopupMenu.show(MessageFrame.this.boardsTable, mouseEvent.getX(), mouseEvent.getY());
                }
                if (mouseEvent.getSource() == MessageFrame.this.filesTable) {
                    MessageFrame.this.attFilesPopupMenu.show(MessageFrame.this.filesTable, mouseEvent.getX(), mouseEvent.getY());
                }
                if (mouseEvent.getSource() == MessageFrame.this.messageTextArea) {
                    MessageFrame.this.getMessageBodyPopupMenu().show(MessageFrame.this.messageTextArea, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void languageChanged(LanguageEvent languageEvent) {
            MessageFrame.this.refreshLanguage();
        }
    }

    class BuddyComparator
    implements Comparator {
        BuddyComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = object.toString();
            String string2 = object2.toString();
            return string.toLowerCase().compareTo(string2.toLowerCase());
        }
    }

    private class AttachBoardsChooser
    extends JDialog {
        JButton Bcancel;
        List boards;
        JButton Bok;
        JList Lboards;
        boolean okPressed = false;

        public AttachBoardsChooser(List list) {
            this.setTitle(MessageFrame.this.language.getString("Choose boards to attach"));
            this.setModal(true);
            this.boards = list;
            this.initGui();
        }

        private void initGui() {
            this.Bok = new JButton("OK");
            this.Bok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AttachBoardsChooser.this.okPressed = true;
                    AttachBoardsChooser.this.setVisible(false);
                }
            });
            this.Bcancel = new JButton("Cancel");
            this.Bcancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AttachBoardsChooser.this.okPressed = false;
                    AttachBoardsChooser.this.setVisible(false);
                }
            });
            JPanel jPanel = new JPanel(new FlowLayout(2, 8, 8));
            jPanel.add(this.Bok);
            jPanel.add(this.Bcancel);
            AbstractListModel abstractListModel = new AbstractListModel(){

                public int getSize() {
                    return AttachBoardsChooser.this.boards.size();
                }

                public Object getElementAt(int n) {
                    return AttachBoardsChooser.this.boards.get(n);
                }
            };
            this.Lboards = new JList(abstractListModel);
            this.Lboards.setCellRenderer(new AttachBoardsCellRenderer());
            this.Lboards.setSelectionMode(2);
            JScrollPane jScrollPane = new JScrollPane(this.Lboards);
            jScrollPane.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
            this.getContentPane().add((Component)jScrollPane, "Center");
            this.getContentPane().add((Component)jPanel, "South");
            this.setSize(300, 400);
        }

        public Vector runDialog() {
            this.setVisible(true);
            if (!this.okPressed) {
                return null;
            }
            Object[] objectArray = this.Lboards.getSelectedValues();
            Vector<Object> vector = new Vector<Object>(Arrays.asList(objectArray));
            return vector;
        }

        private class AttachBoardsCellRenderer
        extends DefaultListCellRenderer {
            private AttachBoardsCellRenderer() {
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object != null) {
                    Board board = (Board)object;
                    this.setText(board.getName());
                }
                return this;
            }
        }
    }
}

