/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.Core;
import frost.MainFrame;
import frost.boards.TofTree;
import frost.gui.SortedTable;
import frost.gui.model.KnownBoardsTableModel;
import frost.gui.model.TableMember;
import frost.gui.objects.Board;
import frost.gui.objects.TargetFolderChooser;
import frost.messages.BoardAttachment;
import frost.util.gui.JSkinnablePopupMenu;
import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class KnownBoardsFrame
extends JDialog {
    private static Logger logger = Logger.getLogger(KnownBoardsFrame.class.getName());
    private Language language;
    private TofTree tofTree;
    private static ImageIcon boardIcon = new ImageIcon(KnownBoardsFrame.class.getResource("/data/board.gif"));
    private static ImageIcon writeAccessIcon = new ImageIcon(KnownBoardsFrame.class.getResource("/data/waboard.jpg"));
    private static ImageIcon readAccessIcon = new ImageIcon(KnownBoardsFrame.class.getResource("/data/raboard.jpg"));
    private JButton Bclose;
    private JButton BaddBoard;
    private JButton BaddBoardToFolder;
    private JTextField TFlookupBoard;
    private JTextField TFfilterBoard;
    private SortedTable boardsTable;
    private KnownBoardsTableModel tableModel;
    private NameColumnRenderer nameColRenderer;
    private DescColumnRenderer descColRenderer;
    private JSkinnablePopupMenu tablePopupMenu;
    private Vector allKnownBoardsList;
    private boolean savingNeeded = false;

    public KnownBoardsFrame(JFrame jFrame, TofTree tofTree) {
        this.tofTree = tofTree;
        this.language = Language.getInstance();
        this.enableEvents(64L);
        try {
            this.initialize();
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Exception thrown in constructor", exception);
        }
        this.setDefaultCloseOperation(2);
        this.setSize((int)((double)jFrame.getWidth() * 0.75), (int)((double)jFrame.getHeight() * 0.75));
        this.setLocationRelativeTo(jFrame);
    }

    private void initialize() {
        this.setModal(true);
        this.setTitle(this.language.getString("KnownBoardsFrame.List of known boards"));
        this.setResizable(true);
        this.tableModel = new KnownBoardsTableModel();
        this.nameColRenderer = new NameColumnRenderer();
        this.descColRenderer = new DescColumnRenderer();
        this.boardsTable = new SortedTable(this.tableModel){

            public TableCellRenderer getCellRenderer(int n, int n2) {
                if (n2 == 0) {
                    return KnownBoardsFrame.this.nameColRenderer;
                }
                if (n2 == 3) {
                    return KnownBoardsFrame.this.descColRenderer;
                }
                return super.getCellRenderer(n, n2);
            }
        };
        this.boardsTable.setRowSelectionAllowed(true);
        this.boardsTable.setSelectionMode(2);
        this.Bclose = new JButton(this.language.getString("KnownBoardsFrame.Close"));
        this.BaddBoard = new JButton(this.language.getString("Add Board(s)"));
        this.BaddBoardToFolder = new JButton(this.language.getString("Add Board(s) to folder") + " ...");
        this.TFlookupBoard = new JTextField(10);
        new TextComponentClipboardMenu(this.TFlookupBoard, this.language);
        this.TFlookupBoard.setMaximumSize(this.TFlookupBoard.getPreferredSize());
        this.TFlookupBoard.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                KnownBoardsFrame.this.lookupContentChanged();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                KnownBoardsFrame.this.lookupContentChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                KnownBoardsFrame.this.lookupContentChanged();
            }
        });
        this.TFfilterBoard = new JTextField(10);
        new TextComponentClipboardMenu(this.TFfilterBoard, this.language);
        this.TFfilterBoard.setMaximumSize(this.TFfilterBoard.getPreferredSize());
        this.TFfilterBoard.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                KnownBoardsFrame.this.filterContentChanged();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                KnownBoardsFrame.this.filterContentChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                KnownBoardsFrame.this.filterContentChanged();
            }
        });
        this.boardsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                KnownBoardsFrame.this.boardsTableListModel_valueChanged(listSelectionEvent);
            }
        });
        this.BaddBoard.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KnownBoardsFrame.this.addBoards_actionPerformed(actionEvent);
            }
        });
        this.BaddBoardToFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KnownBoardsFrame.this.addBoardsToFolder_actionPerformed(actionEvent);
            }
        });
        this.Bclose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KnownBoardsFrame.this.dispose();
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(new JLabel(this.language.getString("KnownBoardsFrame.Lookup") + ":"));
        jPanel2.add(Box.createRigidArea(new Dimension(5, 3)));
        jPanel2.add(this.TFlookupBoard);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 3)));
        jPanel2.add(new JLabel(this.language.getString("KnownBoardsFrame.Filter") + ":"));
        jPanel2.add(Box.createRigidArea(new Dimension(5, 3)));
        jPanel2.add(this.TFfilterBoard);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.BaddBoard);
        jPanel2.add(Box.createRigidArea(new Dimension(15, 3)));
        jPanel2.add(this.BaddBoardToFolder);
        jPanel2.add(Box.createRigidArea(new Dimension(15, 3)));
        jPanel2.add(this.Bclose);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        jPanel.add((Component)new JScrollPane(this.boardsTable), "Center");
        jPanel.add((Component)jPanel2, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 7, 7, 7));
        this.getContentPane().add((Component)jPanel, null);
        this.BaddBoard.setEnabled(false);
        this.BaddBoardToFolder.setEnabled(false);
        this.initPopupMenu();
    }

    private void initPopupMenu() {
        this.tablePopupMenu = new JSkinnablePopupMenu();
        JMenuItem jMenuItem = new JMenuItem(this.language.getString("Add Board(s)"));
        JMenuItem jMenuItem2 = new JMenuItem(this.language.getString("Add Board(s) to folder") + " ...");
        JMenuItem jMenuItem3 = new JMenuItem(this.language.getString("Remove board"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KnownBoardsFrame.this.addBoards_actionPerformed(actionEvent);
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KnownBoardsFrame.this.addBoardsToFolder_actionPerformed(actionEvent);
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KnownBoardsFrame.this.deleteBoards_actionPerformed(actionEvent);
            }
        });
        this.tablePopupMenu.add(jMenuItem);
        this.tablePopupMenu.add(jMenuItem2);
        this.tablePopupMenu.add(jMenuItem3);
        this.boardsTable.addMouseListener(new TablePopupMenuMouseListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDialog() {
        Vector vector = MainFrame.getInstance().getTofTreeModel().getAllBoards();
        this.allKnownBoardsList = new Vector();
        List list = Core.getKnownBoards();
        synchronized (list) {
            for (BoardAttachment boardAttachment : Core.getKnownBoards()) {
                Object object2;
                String string = boardAttachment.getBoardObj().getName();
                String string2 = boardAttachment.getBoardObj().getPrivateKey();
                String string3 = boardAttachment.getBoardObj().getPublicKey();
                boolean bl = true;
                for (Object object2 : vector) {
                    if (!((Board)object2).getName().equalsIgnoreCase(string) || (((Board)object2).getPrivateKey() != null || string2 != null) && (((Board)object2).getPrivateKey() == null || !((Board)object2).getPrivateKey().equals(string2)) || (((Board)object2).getPublicKey() != null || string3 != null) && (((Board)object2).getPublicKey() == null || !((Board)object2).getPublicKey().equals(string3))) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                object2 = new KnownBoardsTableMember(boardAttachment);
                this.tableModel.addRow((TableMember)object2);
                this.allKnownBoardsList.add(object2);
            }
        }
        this.setVisible(true);
        if (this.savingNeeded) {
            Core.getInstance().saveKnownBoards();
        }
    }

    private void addBoards_actionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.boardsTable.getSelectedRows();
        if (nArray.length > 0) {
            for (int i = nArray.length - 1; i > -1; --i) {
                int n = nArray[i];
                if (n >= this.tableModel.getRowCount()) continue;
                KnownBoardsTableMember knownBoardsTableMember = (KnownBoardsTableMember)this.tableModel.getRow(n);
                this.tofTree.addNewBoard(knownBoardsTableMember.getBoardObject());
                this.tableModel.deleteRow(knownBoardsTableMember);
                this.allKnownBoardsList.remove(knownBoardsTableMember.getBoardAttachment());
            }
            this.boardsTable.clearSelection();
        }
    }

    private void addBoardsToFolder_actionPerformed(ActionEvent actionEvent) {
        TargetFolderChooser targetFolderChooser = new TargetFolderChooser(MainFrame.getInstance().getTofTreeModel());
        Board board = targetFolderChooser.startDialog();
        if (board == null) {
            return;
        }
        int[] nArray = this.boardsTable.getSelectedRows();
        if (nArray.length > 0) {
            for (int i = nArray.length - 1; i > -1; --i) {
                int n = nArray[i];
                if (n >= this.tableModel.getRowCount()) continue;
                KnownBoardsTableMember knownBoardsTableMember = (KnownBoardsTableMember)this.tableModel.getRow(n);
                MainFrame.getInstance().getTofTreeModel().addNodeToTree(knownBoardsTableMember.getBoardObject(), board);
                this.tableModel.deleteRow(knownBoardsTableMember);
                this.allKnownBoardsList.remove(knownBoardsTableMember.getBoardAttachment());
            }
            this.boardsTable.clearSelection();
        }
    }

    private void deleteBoards_actionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.boardsTable.getSelectedRows();
        if (nArray.length > 0) {
            for (int i = nArray.length - 1; i > -1; --i) {
                int n = nArray[i];
                if (n >= this.tableModel.getRowCount()) continue;
                KnownBoardsTableMember knownBoardsTableMember = (KnownBoardsTableMember)this.tableModel.getRow(n);
                this.tableModel.deleteRow(knownBoardsTableMember);
                this.allKnownBoardsList.remove(knownBoardsTableMember.getBoardAttachment());
                Core.getKnownBoards().remove(knownBoardsTableMember.getBoardAttachment());
                this.savingNeeded = true;
            }
            this.boardsTable.clearSelection();
        }
    }

    private void boardsTableListModel_valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.boardsTable.getSelectedRowCount() > 0) {
            this.BaddBoard.setEnabled(true);
            this.BaddBoardToFolder.setEnabled(true);
        } else {
            this.BaddBoard.setEnabled(false);
            this.BaddBoardToFolder.setEnabled(false);
        }
    }

    private void lookupContentChanged() {
        try {
            String string = this.TFlookupBoard.getDocument().getText(0, this.TFlookupBoard.getDocument().getLength());
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                KnownBoardsTableMember knownBoardsTableMember = (KnownBoardsTableMember)this.tableModel.getRow(i);
                if (!knownBoardsTableMember.getBoardObject().getName().toLowerCase().startsWith(string.toLowerCase())) continue;
                this.boardsTable.getSelectionModel().setSelectionInterval(i, i);
                int n = (int)(this.boardsTable.getVisibleRect().getHeight() / this.boardsTable.getCellRect(i, 0, true).getHeight());
                int n2 = i + n > this.tableModel.getRowCount() ? this.tableModel.getRowCount() - 1 : i + n - 1;
                if (n2 > i) {
                    --n2;
                }
                this.boardsTable.scrollRectToVisible(this.boardsTable.getCellRect(i, 0, true));
                this.boardsTable.scrollRectToVisible(this.boardsTable.getCellRect(n2, 0, true));
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void filterContentChanged() {
        try {
            this.TFlookupBoard.setText("");
            String string = this.TFfilterBoard.getDocument().getText(0, this.TFfilterBoard.getDocument().getLength()).trim();
            string = string.toLowerCase();
            this.tableModel.clearDataModel();
            for (KnownBoardsTableMember knownBoardsTableMember : this.allKnownBoardsList) {
                String string2;
                if (string.length() > 0 && (string2 = knownBoardsTableMember.getBoardObject().getName().toLowerCase()).indexOf(string) < 0) continue;
                this.tableModel.addRow(knownBoardsTableMember);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class TablePopupMenuMouseListener
    implements MouseListener {
        TablePopupMenuMouseListener() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        protected void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && KnownBoardsFrame.this.boardsTable.getSelectedRowCount() > 0) {
                KnownBoardsFrame.this.tablePopupMenu.show(KnownBoardsFrame.this.boardsTable, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class DescColumnRenderer
    extends DefaultTableCellRenderer {
        DescColumnRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            KnownBoardsTableMember knownBoardsTableMember = (KnownBoardsTableMember)KnownBoardsFrame.this.tableModel.getRow(n);
            if (knownBoardsTableMember.getBoardObject().getDescription() != null && knownBoardsTableMember.getBoardObject().getDescription().length() > 0) {
                this.setToolTipText(knownBoardsTableMember.getBoardObject().getDescription());
            } else {
                this.setToolTipText(null);
            }
            return this;
        }
    }

    class NameColumnRenderer
    extends DefaultTableCellRenderer {
        NameColumnRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            KnownBoardsTableMember knownBoardsTableMember = (KnownBoardsTableMember)KnownBoardsFrame.this.tableModel.getRow(n);
            if (knownBoardsTableMember.getBoardObject().getPublicKey() == null && knownBoardsTableMember.getBoardObject().getPrivateKey() == null) {
                this.setIcon(boardIcon);
            } else if (knownBoardsTableMember.getBoardObject().getPublicKey() != null && knownBoardsTableMember.getBoardObject().getPrivateKey() == null) {
                this.setIcon(readAccessIcon);
            } else if (knownBoardsTableMember.getBoardObject().getPrivateKey() != null) {
                this.setIcon(writeAccessIcon);
            }
            return this;
        }
    }

    class KnownBoardsTableMember
    implements TableMember {
        BoardAttachment boardatt;
        Board frostboard;

        public KnownBoardsTableMember(BoardAttachment boardAttachment) {
            this.boardatt = boardAttachment;
            this.frostboard = boardAttachment.getBoardObj();
        }

        public Object getValueAt(int n) {
            switch (n) {
                case 0: {
                    return this.frostboard.getName();
                }
                case 1: {
                    return this.frostboard.getPublicKey() == null ? "" : this.frostboard.getPublicKey();
                }
                case 2: {
                    return this.frostboard.getPrivateKey() == null ? "" : this.frostboard.getPrivateKey();
                }
                case 3: {
                    return this.frostboard.getDescription() == null ? "" : this.frostboard.getDescription();
                }
            }
            return "*ERR*";
        }

        public int compareTo(TableMember tableMember, int n) {
            String string = (String)this.getValueAt(n);
            String string2 = (String)tableMember.getValueAt(n);
            return string.compareToIgnoreCase(string2);
        }

        public Board getBoardObject() {
            return this.frostboard;
        }

        public BoardAttachment getBoardAttachment() {
            return this.boardatt;
        }
    }
}

