/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.util.gui.JDialogWithDetails;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class AboutBox
extends JDialogWithDetails {
    private static final String product = "Frost";
    private String version = null;
    private static final String copyright = "Copyright (c) 2003 Jan-Thomas Czornack";
    private static final String comments2 = "http://jtcfrost.sourceforge.net/";
    private JPanel imagePanel = new JPanel();
    private JPanel messagesPanel = new JPanel();
    private JLabel imageLabel = new JLabel();
    private JLabel productLabel = new JLabel();
    private JLabel versionLabel = new JLabel();
    private JLabel copyrightLabel = new JLabel();
    private JLabel licenseLabel = new JLabel();
    private JLabel websiteLabel = new JLabel();
    private static final ImageIcon frostImage = new ImageIcon(AboutBox.class.getResource("/data/jtc.jpg"));

    public AboutBox(Frame frame) {
        super(frame);
        this.initialize();
    }

    private void initialize() {
        this.imageLabel.setIcon(frostImage);
        this.setTitle(this.language.getString("About"));
        this.setResizable(false);
        this.imagePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.imagePanel.add(this.imageLabel);
        GridLayout gridLayout = new GridLayout(5, 1);
        this.messagesPanel.setLayout(gridLayout);
        this.messagesPanel.setBorder(new EmptyBorder(10, 50, 10, 10));
        this.productLabel.setText(product);
        this.versionLabel.setText(this.getVersion());
        this.copyrightLabel.setText(copyright);
        this.licenseLabel.setText(this.language.getString("Open Source Project (GPL license)"));
        this.websiteLabel.setText(comments2);
        this.messagesPanel.add(this.productLabel);
        this.messagesPanel.add(this.versionLabel);
        this.messagesPanel.add(this.copyrightLabel);
        this.messagesPanel.add(this.licenseLabel);
        this.messagesPanel.add(this.websiteLabel);
        this.getUserPanel().setLayout(new BorderLayout());
        this.getUserPanel().add((Component)this.imagePanel, "West");
        this.getUserPanel().add((Component)this.messagesPanel, "Center");
        this.fillDetailsArea();
    }

    private void fillDetailsArea() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.language.getString("Development:") + "\n");
        stringBuffer.append("   Jan-Thomas Czornack\n");
        stringBuffer.append("   Thomas Mueller\n");
        stringBuffer.append("   Jim Hunziker\n");
        stringBuffer.append("   Stefan Majewski\n");
        stringBuffer.append("   Karsten Graul\n");
        stringBuffer.append("   Jos\u00e9 Manuel Arnesto\n");
        stringBuffer.append("   Roman Glebov\n\n");
        stringBuffer.append(this.language.getString("Windows Installer:") + "\n");
        stringBuffer.append("   Benoit Laniel\n\n");
        stringBuffer.append(this.language.getString("System Tray Executables:") + "\n");
        stringBuffer.append("   Ingo Franzki\n\n");
        stringBuffer.append(this.language.getString("Translation Support:") + "\n");
        stringBuffer.append("   Rudolf Krist\n");
        stringBuffer.append("   RapHHfr\n\n");
        stringBuffer.append(this.language.getString("Splash Screen Logo:") + "\n");
        stringBuffer.append("   Fr\u00e9d\u00e9ric Scheer\n\n");
        stringBuffer.append(this.language.getString("Misc code contributions:") + "\n");
        stringBuffer.append("   SuperSlut Yoda");
        this.setDetailsText(stringBuffer.toString());
    }

    private String getVersion() {
        if (this.version == null) {
            this.version = this.language.getString("Version") + ": " + this.getClass().getPackage().getSpecificationVersion();
        }
        return this.version;
    }
}

