/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.upload;

import frost.Mixed;
import frost.SettingsClass;
import frost.fileTransfer.upload.FrostUploadItem;
import frost.fileTransfer.upload.UploadModel;
import frost.fileTransfer.upload.UploadPanel;
import frost.fileTransfer.upload.UploadThread;
import frost.fileTransfer.upload.UploadTickerListener;
import frost.identities.LocalIdentity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.event.EventListenerList;

public class UploadTicker
extends Thread {
    private final int MAX_GENERATING_THREADS = 1;
    private LocalIdentity myID;
    private SettingsClass settings;
    private UploadPanel panel;
    private UploadModel model;
    private int counter;
    static final Comparator uploadDlStopMillisCmp = new Comparator(){

        public int compare(Object object, Object object2) {
            FrostUploadItem frostUploadItem = (FrostUploadItem)object;
            FrostUploadItem frostUploadItem2 = (FrostUploadItem)object2;
            if (frostUploadItem.getLastUploadStopTimeMillis() > frostUploadItem2.getLastUploadStopTimeMillis()) {
                return 1;
            }
            if (frostUploadItem.getLastUploadStopTimeMillis() < frostUploadItem2.getLastUploadStopTimeMillis()) {
                return -1;
            }
            return 0;
        }
    };
    private int allocatedUploadingThreads = 0;
    private int allocatedGeneratingThreads = 0;
    private int runningUploadingThreads = 0;
    private int runningGeneratingThreads = 0;
    private Object uploadingCountLock = new Object();
    private Object generatingCountLock = new Object();
    protected EventListenerList listenerList = new EventListenerList();

    public UploadTicker(SettingsClass settingsClass, UploadModel uploadModel, UploadPanel uploadPanel, LocalIdentity localIdentity) {
        super("Upload");
        this.settings = settingsClass;
        this.model = uploadModel;
        this.panel = uploadPanel;
        this.myID = localIdentity;
    }

    public void addUploadTickerListener(UploadTickerListener uploadTickerListener) {
        this.listenerList.add(UploadTickerListener.class, uploadTickerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean allocateUploadingThread() {
        Object object = this.uploadingCountLock;
        synchronized (object) {
            if (this.allocatedUploadingThreads < this.settings.getIntValue("uploadThreads")) {
                ++this.allocatedUploadingThreads;
                return true;
            }
        }
        return false;
    }

    protected void fireUploadingCountChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != UploadTickerListener.class) continue;
            ((UploadTickerListener)objectArray[i + 1]).uploadingCountChanged();
        }
    }

    protected void fireGeneratingCountChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != UploadTickerListener.class) continue;
            ((UploadTickerListener)objectArray[i + 1]).generatingCountChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean allocateGeneratingThread() {
        Object object = this.generatingCountLock;
        synchronized (object) {
            if (this.allocatedGeneratingThreads < 1) {
                ++this.allocatedGeneratingThreads;
                return true;
            }
        }
        return false;
    }

    void generatingThreadStarted() {
        ++this.runningGeneratingThreads;
        this.fireGeneratingCountChanged();
    }

    void generatingThreadFinished() {
        --this.runningGeneratingThreads;
        this.fireGeneratingCountChanged();
        this.releaseGeneratingThread();
    }

    void uploadingThreadStarted() {
        ++this.runningUploadingThreads;
        this.fireUploadingCountChanged();
    }

    void uploadingThreadFinished() {
        --this.runningUploadingThreads;
        this.fireUploadingCountChanged();
        this.releaseUploadingThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseUploadingThread() {
        Object object = this.uploadingCountLock;
        synchronized (object) {
            if (this.allocatedUploadingThreads > 0) {
                --this.allocatedUploadingThreads;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseGeneratingThread() {
        Object object = this.generatingCountLock;
        synchronized (object) {
            if (this.allocatedGeneratingThreads > 0) {
                --this.allocatedGeneratingThreads;
            }
        }
    }

    public void run() {
        super.run();
        while (true) {
            Mixed.wait(1000);
            ++this.counter;
            this.removeNotExistingFiles();
            this.prepareUploadHashes();
            this.generateCHKs();
            this.startUploadThread();
        }
    }

    private void generateCHKs() {
        if (this.allocateGeneratingThread()) {
            boolean bl = false;
            for (int i = 0; i < this.model.getItemCount() && !bl; ++i) {
                FrostUploadItem frostUploadItem = (FrostUploadItem)this.model.getItemAt(i);
                if (frostUploadItem.getState() != 5 && (frostUploadItem.getKey() != null || frostUploadItem.getState() != 2)) continue;
                UploadThread uploadThread = null;
                uploadThread = frostUploadItem.getState() == 2 ? new UploadThread(this, frostUploadItem, this.settings, 2, 2, this.myID) : new UploadThread(this, frostUploadItem, this.settings, 2, this.myID);
                frostUploadItem.setState(6);
                uploadThread.start();
                bl = true;
            }
            if (!bl) {
                this.releaseGeneratingThread();
            }
        }
    }

    private void startUploadThread() {
        if (this.allocateUploadingThread()) {
            FrostUploadItem frostUploadItem = this.selectNextUploadItem();
            if (frostUploadItem != null) {
                frostUploadItem.setState(3);
                UploadThread uploadThread = new UploadThread(this, frostUploadItem, this.settings, 3, this.myID);
                uploadThread.start();
            } else {
                this.releaseUploadingThread();
            }
        }
    }

    private FrostUploadItem selectNextUploadItem() {
        FrostUploadItem frostUploadItem = null;
        for (int i = 0; i < this.model.getItemCount() && frostUploadItem == null; ++i) {
            FrostUploadItem frostUploadItem2 = (FrostUploadItem)this.model.getItemAt(i);
            if (frostUploadItem2.getState() != 2 || frostUploadItem2.getSHA1() == null || frostUploadItem2.getKey() == null || frostUploadItem2.isEnabled() != null && !frostUploadItem2.isEnabled().booleanValue()) continue;
            frostUploadItem = frostUploadItem2;
        }
        if (frostUploadItem != null || !this.settings.getBoolValue("restartFailedUploads")) {
            return frostUploadItem;
        }
        ArrayList<FrostUploadItem> arrayList = new ArrayList<FrostUploadItem>();
        for (int i = 0; i < this.model.getItemCount(); ++i) {
            FrostUploadItem frostUploadItem3 = (FrostUploadItem)this.model.getItemAt(i);
            if (frostUploadItem3.getState() != 7 || frostUploadItem3.isEnabled() != null && !frostUploadItem3.isEnabled().booleanValue()) continue;
            long l = this.settings.getIntValue("uploadRetriesWaitTime") * 60 * 1000;
            if (System.currentTimeMillis() - frostUploadItem3.getLastUploadStopTimeMillis() <= l) continue;
            arrayList.add(frostUploadItem3);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() > 1) {
            Collections.sort(arrayList, uploadDlStopMillisCmp);
        }
        return (FrostUploadItem)arrayList.get(0);
    }

    private void prepareUploadHashes() {
        if (this.settings.getBoolValue("automaticIndexing") && this.allocateGeneratingThread()) {
            boolean bl = false;
            for (int i = 0; i < this.model.getItemCount() && !bl; ++i) {
                FrostUploadItem frostUploadItem = (FrostUploadItem)this.model.getItemAt(i);
                if (frostUploadItem.getSHA1() != null) continue;
                frostUploadItem.setKey("Working...");
                UploadThread uploadThread = new UploadThread(this, frostUploadItem, this.settings, 1, this.myID);
                uploadThread.start();
                bl = true;
            }
            if (!bl) {
                this.releaseGeneratingThread();
            }
        }
    }

    private void removeNotExistingFiles() {
        if (this.counter % 180 == 0) {
            this.model.removeNotExistingFiles();
        }
    }

    public void removeUploadTickerListener(UploadTickerListener uploadTickerListener) {
        this.listenerList.remove(UploadTickerListener.class, uploadTickerListener);
    }

    public int getRunningGeneratingThreads() {
        return this.runningGeneratingThreads;
    }

    public int getRunningUploadingThreads() {
        return this.runningUploadingThreads;
    }
}

