/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.upload;

import frost.Core;
import frost.DateFun;
import frost.FileAccess;
import frost.MainFrame;
import frost.SettingsClass;
import frost.fcp.FcpInsert;
import frost.fcp.FecSplitfile;
import frost.fcp.FecTools;
import frost.fileTransfer.Index;
import frost.fileTransfer.upload.FrostUploadItem;
import frost.fileTransfer.upload.UploadTicker;
import frost.gui.objects.Board;
import frost.identities.LocalIdentity;
import frost.messages.FECRedirectFileObject;
import frost.messages.SharedFileObject;
import java.io.File;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

class UploadThread
extends Thread {
    private SettingsClass settings;
    private UploadTicker ticker;
    private LocalIdentity myId;
    static ResourceBundle LangRes = ResourceBundle.getBundle("res.LangRes");
    private static Logger logger = Logger.getLogger(UploadThread.class.getName());
    public static final int MODE_GENERATE_SHA1 = 1;
    public static final int MODE_GENERATE_CHK = 2;
    public static final int MODE_UPLOAD = 3;
    private int nextState;
    private String destination;
    private File file;
    private int htl;
    private Board board;
    private int mode;
    private static int fileIndex = 1;
    private static Random r = new Random();
    private static String batchId = Core.getMyBatches().values().size() == 0 ? new Long(r.nextLong()).toString() : (String)Core.getMyBatches().values().iterator().next();
    private static final int batchSize = 100;
    FrostUploadItem uploadItem;

    public void run() {
        switch (this.mode) {
            case 3: {
                this.ticker.uploadingThreadStarted();
                break;
            }
            case 1: {
                this.ticker.generatingThreadStarted();
                break;
            }
            case 2: {
                this.ticker.generatingThreadStarted();
            }
        }
        if (batchId == null) {
            Exception exception = new Exception();
            exception.fillInStackTrace();
            logger.log(Level.SEVERE, "Exception thrown in run()", exception);
        }
        if (Core.getMyBatches().values().size() == 0) {
            Core.getMyBatches().put(batchId, batchId);
        }
        boolean bl = MainFrame.frostSettings.getBoolValue("signUploads");
        try {
            switch (this.mode) {
                case 3: {
                    this.upload(bl);
                    this.ticker.uploadingThreadFinished();
                    break;
                }
                case 1: {
                    this.generateSHA1(bl);
                    this.ticker.generatingThreadFinished();
                    break;
                }
                case 2: {
                    this.generateCHK();
                    this.ticker.generatingThreadFinished();
                }
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Exception thrown in run()", exception);
            switch (this.mode) {
                case 3: {
                    this.ticker.uploadingThreadFinished();
                    break;
                }
                case 1: {
                    this.ticker.generatingThreadFinished();
                    break;
                }
                case 2: {
                    this.ticker.generatingThreadFinished();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upload(boolean bl) {
        String string = null;
        boolean bl2 = false;
        String[] stringArray = new String[]{"Error", "Error"};
        String string2 = DateFun.getExtendedDate();
        logger.info("Upload of " + this.file + " with HTL " + this.htl + " started.");
        stringArray = FcpInsert.putFile("CHK@", this.file, null, this.htl, true, this.uploadItem);
        if (stringArray[0].equals("Success") || stringArray[0].equals("KeyCollision")) {
            bl2 = true;
            this.uploadItem.setKey(stringArray[1]);
            string = string2;
        }
        if (!bl2) {
            logger.warning("Upload of " + this.file + " was NOT successful.");
            this.uploadItem.setRetries(this.uploadItem.getRetries() + 1);
            if (this.uploadItem.getRetries() > this.settings.getIntValue("uploadMaxRetries")) {
                if (this.settings.getBoolValue("restartFailedUploads")) {
                    this.uploadItem.setState(7);
                    this.uploadItem.setRetries(0);
                } else {
                    this.uploadItem.setState(this.nextState);
                }
            } else {
                this.uploadItem.setState(7);
            }
        } else {
            Object object;
            SharedFileObject sharedFileObject;
            logger.info("Upload of " + this.file + " was successful.");
            this.uploadItem.setState(this.nextState);
            this.uploadItem.setLastUploadDate(string);
            if (this.uploadItem.getFileSize() > 786432L) {
                logger.fine("attaching redirect to file " + this.file.getName());
                sharedFileObject = new FECRedirectFileObject();
                object = new FecSplitfile(this.file);
                if (!((FecSplitfile)object).uploadInit()) {
                    throw new Error("file was just uploaded, but .redirect missing!");
                }
                ((FecSplitfile)object).createRedirectFile(false);
                ((FECRedirectFileObject)sharedFileObject).setRedirect(new String(FileAccess.readByteArray(((FecSplitfile)object).getRedirectFile())));
            } else {
                sharedFileObject = new SharedFileObject();
                logger.fine("not attaching redirect");
            }
            sharedFileObject.setKey(this.uploadItem.getKey());
            if (bl) {
                sharedFileObject.setOwner(this.myId.getUniqueName());
            }
            sharedFileObject.setFilename(this.uploadItem.getFileName());
            sharedFileObject.setSHA1(this.uploadItem.getSHA1());
            sharedFileObject.setBatch(this.uploadItem.getBatch());
            sharedFileObject.setSize(this.uploadItem.getFileSize());
            sharedFileObject.setDate(string);
            sharedFileObject.setLastSharedDate(string);
            Object object2 = object = Index.getInstance();
            synchronized (object2) {
                ((Index)object).addMine(sharedFileObject, this.board);
                ((Index)object).add(sharedFileObject, this.board);
            }
        }
        this.uploadItem.setLastUploadStopTimeMillis(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateSHA1(boolean bl) {
        Index index;
        if (fileIndex % 100 == 0) {
            Core.getMyBatches().put(batchId, batchId);
            while (Core.getMyBatches().contains(batchId)) {
                batchId = new Long(r.nextLong()).toString();
            }
            Core.getMyBatches().put(batchId, batchId);
        }
        long l = System.currentTimeMillis();
        String string = Core.getCrypto().digest(this.file);
        logger.fine("digest generated in " + (System.currentTimeMillis() - l) + "  " + string);
        SharedFileObject sharedFileObject = new SharedFileObject();
        sharedFileObject.setKey(null);
        sharedFileObject.setDate(null);
        sharedFileObject.setLastSharedDate(DateFun.getExtendedDate());
        sharedFileObject.setSHA1(string);
        sharedFileObject.setFilename(this.destination);
        sharedFileObject.setSize(this.file.length());
        sharedFileObject.setBatch(batchId);
        if (bl) {
            sharedFileObject.setOwner(this.myId.getUniqueName());
        }
        this.uploadItem.setSHA1(string);
        this.uploadItem.setKey(null);
        this.uploadItem.setLastUploadDate(null);
        this.uploadItem.setBatch(batchId);
        ++fileIndex;
        Index index2 = index = Index.getInstance();
        synchronized (index2) {
            index.addMine(sharedFileObject, this.board);
            index.add(sharedFileObject, this.board);
        }
        this.uploadItem.setState(this.nextState);
    }

    private void generateCHK() {
        Object object;
        logger.info("CHK generation started for file: " + this.file);
        String string = null;
        if (this.file.length() <= 786432L) {
            logger.info("File too short, doesn't need encoding.");
            string = FecTools.generateCHK(this.file);
        } else {
            object = new FecSplitfile(this.file);
            boolean bl = ((FecSplitfile)object).uploadInit();
            if (!bl) {
                try {
                    ((FecSplitfile)object).encode();
                }
                catch (Throwable throwable) {
                    logger.log(Level.SEVERE, "Encoding failed", throwable);
                    this.uploadItem.setState(1);
                    return;
                }
            }
            ((FecSplitfile)object).createRedirectFile(false);
            string = FecTools.generateCHK(((FecSplitfile)object).getRedirectFile(), ((FecSplitfile)object).getRedirectFile().length());
        }
        if (string != null) {
            object = new String("freenet:");
            if (string.startsWith((String)object)) {
                string = string.substring(((String)object).length());
            }
        } else {
            logger.warning("Could not generate CHK key for redirect file.");
        }
        this.uploadItem.setKey(string);
        if (this.uploadItem.getNextState() > 0) {
            this.uploadItem.setState(this.uploadItem.getNextState());
            this.uploadItem.setNextState(0);
        } else {
            this.uploadItem.setState(this.nextState);
        }
    }

    public UploadThread(UploadTicker uploadTicker, FrostUploadItem frostUploadItem, SettingsClass settingsClass, int n, LocalIdentity localIdentity) {
        this(uploadTicker, frostUploadItem, settingsClass, n, -1, localIdentity);
    }

    public UploadThread(UploadTicker uploadTicker, FrostUploadItem frostUploadItem, SettingsClass settingsClass, int n, int n2, LocalIdentity localIdentity) {
        this.destination = frostUploadItem.getFileName();
        this.file = new File(frostUploadItem.getFilePath());
        this.myId = localIdentity;
        this.ticker = uploadTicker;
        this.uploadItem = frostUploadItem;
        this.settings = settingsClass;
        this.htl = settingsClass.getIntValue("htlUpload");
        this.board = frostUploadItem.getTargetBoard();
        this.mode = n;
        this.nextState = n2;
        if (this.nextState < 0) {
            this.nextState = 1;
        }
    }
}

