/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.upload;

import frost.fileTransfer.upload.FrostUploadItem;
import frost.util.gui.BooleanCell;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import frost.util.model.ModelItem;
import frost.util.model.gui.ModelTable;
import frost.util.model.gui.SortedModelTable;
import frost.util.model.gui.SortedTableFormat;
import java.awt.Component;
import java.awt.Font;
import java.util.Comparator;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;

class UploadTableFormat
extends SortedTableFormat
implements LanguageListener {
    private Language language = Language.getInstance();
    private static final int COLUMN_COUNT = 8;
    private String stateUploadedNever;
    private String stateRequested;
    private String stateUploading;
    private String stateEncodingRequested;
    private String stateEncoding;
    private String stateWaiting;
    private String unknown;

    public UploadTableFormat() {
        super(8);
        this.language.addLanguageListener(this);
        this.refreshLanguage();
        this.setComparator(new EnabledComparator(), 0);
        this.setComparator(new NameComparator(), 1);
        this.setComparator(new FileSizeComparator(), 2);
        this.setComparator(new StateComparator(), 3);
        this.setComparator(new PathComparator(), 4);
        this.setComparator(new TriesComparator(), 5);
        this.setComparator(new DestinationComparator(), 6);
        this.setComparator(new KeyComparator(), 7);
    }

    private void refreshLanguage() {
        this.setColumnName(0, this.language.getString("DownloadTableFormat.Enabled"));
        this.setColumnName(1, this.language.getString("Filename"));
        this.setColumnName(2, this.language.getString("Size"));
        this.setColumnName(3, this.language.getString("Last upload"));
        this.setColumnName(4, this.language.getString("Path"));
        this.setColumnName(5, this.language.getString("Tries"));
        this.setColumnName(6, this.language.getString("Destination"));
        this.setColumnName(7, this.language.getString("Key"));
        this.stateUploadedNever = this.language.getString("Never");
        this.stateRequested = this.language.getString("Requested");
        this.stateUploading = this.language.getString("Uploading");
        this.stateEncodingRequested = this.language.getString("Encode requested");
        this.stateEncoding = this.language.getString("Encoding file") + "...";
        this.stateWaiting = this.language.getString("Waiting");
        this.unknown = this.language.getString("Unknown");
        this.refreshColumnNames();
    }

    public void setCellValue(Object object, ModelItem modelItem, int n) {
        FrostUploadItem frostUploadItem = (FrostUploadItem)modelItem;
        switch (n) {
            case 0: {
                Boolean bl = (Boolean)object;
                frostUploadItem.setEnabled(bl);
                break;
            }
            default: {
                super.setCellValue(object, modelItem, n);
            }
        }
    }

    public Object getCellValue(ModelItem modelItem, int n) {
        FrostUploadItem frostUploadItem = (FrostUploadItem)modelItem;
        switch (n) {
            case 0: {
                return frostUploadItem.isEnabled();
            }
            case 1: {
                return frostUploadItem.getFileName();
            }
            case 2: {
                return frostUploadItem.getFileSize();
            }
            case 3: {
                return this.getStateAsString(frostUploadItem, frostUploadItem.getState());
            }
            case 4: {
                return frostUploadItem.getFilePath();
            }
            case 5: {
                return new Integer(frostUploadItem.getRetries());
            }
            case 6: {
                return frostUploadItem.getTargetBoard().getName();
            }
            case 7: {
                if (frostUploadItem.getKey() == null) {
                    return this.unknown;
                }
                return frostUploadItem.getKey();
            }
        }
        return "**ERROR**";
    }

    private String getStateAsString(FrostUploadItem frostUploadItem, int n) {
        switch (n) {
            case 2: {
                return this.stateRequested;
            }
            case 3: {
                return this.stateUploading;
            }
            case 4: {
                return this.getUploadProgress(frostUploadItem.getTotalBlocks(), frostUploadItem.getDoneBlocks());
            }
            case 5: {
                return this.stateEncodingRequested;
            }
            case 6: {
                return this.stateEncoding;
            }
            case 1: {
                if (frostUploadItem.getLastUploadDate() == null) {
                    return this.stateUploadedNever;
                }
                return frostUploadItem.getLastUploadDate();
            }
            case 7: {
                return this.stateWaiting;
            }
        }
        return "**ERROR**";
    }

    private String getUploadProgress(int n, int n2) {
        int n3 = 0;
        if (n > 0) {
            n3 = n2 * 100 / n;
        }
        return n2 + " / " + n + " (" + n3 + "%)";
    }

    public void customizeTable(ModelTable modelTable) {
        super.customizeTable(modelTable);
        TableColumnModel tableColumnModel = modelTable.getTable().getColumnModel();
        int[] nArray = new int[]{25, 250, 80, 80, 60, 25, 70, 40};
        for (int i = 0; i < nArray.length; ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth(nArray[i]);
        }
        tableColumnModel.getColumn(0).setCellRenderer(BooleanCell.RENDERER);
        tableColumnModel.getColumn(0).setCellEditor(BooleanCell.EDITOR);
        this.setColumnEditable(0, true);
        tableColumnModel.getColumn(1).setCellRenderer(new NameRenderer((SortedModelTable)modelTable));
        tableColumnModel.getColumn(2).setCellRenderer(new FileSizeRenderer());
    }

    public int[] getColumnNumbers(int n) {
        switch (n) {
            case 100: {
                return new int[]{3};
            }
            case 101: {
                return new int[]{1};
            }
            case 102: {
                return new int[]{4};
            }
            case 103: {
                return new int[]{2};
            }
            case 104: {
                return new int[]{7};
            }
            case 105: {
                return new int[]{3};
            }
            case 107: {
                return new int[]{1};
            }
            case 108: {
                return new int[]{3};
            }
            case 109: {
                return new int[]{6};
            }
            case 106: {
                return new int[]{3};
            }
            case 110: {
                return new int[]{0};
            }
            case 111: {
                return new int[]{5};
            }
        }
        return new int[0];
    }

    public void languageChanged(LanguageEvent languageEvent) {
        this.refreshLanguage();
    }

    private class FileSizeComparator
    implements Comparator {
        private FileSizeComparator() {
        }

        public int compare(Object object, Object object2) {
            FrostUploadItem frostUploadItem = (FrostUploadItem)object;
            FrostUploadItem frostUploadItem2 = (FrostUploadItem)object2;
            return frostUploadItem.getFileSize().compareTo(frostUploadItem2.getFileSize());
        }
    }

    private class KeyComparator
    implements Comparator {
        private KeyComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = ((FrostUploadItem)object).getKey();
            String string2 = ((FrostUploadItem)object2).getKey();
            if (string == null) {
                string = UploadTableFormat.this.unknown;
            }
            if (string2 == null) {
                string2 = UploadTableFormat.this.unknown;
            }
            return string.compareToIgnoreCase(string2);
        }
    }

    private class EnabledComparator
    implements Comparator {
        private EnabledComparator() {
        }

        public int compare(Object object, Object object2) {
            FrostUploadItem frostUploadItem = (FrostUploadItem)object;
            FrostUploadItem frostUploadItem2 = (FrostUploadItem)object2;
            return frostUploadItem.isEnabled().equals(frostUploadItem2.isEnabled()) ? 0 : 1;
        }
    }

    private class DestinationComparator
    implements Comparator {
        private DestinationComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = ((FrostUploadItem)object).getTargetBoard().getName();
            String string2 = ((FrostUploadItem)object2).getTargetBoard().getName();
            return string.compareToIgnoreCase(string2);
        }
    }

    private class PathComparator
    implements Comparator {
        private PathComparator() {
        }

        public int compare(Object object, Object object2) {
            FrostUploadItem frostUploadItem = (FrostUploadItem)object;
            FrostUploadItem frostUploadItem2 = (FrostUploadItem)object2;
            return frostUploadItem.getFilePath().compareToIgnoreCase(frostUploadItem2.getFilePath());
        }
    }

    private class TriesComparator
    implements Comparator {
        private TriesComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = ((FrostUploadItem)object).getRetries();
            int n2 = ((FrostUploadItem)object2).getRetries();
            return new Integer(n).compareTo(new Integer(n2));
        }
    }

    private class StateComparator
    implements Comparator {
        private StateComparator() {
        }

        public int compare(Object object, Object object2) {
            FrostUploadItem frostUploadItem = (FrostUploadItem)object;
            FrostUploadItem frostUploadItem2 = (FrostUploadItem)object2;
            return UploadTableFormat.this.getStateAsString(frostUploadItem, frostUploadItem.getState()).compareToIgnoreCase(UploadTableFormat.this.getStateAsString(frostUploadItem2, frostUploadItem2.getState()));
        }
    }

    private class NameComparator
    implements Comparator {
        private NameComparator() {
        }

        public int compare(Object object, Object object2) {
            FrostUploadItem frostUploadItem = (FrostUploadItem)object;
            FrostUploadItem frostUploadItem2 = (FrostUploadItem)object2;
            return frostUploadItem.getFileName().compareToIgnoreCase(frostUploadItem2.getFileName());
        }
    }

    private class FileSizeRenderer
    extends DefaultTableCellRenderer {
        private FileSizeRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setHorizontalAlignment(4);
            this.setBorder(new EmptyBorder(0, 0, 0, 3));
            return this;
        }
    }

    private class NameRenderer
    extends DefaultTableCellRenderer {
        private SortedModelTable modelTable;

        public NameRenderer(SortedModelTable sortedModelTable) {
            this.modelTable = sortedModelTable;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            FrostUploadItem frostUploadItem;
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            ModelItem modelItem = this.modelTable.getItemAt(n);
            if (modelItem != null && (frostUploadItem = (FrostUploadItem)modelItem).getSHA1() != null) {
                Font font = this.getFont();
                this.setFont(font.deriveFont(1));
            }
            return this;
        }
    }
}

