/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.upload;

import frost.fileTransfer.upload.UploadTicker;
import frost.fileTransfer.upload.UploadTickerListener;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UploadStatusPanel
extends JPanel {
    private UploadTicker ticker;
    private Language language;
    private JLabel uploadingLabel = new JLabel();
    private JLabel countLabel = new JLabel();
    private JLabel filesLabel = new JLabel();
    int count = 0;
    private Listener listener = new Listener();

    public UploadStatusPanel(UploadTicker uploadTicker) {
        this.ticker = uploadTicker;
        this.language = Language.getInstance();
        this.initialize();
    }

    private void initialize() {
        this.refreshLanguage();
        this.setLayout(new FlowLayout(0, 5, 0));
        this.count = this.ticker.getRunningUploadingThreads();
        this.countLabel.setText("" + this.count);
        this.add(this.uploadingLabel);
        this.add(this.countLabel);
        this.add(this.filesLabel);
        this.ticker.addUploadTickerListener(this.listener);
        this.language.addLanguageListener(this.listener);
    }

    private void refreshLanguage() {
        this.uploadingLabel.setText(this.language.getString("UploadStatusPanel.Uploading"));
        if (this.count == 1) {
            this.filesLabel.setText(this.language.getString("StatusPanel.file"));
        } else {
            this.filesLabel.setText(this.language.getString("StatusPanel.files"));
        }
    }

    private void numberChanged() {
        this.count = this.ticker.getRunningUploadingThreads();
        this.countLabel.setText("" + this.count);
        this.refreshLanguage();
    }

    private class Listener
    implements UploadTickerListener,
    LanguageListener {
        private Listener() {
        }

        public void uploadingCountChanged() {
            UploadStatusPanel.this.numberChanged();
        }

        public void generatingCountChanged() {
            UploadStatusPanel.this.numberChanged();
        }

        public void languageChanged(LanguageEvent languageEvent) {
            UploadStatusPanel.this.refreshLanguage();
        }
    }
}

