/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.upload;

import frost.FileAccess;
import frost.SettingsClass;
import frost.boards.TofTreeModel;
import frost.ext.Execute;
import frost.fileTransfer.upload.FrostUploadItem;
import frost.fileTransfer.upload.UploadModel;
import frost.fileTransfer.upload.UploadTableFormat;
import frost.gui.objects.Board;
import frost.util.gui.JSkinnablePopupMenu;
import frost.util.gui.MiscToolkit;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import frost.util.model.ModelItem;
import frost.util.model.OrderedModel;
import frost.util.model.gui.SortedModelTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class UploadPanel
extends JPanel {
    private PopupMenuUpload popupMenuUpload = null;
    private Listener listener = new Listener();
    private static Logger logger = Logger.getLogger(UploadPanel.class.getName());
    private UploadModel model = null;
    private TofTreeModel tofTreeModel = null;
    private SettingsClass settingsClass = null;
    private Language language = null;
    private JPanel uploadTopPanel = new JPanel();
    private JButton uploadAddFilesButton = new JButton(new ImageIcon(this.getClass().getResource("/data/browse.gif")));
    private SortedModelTable modelTable;
    private boolean initialized = false;

    public UploadPanel(SettingsClass settingsClass) {
        this.settingsClass = settingsClass;
        this.language = Language.getInstance();
        this.language.addLanguageListener(this.listener);
    }

    public void initialize() {
        if (!this.initialized) {
            this.refreshLanguage();
            MiscToolkit miscToolkit = MiscToolkit.getInstance();
            miscToolkit.configureButton(this.uploadAddFilesButton, "/data/browse_rollover.gif");
            this.uploadTopPanel.setLayout(new FlowLayout(0, 8, 0));
            this.uploadTopPanel.add(this.uploadAddFilesButton);
            UploadTableFormat uploadTableFormat = new UploadTableFormat();
            this.modelTable = new SortedModelTable((OrderedModel)this.model, uploadTableFormat);
            this.setLayout(new BorderLayout());
            this.add((Component)this.uploadTopPanel, "North");
            this.add((Component)this.modelTable.getScrollPane(), "Center");
            this.fontChanged();
            this.uploadAddFilesButton.addActionListener(this.listener);
            this.modelTable.getScrollPane().addMouseListener(this.listener);
            this.modelTable.getTable().addKeyListener(this.listener);
            this.modelTable.getTable().addMouseListener(this.listener);
            this.settingsClass.addPropertyChangeListener("fileListFontName", this.listener);
            this.settingsClass.addPropertyChangeListener("fileListFontSize", this.listener);
            this.settingsClass.addPropertyChangeListener("fileListFontStyle", this.listener);
            this.initialized = true;
        }
    }

    public void setAddFilesButtonEnabled(boolean bl) {
        this.uploadAddFilesButton.setEnabled(bl);
    }

    private void refreshLanguage() {
        this.uploadAddFilesButton.setToolTipText(this.language.getString("Browse") + "...");
    }

    private PopupMenuUpload getPopupMenuUpload() {
        if (this.popupMenuUpload == null) {
            this.popupMenuUpload = new PopupMenuUpload();
            this.language.addLanguageListener(this.popupMenuUpload);
        }
        return this.popupMenuUpload;
    }

    private void uploadTable_keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\u007f' && !this.modelTable.getTable().isEditing()) {
            ModelItem[] modelItemArray = this.modelTable.getSelectedItems();
            this.model.removeItems(modelItemArray);
            this.modelTable.getTable().clearSelection();
        }
    }

    public void uploadAddFilesButton_actionPerformed(ActionEvent actionEvent) {
        File file;
        Board board = this.tofTreeModel.getSelectedNode();
        if (board.isFolder()) {
            return;
        }
        JFileChooser jFileChooser = new JFileChooser(this.settingsClass.getValue("lastUsedDirectory"));
        jFileChooser.setDialogTitle(this.language.getString("Select files you want to upload to the") + " " + board.getName() + " " + this.language.getString("board") + ".");
        jFileChooser.setFileHidingEnabled(true);
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.setPreferredSize(new Dimension(600, 400));
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            this.settingsClass.setValue("lastUsedDirectory", file.getParent());
            File[] fileArray = jFileChooser.getSelectedFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                ArrayList arrayList = FileAccess.getAllEntries(fileArray[i], "");
                for (int j = 0; j < arrayList.size(); ++j) {
                    File file2 = (File)arrayList.get(j);
                    if (!file2.isFile() || file2.length() <= 0L) continue;
                    FrostUploadItem frostUploadItem = new FrostUploadItem(file2, board);
                    boolean bl = this.model.addUploadItem(frostUploadItem);
                }
            }
        }
    }

    private void showUploadTablePopupMenu(MouseEvent mouseEvent) {
        this.getPopupMenuUpload().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    public void setTofTreeModel(TofTreeModel tofTreeModel) {
        this.tofTreeModel = tofTreeModel;
    }

    private void uploadTableDoubleClick(MouseEvent mouseEvent) {
        ModelItem[] modelItemArray = this.modelTable.getSelectedItems();
        if (modelItemArray.length != 0) {
            FrostUploadItem frostUploadItem = (FrostUploadItem)modelItemArray[0];
            File file = new File(frostUploadItem.getFilePath());
            logger.info("Executing: " + file.getPath());
            if (file.exists()) {
                Execute.run("exec.bat \"" + file.getPath() + "\"");
            }
        }
    }

    private void fontChanged() {
        int n;
        int n2;
        String string = this.settingsClass.getValue("fileListFontName");
        Font font = new Font(string, n2 = this.settingsClass.getIntValue("fileListFontStyle"), n = this.settingsClass.getIntValue("fileListFontSize"));
        if (!font.getFamily().equals(string)) {
            logger.severe("The selected font was not found in your system\nThat selection will be changed to \"SansSerif\".");
            this.settingsClass.setValue("fileListFontName", "SansSerif");
            font = new Font("SansSerif", n2, n);
        }
        this.modelTable.setFont(font);
    }

    public void setModel(UploadModel uploadModel) {
        this.model = uploadModel;
    }

    private class Listener
    extends MouseAdapter
    implements LanguageListener,
    KeyListener,
    ActionListener,
    MouseListener,
    PropertyChangeListener {
        public void languageChanged(LanguageEvent languageEvent) {
            UploadPanel.this.refreshLanguage();
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getSource() == UploadPanel.this.modelTable.getTable()) {
                UploadPanel.this.uploadTable_keyPressed(keyEvent);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == UploadPanel.this.uploadAddFilesButton) {
                UploadPanel.this.uploadAddFilesButton_actionPerformed(actionEvent);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                if (mouseEvent.getSource() == UploadPanel.this.modelTable.getTable()) {
                    UploadPanel.this.uploadTableDoubleClick(mouseEvent);
                }
            } else if (mouseEvent.isPopupTrigger() && (mouseEvent.getSource() == UploadPanel.this.modelTable.getTable() || mouseEvent.getSource() == UploadPanel.this.modelTable.getScrollPane())) {
                UploadPanel.this.showUploadTablePopupMenu(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 1 && mouseEvent.isPopupTrigger() && (mouseEvent.getSource() == UploadPanel.this.modelTable.getTable() || mouseEvent.getSource() == UploadPanel.this.modelTable.getScrollPane())) {
                UploadPanel.this.showUploadTablePopupMenu(mouseEvent);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("fileListFontName")) {
                UploadPanel.this.fontChanged();
            }
            if (propertyChangeEvent.getPropertyName().equals("fileListFontSize")) {
                UploadPanel.this.fontChanged();
            }
            if (propertyChangeEvent.getPropertyName().equals("fileListFontStyle")) {
                UploadPanel.this.fontChanged();
            }
        }
    }

    private class PopupMenuUpload
    extends JSkinnablePopupMenu
    implements ActionListener,
    LanguageListener,
    ClipboardOwner {
        private JMenuItem cancelItem = new JMenuItem();
        private JMenuItem copyKeysAndNamesItem = new JMenuItem();
        private JMenuItem copyKeysItem = new JMenuItem();
        private JMenuItem copyExtendedInfoItem = new JMenuItem();
        private JMenuItem generateChkForSelectedFilesItem = new JMenuItem();
        private JMenuItem reloadAllFilesItem = new JMenuItem();
        private JMenuItem reloadSelectedFilesItem = new JMenuItem();
        private JMenuItem removeAllFilesItem = new JMenuItem();
        private JMenuItem removeSelectedFilesItem = new JMenuItem();
        private JMenuItem restoreDefaultFilenamesForAllFilesItem = new JMenuItem();
        private JMenuItem restoreDefaultFilenamesForSelectedFilesItem = new JMenuItem();
        private JMenuItem setPrefixForAllFilesItem = new JMenuItem();
        private JMenuItem setPrefixForSelectedFilesItem = new JMenuItem();
        private JMenu changeDestinationBoardMenu = new JMenu();
        private JMenu copyToClipboardMenu = new JMenu();
        private String keyNotAvailableMessage;
        private String fileMessage;
        private String keyMessage;
        private String bytesMessage;
        private Clipboard clipboard;

        public PopupMenuUpload() {
            this.initialize();
        }

        private void initialize() {
            this.refreshLanguage();
            this.copyToClipboardMenu.add(this.copyKeysAndNamesItem);
            this.copyToClipboardMenu.add(this.copyKeysItem);
            this.copyToClipboardMenu.add(this.copyExtendedInfoItem);
            this.copyKeysAndNamesItem.addActionListener(this);
            this.copyKeysItem.addActionListener(this);
            this.copyExtendedInfoItem.addActionListener(this);
            this.removeSelectedFilesItem.addActionListener(this);
            this.removeAllFilesItem.addActionListener(this);
            this.reloadSelectedFilesItem.addActionListener(this);
            this.reloadAllFilesItem.addActionListener(this);
            this.generateChkForSelectedFilesItem.addActionListener(this);
            this.setPrefixForSelectedFilesItem.addActionListener(this);
            this.setPrefixForAllFilesItem.addActionListener(this);
            this.restoreDefaultFilenamesForSelectedFilesItem.addActionListener(this);
            this.restoreDefaultFilenamesForAllFilesItem.addActionListener(this);
        }

        private void refreshLanguage() {
            this.keyNotAvailableMessage = UploadPanel.this.language.getString("Key not available yet");
            this.fileMessage = UploadPanel.this.language.getString("clipboard.File:");
            this.keyMessage = UploadPanel.this.language.getString("clipboard.Key:");
            this.bytesMessage = UploadPanel.this.language.getString("clipboard.Bytes:");
            this.cancelItem.setText(UploadPanel.this.language.getString("Cancel"));
            this.copyKeysItem.setText(UploadPanel.this.language.getString("Copy keys only"));
            this.copyKeysAndNamesItem.setText(UploadPanel.this.language.getString("Copy keys with filenames"));
            this.copyExtendedInfoItem.setText(UploadPanel.this.language.getString("Copy extended info"));
            this.generateChkForSelectedFilesItem.setText(UploadPanel.this.language.getString("Start encoding of selected files"));
            this.reloadAllFilesItem.setText(UploadPanel.this.language.getString("Reload all files"));
            this.reloadSelectedFilesItem.setText(UploadPanel.this.language.getString("Reload selected files"));
            this.removeAllFilesItem.setText(UploadPanel.this.language.getString("Remove all files"));
            this.removeSelectedFilesItem.setText(UploadPanel.this.language.getString("Remove selected files"));
            this.restoreDefaultFilenamesForAllFilesItem.setText(UploadPanel.this.language.getString("Restore default filenames for all files"));
            this.restoreDefaultFilenamesForSelectedFilesItem.setText(UploadPanel.this.language.getString("Restore default filenames for selected files"));
            this.setPrefixForAllFilesItem.setText(UploadPanel.this.language.getString("Set prefix for all files"));
            this.setPrefixForSelectedFilesItem.setText(UploadPanel.this.language.getString("Set prefix for selected files"));
            this.changeDestinationBoardMenu.setText(UploadPanel.this.language.getString("Change destination board"));
            this.copyToClipboardMenu.setText(UploadPanel.this.language.getString("Copy to clipboard") + "...");
        }

        private Clipboard getClipboard() {
            if (this.clipboard == null) {
                this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            return this.clipboard;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.copyKeysItem) {
                this.copyKeys();
            }
            if (actionEvent.getSource() == this.copyKeysAndNamesItem) {
                this.copyKeysAndNames();
            }
            if (actionEvent.getSource() == this.copyExtendedInfoItem) {
                this.copyExtendedInfo();
            }
            if (actionEvent.getSource() == this.removeSelectedFilesItem) {
                this.removeSelectedFiles();
            }
            if (actionEvent.getSource() == this.removeAllFilesItem) {
                this.removeAllFiles();
            }
            if (actionEvent.getSource() == this.reloadSelectedFilesItem) {
                this.reloadSelectedFiles();
            }
            if (actionEvent.getSource() == this.reloadAllFilesItem) {
                this.reloadAllFiles();
            }
            if (actionEvent.getSource() == this.generateChkForSelectedFilesItem) {
                this.generateChkForSelectedFiles();
            }
            if (actionEvent.getSource() == this.setPrefixForSelectedFilesItem) {
                this.setPrefixForSelectedFiles();
            }
            if (actionEvent.getSource() == this.setPrefixForAllFilesItem) {
                this.setPrefixForAllFiles();
            }
            if (actionEvent.getSource() == this.restoreDefaultFilenamesForSelectedFilesItem) {
                this.restoreDefaultFilenamesForSelectedFiles();
            }
            if (actionEvent.getSource() == this.restoreDefaultFilenamesForAllFilesItem) {
                this.restoreDefaultFilenamesForAllFiles();
            }
        }

        private void restoreDefaultFilenamesForAllFiles() {
            UploadPanel.this.model.removePrefixFromAllItems();
        }

        private void restoreDefaultFilenamesForSelectedFiles() {
            UploadPanel.this.model.removePrefixFromItems(UploadPanel.this.modelTable.getSelectedItems());
        }

        private void setPrefixForAllFiles() {
            String string = JOptionPane.showInputDialog(UploadPanel.this.language.getString("Please enter the prefix you want to use for your files."));
            if (string != null) {
                UploadPanel.this.model.setPrefixToAllItems(string);
            }
        }

        private void setPrefixForSelectedFiles() {
            String string = JOptionPane.showInputDialog(UploadPanel.this.language.getString("Please enter the prefix you want to use for your files."));
            if (string != null) {
                UploadPanel.this.model.setPrefixToItems(UploadPanel.this.modelTable.getSelectedItems(), string);
            }
        }

        private void generateChkForSelectedFiles() {
            ModelItem[] modelItemArray = UploadPanel.this.modelTable.getSelectedItems();
            UploadPanel.this.model.generateChkItems(modelItemArray);
        }

        private void reloadAllFiles() {
            UploadPanel.this.model.requestAllItems();
        }

        private void reloadSelectedFiles() {
            ModelItem[] modelItemArray = UploadPanel.this.modelTable.getSelectedItems();
            UploadPanel.this.model.requestItems(modelItemArray);
        }

        private void removeAllFiles() {
            UploadPanel.this.model.clear();
        }

        private void removeSelectedFiles() {
            ModelItem[] modelItemArray = UploadPanel.this.modelTable.getSelectedItems();
            UploadPanel.this.model.removeItems(modelItemArray);
        }

        private void copyKeysAndNames() {
            ModelItem[] modelItemArray = UploadPanel.this.modelTable.getSelectedItems();
            if (modelItemArray.length > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < modelItemArray.length; ++i) {
                    FrostUploadItem frostUploadItem = (FrostUploadItem)modelItemArray[i];
                    String string = frostUploadItem.getKey();
                    if (string == null) {
                        string = this.keyNotAvailableMessage;
                    }
                    stringBuffer.append(string);
                    stringBuffer.append("/");
                    stringBuffer.append(frostUploadItem.getFileName());
                    stringBuffer.append("\n");
                }
                StringSelection stringSelection = new StringSelection(stringBuffer.toString());
                this.getClipboard().setContents(stringSelection, this);
            }
        }

        private void copyExtendedInfo() {
            ModelItem[] modelItemArray = UploadPanel.this.modelTable.getSelectedItems();
            if (modelItemArray.length > 0) {
                Object object;
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < modelItemArray.length; ++i) {
                    object = (FrostUploadItem)modelItemArray[i];
                    String string = ((FrostUploadItem)object).getKey();
                    if (string == null) {
                        string = this.keyNotAvailableMessage;
                    }
                    stringBuffer.append(this.fileMessage);
                    stringBuffer.append(((FrostUploadItem)object).getFileName() + "\n");
                    stringBuffer.append(this.keyMessage);
                    stringBuffer.append(string + "\n");
                    stringBuffer.append(this.bytesMessage);
                    stringBuffer.append(((FrostUploadItem)object).getFileSize() + "\n\n");
                }
                String string = stringBuffer.substring(0, stringBuffer.length() - 1);
                object = new StringSelection(string);
                this.getClipboard().setContents((Transferable)object, this);
            }
        }

        private void copyKeys() {
            ModelItem[] modelItemArray = UploadPanel.this.modelTable.getSelectedItems();
            if (modelItemArray.length > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < modelItemArray.length; ++i) {
                    FrostUploadItem frostUploadItem = (FrostUploadItem)modelItemArray[i];
                    String string = frostUploadItem.getKey();
                    if (string == null) {
                        string = this.keyNotAvailableMessage;
                    }
                    stringBuffer.append(string);
                    stringBuffer.append("\n");
                }
                StringSelection stringSelection = new StringSelection(stringBuffer.toString());
                this.getClipboard().setContents(stringSelection, this);
            }
        }

        public void languageChanged(LanguageEvent languageEvent) {
            this.refreshLanguage();
        }

        public void show(Component component, int n, int n2) {
            this.removeAll();
            ModelItem[] modelItemArray = UploadPanel.this.modelTable.getSelectedItems();
            if (modelItemArray.length > 0) {
                this.add(this.copyToClipboardMenu);
                this.addSeparator();
            }
            JMenu jMenu = new JMenu(UploadPanel.this.language.getString("Remove") + "...");
            if (modelItemArray.length != 0) {
                jMenu.add(this.removeSelectedFilesItem);
            }
            jMenu.add(this.removeAllFilesItem);
            this.add(jMenu);
            this.addSeparator();
            if (modelItemArray.length != 0) {
                this.add(this.generateChkForSelectedFilesItem);
                this.add(this.reloadSelectedFilesItem);
            }
            this.add(this.reloadAllFilesItem);
            this.addSeparator();
            if (!UploadPanel.this.settingsClass.getBoolValue("automaticIndexing")) {
                boolean bl = true;
                for (int i = 0; i < modelItemArray.length; ++i) {
                    FrostUploadItem frostUploadItem = (FrostUploadItem)modelItemArray[i];
                    if (frostUploadItem.getSHA1() == null || frostUploadItem.getSHA1().length() <= 0) continue;
                    bl = false;
                    break;
                }
                if (modelItemArray.length != 0) {
                    this.add(this.setPrefixForSelectedFilesItem);
                    this.setPrefixForSelectedFilesItem.setEnabled(bl);
                }
                if (modelItemArray.length != 0) {
                    this.add(this.restoreDefaultFilenamesForSelectedFilesItem);
                    this.restoreDefaultFilenamesForSelectedFilesItem.setEnabled(bl);
                }
                this.addSeparator();
                if (modelItemArray.length != 0) {
                    Vector vector = UploadPanel.this.tofTreeModel.getAllBoards();
                    Collections.sort(vector);
                    this.changeDestinationBoardMenu.removeAll();
                    for (int i = 0; i < vector.size(); ++i) {
                        final Board board = (Board)vector.elementAt(i);
                        JMenuItem jMenuItem = new JMenuItem(board.getName());
                        this.changeDestinationBoardMenu.add(jMenuItem);
                        jMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                ModelItem[] modelItemArray = UploadPanel.this.modelTable.getSelectedItems();
                                for (int i = 0; i < modelItemArray.length; ++i) {
                                    FrostUploadItem frostUploadItem = (FrostUploadItem)modelItemArray[i];
                                    frostUploadItem.setTargetBoard(board);
                                }
                            }
                        });
                    }
                    this.add(this.changeDestinationBoardMenu);
                    this.changeDestinationBoardMenu.setEnabled(bl);
                }
            }
            this.addSeparator();
            this.add(this.cancelItem);
            super.show(component, n, n2);
        }

        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }
    }
}

