/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.upload;

import frost.FileAccess;
import frost.MainFrame;
import frost.SettingsClass;
import frost.XMLTools;
import frost.fileTransfer.upload.FrostUploadItem;
import frost.fileTransfer.upload.UploadModel;
import frost.fileTransfer.upload.UploadModelDAO;
import frost.gui.objects.Board;
import frost.storage.StorageException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class UploadModelXmlDAO
implements UploadModelDAO {
    private static Logger logger = Logger.getLogger(UploadModelXmlDAO.class.getName());
    private static ResourceBundle langRes = ResourceBundle.getBundle("res.LangRes");
    private static final String XML_FILENAME = "uploads.xml";
    private static final String TMP_FILENAME = "uploads.xml.tmp";
    private static final String BAK_FILENAME = "uploads.xml.bak";
    private String directory;

    public UploadModelXmlDAO(SettingsClass settingsClass) {
        this.directory = settingsClass.getValue("config.dir");
    }

    public boolean exists() {
        File file = new File(this.directory + XML_FILENAME);
        if (file.length() == 0L) {
            file.delete();
        }
        return file.exists();
    }

    public void load(UploadModel uploadModel) throws StorageException {
        Document document = null;
        try {
            document = XMLTools.parseXmlFile(this.directory + XML_FILENAME, false);
        }
        catch (Exception exception) {
            throw new StorageException("Exception while parsing the uploads model XML file.");
        }
        if (document == null) {
            throw new StorageException("Could not parse the uploads model XML file.");
        }
        Element element = document.getDocumentElement();
        if (!element.getTagName().equals("FrostUploadTable")) {
            throw new StorageException("The uploads model XML file is invalid: does not contain the root tag FrostUploadTable.");
        }
        ArrayList arrayList = XMLTools.getChildElementsByTagName(element, "FrostUploadTableItemList");
        if (arrayList.size() != 1) {
            throw new StorageException("The uploads model XML file is invalid: FrostUploadTableItemList not found or duplicated.");
        }
        Element element2 = (Element)arrayList.get(0);
        if ((arrayList = XMLTools.getChildElementsByTagName(element2, "FrostUploadTableItem")).size() == 0) {
            logger.info("The uploads model XML file has no items.");
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                Element element3 = (Element)arrayList.get(i);
                FrostUploadItem frostUploadItem = this.createUploadItem(element3);
                if (frostUploadItem == null) continue;
                uploadModel.addUploadItem(frostUploadItem);
            }
            logger.info("Loaded " + arrayList.size() + " items into the uploads model.");
        }
    }

    private FrostUploadItem createUploadItem(Element element) {
        File file;
        String string = XMLTools.getChildElementsCDATAValue(element, "filename");
        String string2 = XMLTools.getChildElementsCDATAValue(element, "filepath");
        String string3 = XMLTools.getChildElementsTextValue(element, "targetboard");
        String string4 = XMLTools.getChildElementsTextValue(element, "state");
        String string5 = XMLTools.getChildElementsTextValue(element, "lastuploaddate");
        String string6 = XMLTools.getChildElementsTextValue(element, "dateShared");
        String string7 = XMLTools.getChildElementsCDATAValue(element, "key");
        String string8 = XMLTools.getChildElementsCDATAValue(element, "SHA1");
        String string9 = XMLTools.getChildElementsTextValue(element, "batch");
        String string10 = element.getAttribute("enabled");
        String string11 = XMLTools.getChildElementsTextValue(element, "retries");
        if (string == null || string2 == null || string3 == null || string4 == null) {
            logger.warning("Invalid upload item found. Removed.");
            return null;
        }
        int n = 0;
        if (string11 != null) {
            n = Integer.parseInt(string11);
        }
        int n2 = -1;
        try {
            n2 = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = -1;
        }
        if (n2 < 0) {
            if (string4.indexOf("Kb") != -1 || string4.equals(langRes.getString("Uploading"))) {
                n2 = 2;
            }
        } else if (n2 == 4 || n2 == 3) {
            n2 = 2;
        } else if (n2 == 6 || n2 == 5) {
            n2 = 1;
        }
        if (string7 != null && !string7.startsWith("CHK@")) {
            string7 = null;
        }
        if (!(file = new File(string2)).isFile() || file.length() == 0L) {
            logger.warning("Upload item found with no corresponding file (" + string2 + "). Removed.");
            return null;
        }
        Board board = MainFrame.getInstance().getTofTreeModel().getBoardByName(string3);
        if (board == null) {
            logger.warning("Upload item found (" + string2 + ") whose target board (" + string3 + ") does not exist. Removed.");
            return null;
        }
        boolean bl = false;
        if (string10 == null || string10.length() == 0 || string10.toLowerCase().equals("true")) {
            bl = true;
        }
        FrostUploadItem frostUploadItem = new FrostUploadItem(string, string2, file.length(), board, n2, string5, string7, string8);
        frostUploadItem.setBatch(string9);
        frostUploadItem.setEnabled(new Boolean(bl));
        frostUploadItem.setRetries(n);
        return frostUploadItem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save(UploadModel uploadModel) throws StorageException {
        Object object;
        Document document = XMLTools.createDomDocument();
        if (document == null) {
            throw new StorageException("Could not create the XML document.");
        }
        Element element = document.createElement("FrostUploadTable");
        document.appendChild(element);
        Element element2 = document.createElement("FrostUploadTableItemList");
        element.appendChild(element2);
        for (int i = 0; i < uploadModel.getItemCount(); ++i) {
            object = (FrostUploadItem)uploadModel.getItemAt(i);
            Element element3 = this.createElement((FrostUploadItem)object, document);
            element2.appendChild(element3);
        }
        File file = new File(this.directory + XML_FILENAME);
        if (file.exists()) {
            object = new File(this.directory + BAK_FILENAME);
            ((File)object).delete();
            if (!FileAccess.copyFile(this.directory + XML_FILENAME, this.directory + BAK_FILENAME)) {
                logger.log(Level.SEVERE, "Error while copying uploads.xml to uploads.xml.bak");
            }
        }
        if (((File)(object = new File(this.directory + TMP_FILENAME))).exists()) {
            ((File)object).delete();
        }
        if (!XMLTools.writeXmlFile(document, this.directory + TMP_FILENAME)) throw new StorageException("Could not save uploads.xml");
        if (!((File)object).exists()) throw new StorageException("Could not save uploads.xml");
        file.delete();
        if (((File)object).renameTo(file) || FileAccess.copyFile(this.directory + BAK_FILENAME, this.directory + XML_FILENAME)) return;
        throw new StorageException("Error while restoring uploads.xml");
    }

    private Element createElement(FrostUploadItem frostUploadItem, Document document) {
        Element element = document.createElement("FrostUploadTableItem");
        Element element2 = document.createElement("filename");
        CDATASection cDATASection = document.createCDATASection(frostUploadItem.getFileName());
        element2.appendChild(cDATASection);
        element.appendChild(element2);
        element2 = document.createElement("filepath");
        cDATASection = document.createCDATASection(frostUploadItem.getFilePath());
        element2.appendChild(cDATASection);
        element.appendChild(element2);
        element2 = document.createElement("targetboard");
        Text text = document.createTextNode(frostUploadItem.getTargetBoard().getName());
        element2.appendChild(text);
        element.appendChild(element2);
        element2 = document.createElement("state");
        text = document.createTextNode(String.valueOf(frostUploadItem.getState()));
        element2.appendChild(text);
        element.appendChild(element2);
        element2 = document.createElement("batch");
        text = document.createTextNode(frostUploadItem.getBatch());
        element2.appendChild(text);
        element.appendChild(element2);
        if (frostUploadItem.getKey() != null) {
            element2 = document.createElement("key");
            cDATASection = document.createCDATASection(frostUploadItem.getKey());
            element2.appendChild(cDATASection);
            element.appendChild(element2);
        }
        if (frostUploadItem.getSHA1() != null) {
            element2 = document.createElement("SHA1");
            cDATASection = document.createCDATASection(frostUploadItem.getSHA1());
            element2.appendChild(cDATASection);
            element.appendChild(element2);
        }
        if (frostUploadItem.getLastUploadDate() != null) {
            element2 = document.createElement("lastuploaddate");
            text = document.createTextNode(frostUploadItem.getLastUploadDate());
            element2.appendChild(text);
            element.appendChild(element2);
        }
        String string = frostUploadItem.isEnabled() == null ? "true" : frostUploadItem.isEnabled().toString();
        element.setAttribute("enabled", string);
        element2 = document.createElement("retries");
        text = document.createTextNode(String.valueOf(frostUploadItem.getRetries()));
        element2.appendChild(text);
        element.appendChild(element2);
        return element;
    }

    public void create() throws StorageException {
        File file = new File(this.directory + XML_FILENAME);
        try {
            boolean bl = file.createNewFile();
            if (!bl) {
                throw new StorageException("There was a problem while creating the storage.");
            }
        }
        catch (IOException iOException) {
            throw new StorageException("There was a problem while creating the storage.", iOException);
        }
    }
}

