/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.upload;

import frost.SettingsClass;
import frost.fileTransfer.upload.FrostUploadItem;
import frost.fileTransfer.upload.UploadModelDAO;
import frost.storage.DAOFactory;
import frost.storage.Savable;
import frost.storage.StorageException;
import frost.util.model.ModelItem;
import frost.util.model.OrderedModel;
import java.io.File;
import java.util.ArrayList;

public class UploadModel
extends OrderedModel
implements Savable {
    private SettingsClass settings;

    public UploadModel(SettingsClass settingsClass) {
        this.settings = settingsClass;
    }

    public synchronized boolean addUploadItem(FrostUploadItem frostUploadItem) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            FrostUploadItem frostUploadItem2 = (FrostUploadItem)this.getItemAt(i);
            if (!frostUploadItem2.getFilePath().equals(frostUploadItem.getFilePath())) continue;
            return false;
        }
        this.addItem(frostUploadItem);
        return true;
    }

    public synchronized boolean containsItemWithKey(String string) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            FrostUploadItem frostUploadItem = (FrostUploadItem)this.getItemAt(i);
            if (frostUploadItem.getSHA1() == null || !frostUploadItem.getSHA1().equals(string)) continue;
            return true;
        }
        return false;
    }

    public synchronized void removeNotExistingFiles() {
        ArrayList<FrostUploadItem> arrayList = new ArrayList<FrostUploadItem>();
        for (int i = this.getItemCount() - 1; i >= 0; --i) {
            FrostUploadItem frostUploadItem = (FrostUploadItem)this.getItemAt(i);
            File file = new File(frostUploadItem.getFilePath());
            if (file.exists()) continue;
            arrayList.add(frostUploadItem);
        }
        if (arrayList.size() > 0) {
            ModelItem[] modelItemArray = new FrostUploadItem[arrayList.size()];
            for (int i = 0; i < modelItemArray.length; ++i) {
                modelItemArray[i] = (FrostUploadItem)arrayList.get(i);
            }
            this.removeItems(modelItemArray);
        }
    }

    public synchronized void requestAllItems() {
        for (FrostUploadItem frostUploadItem : this.data) {
            if (frostUploadItem.getState() == 3 || frostUploadItem.getState() == 4 || frostUploadItem.getState() == 6) continue;
            frostUploadItem.setRetries(0);
            frostUploadItem.setLastUploadStopTimeMillis(0L);
            frostUploadItem.setEnabled(true);
            frostUploadItem.setState(2);
        }
    }

    public void requestItems(ModelItem[] modelItemArray) {
        for (int i = 0; i < modelItemArray.length; ++i) {
            FrostUploadItem frostUploadItem = (FrostUploadItem)modelItemArray[i];
            if (frostUploadItem.getState() == 3 || frostUploadItem.getState() == 4 || frostUploadItem.getState() == 6) continue;
            frostUploadItem.setRetries(0);
            frostUploadItem.setLastUploadStopTimeMillis(0L);
            frostUploadItem.setEnabled(true);
            frostUploadItem.setState(2);
        }
    }

    public void generateChkItems(ModelItem[] modelItemArray) {
        for (int i = 0; i < modelItemArray.length; ++i) {
            FrostUploadItem frostUploadItem = (FrostUploadItem)modelItemArray[i];
            if (frostUploadItem.getState() != 1 || frostUploadItem.getKey() != null) continue;
            frostUploadItem.setState(5);
        }
    }

    public void save() throws StorageException {
        UploadModelDAO uploadModelDAO = DAOFactory.getFactory(1).getUploadModelDAO();
        uploadModelDAO.save(this);
    }

    public void setPrefixToItems(ModelItem[] modelItemArray, String string) {
        for (int i = 0; i < modelItemArray.length; ++i) {
            FrostUploadItem frostUploadItem = (FrostUploadItem)modelItemArray[i];
            String string2 = string + frostUploadItem.getFileName();
            frostUploadItem.setFileName(string2);
        }
    }

    public void removePrefixFromItems(ModelItem[] modelItemArray) {
        for (int i = 0; i < modelItemArray.length; ++i) {
            FrostUploadItem frostUploadItem = (FrostUploadItem)modelItemArray[i];
            File file = new File(frostUploadItem.getFilePath());
            if (!file.isFile()) continue;
            frostUploadItem.setFileName(file.getName());
        }
    }

    public synchronized void removePrefixFromAllItems() {
        for (FrostUploadItem frostUploadItem : this.data) {
            File file = new File(frostUploadItem.getFilePath());
            if (!file.isFile()) continue;
            frostUploadItem.setFileName(file.getName());
        }
    }

    public synchronized void setPrefixToAllItems(String string) {
        for (FrostUploadItem frostUploadItem : this.data) {
            String string2 = string + frostUploadItem.getFileName();
            frostUploadItem.setFileName(string2);
        }
    }

    public void initialize() throws StorageException {
        UploadModelDAO uploadModelDAO = DAOFactory.getFactory(1).getUploadModelDAO();
        if (!uploadModelDAO.exists()) {
            uploadModelDAO.create();
        } else {
            uploadModelDAO.load(this);
        }
    }
}

