/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.upload;

import frost.MainFrame;
import frost.SettingsClass;
import frost.boards.TofTreeModel;
import frost.fileTransfer.upload.UploadModel;
import frost.fileTransfer.upload.UploadPanel;
import frost.fileTransfer.upload.UploadStatusPanel;
import frost.fileTransfer.upload.UploadTicker;
import frost.identities.LocalIdentity;
import frost.storage.StorageException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class UploadManager
implements PropertyChangeListener {
    private LocalIdentity myID;
    private TofTreeModel tofTreeModel;
    private MainFrame mainFrame;
    private SettingsClass settings;
    private UploadModel model;
    private UploadPanel panel;
    private UploadTicker ticker;
    private UploadStatusPanel statusPanel;
    private boolean freenetIsOnline;

    public UploadManager(SettingsClass settingsClass) {
        this.settings = settingsClass;
    }

    public void initialize() throws StorageException {
        this.mainFrame.addPanel("Uploads", this.getPanel());
        this.mainFrame.addStatusPanel(this.getStatusPanel(), 0);
        this.settings.addPropertyChangeListener("disableRequests", this);
        this.updateUploadStatus();
        this.getModel().initialize();
        if (this.freenetIsOnline) {
            this.getTicker().start();
        }
    }

    public void setTofTreeModel(TofTreeModel tofTreeModel) {
        this.tofTreeModel = tofTreeModel;
    }

    public void setMainFrame(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public void setFreenetIsOnline(boolean bl) {
        this.freenetIsOnline = bl;
    }

    public UploadPanel getPanel() {
        if (this.panel == null) {
            this.panel = new UploadPanel(this.settings);
            this.panel.setModel(this.getModel());
            this.panel.setTofTreeModel(this.tofTreeModel);
            this.panel.initialize();
        }
        return this.panel;
    }

    private UploadStatusPanel getStatusPanel() {
        if (this.statusPanel == null) {
            this.statusPanel = new UploadStatusPanel(this.getTicker());
        }
        return this.statusPanel;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("disableRequests")) {
            this.updateUploadStatus();
        }
    }

    private void updateUploadStatus() {
        boolean bl = this.settings.getBoolValue("disableRequests");
        this.mainFrame.setPanelEnabled("Uploads", !bl && this.freenetIsOnline);
    }

    private UploadTicker getTicker() {
        if (this.ticker == null) {
            this.ticker = new UploadTicker(this.settings, this.getModel(), this.getPanel(), this.myID);
        }
        return this.ticker;
    }

    public void setMyID(LocalIdentity localIdentity) {
        this.myID = localIdentity;
    }

    public UploadModel getModel() {
        if (this.model == null) {
            this.model = new UploadModel(this.settings);
        }
        return this.model;
    }
}

