/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.upload;

import frost.gui.model.TableMember;
import frost.gui.objects.Board;
import frost.util.model.ModelItem;
import java.io.File;

public class FrostUploadItem
extends ModelItem {
    public static final int FIELD_ID_DONE_BLOCKS = 100;
    public static final int FIELD_ID_FILE_NAME = 101;
    public static final int FIELD_ID_FILE_PATH = 102;
    public static final int FIELD_ID_FILE_SIZE = 103;
    public static final int FIELD_ID_KEY = 104;
    public static final int FIELD_ID_LAST_UPLOAD_DATE = 105;
    public static final int FIELD_ID_TOTAL_BLOCKS = 106;
    public static final int FIELD_ID_SHA1 = 107;
    public static final int FIELD_ID_STATE = 108;
    public static final int FIELD_ID_TARGET_BOARD = 109;
    public static final int FIELD_ID_ENABLED = 110;
    public static final int FIELD_ID_RETRIES = 111;
    public static final int STATE_IDLE = 1;
    public static final int STATE_REQUESTED = 2;
    public static final int STATE_UPLOADING = 3;
    public static final int STATE_PROGRESS = 4;
    public static final int STATE_ENCODING_REQUESTED = 5;
    public static final int STATE_ENCODING = 6;
    public static final int STATE_WAITING = 7;
    private int state;
    private String fileName;
    private String filePath;
    private Long fileSize;
    private String key;
    private String sha1;
    private Board targetBoard;
    private int totalBlocks = -1;
    private int doneBlocks = -1;
    private String lastUploadDate;
    private Boolean enabled = new Boolean(true);
    private int retries;
    private int nextState = 0;
    private String batch = null;
    private long lastUploadStopTimeMillis = 0L;

    public FrostUploadItem(File file, Board board) {
        if (file != null) {
            this.fileName = file.getName();
            this.filePath = file.getPath();
            this.fileSize = new Long(file.length());
        } else assert (board == null) : "constructor called with null file, but not null board";
        this.targetBoard = board;
        this.state = 1;
        this.lastUploadDate = null;
        this.key = null;
        this.sha1 = null;
    }

    public FrostUploadItem(String string, String string2, long l, Board board, int n, String string3, String string4, String string5) {
        this.fileName = string;
        this.filePath = string2;
        this.fileSize = new Long(l);
        this.targetBoard = board;
        this.state = n;
        this.lastUploadDate = string3;
        this.key = string4;
        this.sha1 = string5;
    }

    public Object getValueAt(int n) {
        return null;
    }

    public int compareTo(TableMember tableMember, int n) {
        Comparable comparable = (Comparable)this.getValueAt(n);
        Comparable comparable2 = (Comparable)tableMember.getValueAt(n);
        return comparable.compareTo(comparable2);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        String string2 = this.fileName;
        this.fileName = string;
        this.fireFieldChange(101, string2, string);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String string) {
        String string2 = this.filePath;
        this.filePath = string;
        this.fireFieldChange(102, string2, string);
    }

    public Long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(Long l) {
        Long l2 = this.fileSize;
        this.fileSize = l;
        this.fireFieldChange(103, l2, l);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        String string2 = this.key;
        this.key = string;
        this.fireFieldChange(104, string2, string);
    }

    public String getSHA1() {
        return this.sha1;
    }

    public void setSHA1(String string) {
        String string2 = this.sha1;
        this.sha1 = string;
        this.fireFieldChange(107, string2, string);
    }

    public Board getTargetBoard() {
        return this.targetBoard;
    }

    public void setTargetBoard(Board board) {
        Board board2 = this.targetBoard;
        this.targetBoard = board;
        this.fireFieldChange(109, board2, board);
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        int n2 = this.state;
        this.state = n;
        this.fireFieldChange(108, n2, n);
    }

    public int getNextState() {
        return this.nextState;
    }

    public void setNextState(int n) {
        this.nextState = n;
    }

    public String getBatch() {
        return this.batch;
    }

    public void setBatch(String string) {
        this.batch = string;
    }

    public String getLastUploadDate() {
        return this.lastUploadDate;
    }

    public void setLastUploadDate(String string) {
        String string2 = this.lastUploadDate;
        this.lastUploadDate = string;
        this.fireFieldChange(105, string2, string);
    }

    public void setTotalBlocks(int n) {
        int n2 = this.totalBlocks;
        this.totalBlocks = n;
        this.fireFieldChange(106, n2, n);
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int n) {
        int n2 = this.retries;
        this.retries = n;
        this.fireFieldChange(111, n2, n);
    }

    public void setDoneBlocks(int n) {
        int n2 = this.doneBlocks;
        this.doneBlocks = n;
        this.fireFieldChange(100, n2, n);
    }

    public void setEnabled(Boolean bl) {
        if (bl == null && this.enabled != null) {
            boolean bl2 = this.enabled;
            bl = new Boolean(!bl2);
        }
        Boolean bl3 = this.enabled;
        this.enabled = bl;
        this.fireFieldChange(110, bl3, bl);
    }

    public int getDoneBlocks() {
        return this.doneBlocks;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public int getTotalBlocks() {
        return this.totalBlocks;
    }

    public long getLastUploadStopTimeMillis() {
        return this.lastUploadStopTimeMillis;
    }

    public void setLastUploadStopTimeMillis(long l) {
        this.lastUploadStopTimeMillis = l;
    }
}

