/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.search;

import frost.SettingsClass;
import frost.fileTransfer.Index;
import frost.fileTransfer.download.DownloadModel;
import frost.fileTransfer.search.FrostSearchItem;
import frost.fileTransfer.search.SearchManager;
import frost.fileTransfer.search.SearchModel;
import frost.fileTransfer.search.SearchPanel;
import frost.fileTransfer.upload.UploadModel;
import frost.gui.objects.Board;
import frost.identities.FrostIdentities;
import frost.identities.Identity;
import frost.messages.SharedFileObject;
import java.io.File;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Logger;

class SearchThread
extends Thread {
    private FrostIdentities identities;
    private static Logger logger = Logger.getLogger(SearchThread.class.getName());
    private String request;
    private String board;
    private String date;
    private String keypool;
    private String searchType;
    private Vector results = new Vector();
    private boolean searchAllBoards;
    private Map chk = Collections.synchronizedMap(new TreeMap());
    private String[] audioExtension;
    private String[] videoExtension;
    private String[] imageExtension;
    private String[] documentExtension;
    private String[] executableExtension;
    private String[] archiveExtension;
    private Vector boards;
    private static String fileSeparator = System.getProperty("file.separator");
    int allFileCount;
    int maxSearchResults;
    private SearchPanel searchPanel = null;
    private SearchModel model;
    private DownloadModel downloadModel;
    private UploadModel uploadModel;
    private SettingsClass settings;

    private Vector getSingleRequests() {
        Vector<String> vector = new Vector<String>();
        String string = this.request.trim();
        while (string.indexOf(" ") != -1) {
            int n = string.indexOf(" ");
            vector.add(string.substring(0, n).trim());
            string = string.substring(n, string.length()).trim();
        }
        if (string.length() > 0) {
            vector.add(string);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSearchResults() {
        if (this.request.length() > 0) {
            Vector vector = this.getSingleRequests();
            Map map = this.chk;
            synchronized (map) {
                for (SharedFileObject sharedFileObject : this.chk.values()) {
                    int n;
                    String string = sharedFileObject.getFilename().toLowerCase().trim();
                    boolean bl = true;
                    for (n = 0; n < vector.size(); ++n) {
                        String string2 = (String)vector.elementAt(n);
                        if (string2.startsWith("*") || string.toLowerCase().indexOf(string2) != -1) continue;
                        bl = false;
                    }
                    if (!bl && !this.request.equals("*")) continue;
                    if (this.searchType.equals("All files")) {
                        this.results.add(sharedFileObject);
                        continue;
                    }
                    n = 0;
                    if (this.searchType.equals("Audio")) {
                        n = this.checkType(this.audioExtension, sharedFileObject.getFilename()) ? 1 : 0;
                    }
                    if (this.searchType.equals("Video")) {
                        n = this.checkType(this.videoExtension, sharedFileObject.getFilename()) ? 1 : 0;
                    }
                    if (this.searchType.equals("Images")) {
                        n = this.checkType(this.imageExtension, sharedFileObject.getFilename()) ? 1 : 0;
                    }
                    if (this.searchType.equals("Documents")) {
                        n = this.checkType(this.documentExtension, sharedFileObject.getFilename()) ? 1 : 0;
                    }
                    if (this.searchType.equals("Executables")) {
                        n = this.checkType(this.executableExtension, sharedFileObject.getFilename()) ? 1 : 0;
                    }
                    if (this.searchType.equals("Archives")) {
                        n = this.checkType(this.archiveExtension, sharedFileObject.getFilename()) ? 1 : 0;
                    }
                    if (n == 0) continue;
                    this.results.add(sharedFileObject);
                }
            }
        }
    }

    private boolean checkType(String[] stringArray, String string) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.endsWith(stringArray[i])) continue;
            bl = true;
        }
        return bl;
    }

    private void filterSearchResults() {
        Object object;
        int n;
        Serializable serializable;
        int n2;
        int n3;
        if (this.request.indexOf("*age") != -1) {
            n3 = this.request.indexOf("*age");
            n2 = this.request.indexOf(" ", n3);
            if (n2 == -1) {
                n2 = this.request.length();
            }
            int n4 = 1;
            try {
                n4 = Integer.parseInt(this.request.substring(n3 + 4, n2));
            }
            catch (NumberFormatException numberFormatException) {
                logger.warning("Did not recognice age, using default 1.");
            }
            logger.fine("AGE = " + n4);
            serializable = new GregorianCalendar();
            ((GregorianCalendar)serializable).setTimeZone(TimeZone.getTimeZone("GMT"));
            for (n = this.results.size() - 1; n >= 0; --n) {
                SharedFileObject sharedFileObject = (SharedFileObject)this.results.elementAt(n);
                object = null;
                if (sharedFileObject.getDate() == null) continue;
                object = sharedFileObject.getCal();
                ((GregorianCalendar)object).add(5, n4);
                if (!((Calendar)object).before(serializable)) continue;
                this.results.removeElementAt(n);
                logger.fine("removing because of keyCal");
            }
        }
        n3 = this.settings.getBoolValue("hideAnonFiles") ? 1 : 0;
        n2 = this.settings.getBoolValue("hideBadFiles");
        Iterator iterator = this.results.iterator();
        while (iterator.hasNext()) {
            serializable = (SharedFileObject)iterator.next();
            if ((((SharedFileObject)serializable).getOwner() == null || ((SharedFileObject)serializable).getOwner() != null && ((SharedFileObject)serializable).getOwner().compareToIgnoreCase("anonymous") == 0) && n3 != 0) {
                iterator.remove();
                continue;
            }
            Identity identity = this.identities.getIdentity(((SharedFileObject)serializable).getOwner());
            if (identity == null || identity.getState() != 4 || n2 == 0) continue;
            iterator.remove();
        }
        if (this.request.indexOf("*-") != -1) {
            serializable = new Vector();
            n = this.request.indexOf("*-");
            int n5 = this.request.indexOf(" ", n);
            if (n5 == -1) {
                n5 = this.request.length();
            }
            if (((String)(object = this.request.substring(n + 2, n5))).indexOf(";") == -1) {
                ((Vector)serializable).add(object);
            } else {
                while (((String)object).indexOf(";") != -1) {
                    ((Vector)serializable).add(((String)object).substring(0, ((String)object).indexOf(";")));
                    if (((String)object).endsWith(";")) continue;
                    object = ((String)object).substring(((String)object).indexOf(";") + 1, ((String)object).length());
                }
                if (((String)object).length() > 0) {
                    ((Vector)serializable).add(object);
                }
            }
            for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                object = (String)((Vector)serializable).elementAt(i);
                for (int j = this.results.size() - 1; j >= 0; --j) {
                    SharedFileObject sharedFileObject = (SharedFileObject)this.results.elementAt(j);
                    if (sharedFileObject.getFilename().toLowerCase().indexOf(((String)object).toLowerCase()) == -1) continue;
                    this.results.removeElementAt(j);
                }
            }
        }
    }

    private boolean filterBySearchItemState(int n) {
        return true;
    }

    private void displaySearchResults(Board board) {
        for (int i = 0; i < this.results.size(); ++i) {
            ++this.allFileCount;
            if (this.allFileCount > this.maxSearchResults) {
                logger.info("NOTE: maxSearchResults reached (" + this.maxSearchResults + ")!");
                return;
            }
            SharedFileObject sharedFileObject = (SharedFileObject)this.results.elementAt(i);
            String string = sharedFileObject.getFilename();
            Long l = sharedFileObject.getSize();
            String string2 = sharedFileObject.getDate();
            String string3 = sharedFileObject.getKey();
            String string4 = sharedFileObject.getSHA1();
            if (string4 == null) {
                logger.warning("SHA1 null in SearchThread!!! ");
            }
            int n = 1;
            File file = new File(this.settings.getValue("downloadDirectory") + string);
            if (file.exists()) {
                n = 2;
            } else if (this.downloadModel.containsItemWithKey(string4)) {
                n = 3;
            } else if (this.uploadModel.containsItemWithKey(string4)) {
                n = 4;
            } else if (this.isOffline(sharedFileObject)) {
                n = 5;
            }
            if (!this.filterBySearchItemState(n)) continue;
            FrostSearchItem frostSearchItem = new FrostSearchItem(board, sharedFileObject, n);
            this.model.addSearchItem(frostSearchItem);
        }
    }

    private boolean isOffline(SharedFileObject sharedFileObject) {
        return !sharedFileObject.isOnline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        logger.info("Search for '" + this.request + "' on " + this.boards.size() + " boards started.");
        if (!this.request.equals("")) {
            int n = this.boards.size();
            this.allFileCount = 0;
            for (int i = 0; i < n; ++i) {
                File file;
                Board board = (Board)this.boards.elementAt(i);
                String string = board.getBoardFilename();
                logger.fine("Search for '" + this.request + "' on " + string + " started.");
                File file2 = new File(this.keypool + string);
                if (file2.isDirectory() && (file = new File(file2 + fileSeparator + "files.xml")).exists()) {
                    Index index;
                    this.chk.clear();
                    Index index2 = index = Index.getInstance();
                    synchronized (index2) {
                        this.chk = index.readKeyFile(file).getFilesMap();
                    }
                    this.getSearchResults();
                    logger.fine(file.getName() + " - " + this.chk.size() + ";");
                }
                this.chk.clear();
                this.filterSearchResults();
                this.displaySearchResults(board);
                this.results.clear();
            }
        }
        this.searchPanel.setSearchEnabled(true);
    }

    public SearchThread(String string, Vector vector, String string2, SearchManager searchManager) {
        this.identities = searchManager.getIdentities();
        this.settings = searchManager.getSettings();
        this.request = string.toLowerCase();
        if (this.request.length() == 0) {
            this.request = "*";
        }
        this.model = searchManager.getModel();
        this.keypool = searchManager.getKeypool();
        this.searchType = string2;
        this.audioExtension = this.settings.getArrayValue("audioExtension");
        this.videoExtension = this.settings.getArrayValue("videoExtension");
        this.documentExtension = this.settings.getArrayValue("documentExtension");
        this.executableExtension = this.settings.getArrayValue("executableExtension");
        this.archiveExtension = this.settings.getArrayValue("archiveExtension");
        this.imageExtension = this.settings.getArrayValue("imageExtension");
        this.boards = vector;
        this.maxSearchResults = this.settings.getIntValue("maxSearchResults");
        if (this.maxSearchResults <= 0) {
            this.maxSearchResults = 10000;
        }
        this.searchPanel = searchManager.getPanel();
    }

    public void setUploadModel(UploadModel uploadModel) {
        this.uploadModel = uploadModel;
    }

    public void setDownloadModel(DownloadModel downloadModel) {
        this.downloadModel = downloadModel;
    }
}

