/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.search;

import frost.fileTransfer.search.FrostSearchItem;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import frost.util.model.ModelItem;
import frost.util.model.gui.ModelTable;
import frost.util.model.gui.SortedModelTable;
import frost.util.model.gui.SortedTableFormat;
import java.awt.Color;
import java.awt.Component;
import java.util.Comparator;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;

public class SearchTableFormat
extends SortedTableFormat
implements LanguageListener {
    private Language language = Language.getInstance();
    private static final int COLUMN_COUNT = 5;
    private String anonymous;
    private String offline;
    private String uploading;
    private String downloading;
    private String downloaded;

    public SearchTableFormat() {
        super(5);
        this.language.addLanguageListener(this);
        this.refreshLanguage();
        this.setComparator(new FileNameComparator(), 0);
        this.setComparator(new SizeComparator(), 1);
        this.setComparator(new AgeComparator(), 2);
        this.setComparator(new FromComparator(), 3);
        this.setComparator(new BoardComparator(), 4);
    }

    public void languageChanged(LanguageEvent languageEvent) {
        this.refreshLanguage();
    }

    private void refreshLanguage() {
        this.setColumnName(0, this.language.getString("Filename"));
        this.setColumnName(1, this.language.getString("Size"));
        this.setColumnName(2, this.language.getString("Age"));
        this.setColumnName(3, this.language.getString("From"));
        this.setColumnName(4, this.language.getString("Board"));
        this.anonymous = this.language.getString("FrostSearchItemObject.Anonymous");
        this.offline = this.language.getString("FrostSearchItemObject.Offline");
        this.uploading = this.language.getString("SearchTableFormat.Uploading");
        this.downloading = this.language.getString("SearchTableFormat.Downloading");
        this.downloaded = this.language.getString("SearchTableFormat.Downloaded");
        this.refreshColumnNames();
    }

    public Object getCellValue(ModelItem modelItem, int n) {
        FrostSearchItem frostSearchItem = (FrostSearchItem)modelItem;
        switch (n) {
            case 0: {
                return frostSearchItem.getFilename();
            }
            case 1: {
                return frostSearchItem.getSize();
            }
            case 2: {
                return this.getAgeString(frostSearchItem.getDate(), frostSearchItem.getState());
            }
            case 3: {
                if (frostSearchItem.getOwner() == null || frostSearchItem.getOwner().length() == 0) {
                    return this.anonymous;
                }
                return frostSearchItem.getOwner();
            }
            case 4: {
                return frostSearchItem.getBoard().getName();
            }
        }
        return "**ERROR**";
    }

    private String getAgeString(String string, int n) {
        String string2 = null;
        switch (n) {
            case 5: {
                string2 = this.offline;
                break;
            }
            case 4: {
                string2 = this.uploading;
                break;
            }
            case 3: {
                string2 = this.downloading;
                break;
            }
            case 2: {
                string2 = this.downloaded;
            }
        }
        if (string == null || string.length() == 0) {
            if (n == 1) {
                return "**ERROR**";
            }
            return string2;
        }
        if (n == 1) {
            return string;
        }
        return string2 + " (" + string + ")";
    }

    public int[] getColumnNumbers(int n) {
        return new int[0];
    }

    public void customizeTable(ModelTable modelTable) {
        super.customizeTable(modelTable);
        TableColumnModel tableColumnModel = modelTable.getTable().getColumnModel();
        int[] nArray = new int[]{250, 80, 80, 80, 80};
        for (int i = 0; i < nArray.length; ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth(nArray[i]);
        }
        FileNameRenderer fileNameRenderer = new FileNameRenderer((SortedModelTable)modelTable);
        tableColumnModel.getColumn(0).setCellRenderer(fileNameRenderer);
        tableColumnModel.getColumn(1).setCellRenderer(new SizeRenderer());
    }

    private class FileNameRenderer
    extends DefaultTableCellRenderer {
        private SortedModelTable modelTable;

        public FileNameRenderer(SortedModelTable sortedModelTable) {
            this.modelTable = sortedModelTable;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!bl) {
                ModelItem modelItem = this.modelTable.getItemAt(n);
                if (modelItem != null) {
                    FrostSearchItem frostSearchItem = (FrostSearchItem)modelItem;
                    if (frostSearchItem.getState() == 2) {
                        this.setForeground(Color.LIGHT_GRAY);
                    } else if (frostSearchItem.getState() == 3) {
                        this.setForeground(Color.BLUE);
                    } else if (frostSearchItem.getState() == 4) {
                        this.setForeground(Color.MAGENTA);
                    } else if (frostSearchItem.getState() == 5) {
                        this.setForeground(Color.DARK_GRAY);
                    } else {
                        this.setForeground(Color.BLACK);
                    }
                } else {
                    return this;
                }
            }
            return this;
        }
    }

    private class SizeRenderer
    extends DefaultTableCellRenderer {
        private SizeRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setHorizontalAlignment(4);
            this.setBorder(new EmptyBorder(0, 0, 0, 3));
            return this;
        }
    }

    private class FromComparator
    implements Comparator {
        private FromComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = ((FrostSearchItem)object).getOwner();
            String string2 = ((FrostSearchItem)object2).getOwner();
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            return string.compareToIgnoreCase(string2);
        }
    }

    private class BoardComparator
    implements Comparator {
        private BoardComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = ((FrostSearchItem)object).getBoard().getName();
            String string2 = ((FrostSearchItem)object2).getBoard().getName();
            return string.compareToIgnoreCase(string2);
        }
    }

    private class FileNameComparator
    implements Comparator {
        private FileNameComparator() {
        }

        public int compare(Object object, Object object2) {
            FrostSearchItem frostSearchItem = (FrostSearchItem)object;
            FrostSearchItem frostSearchItem2 = (FrostSearchItem)object2;
            return frostSearchItem.getFilename().compareToIgnoreCase(frostSearchItem2.getFilename());
        }
    }

    private class SizeComparator
    implements Comparator {
        private SizeComparator() {
        }

        public int compare(Object object, Object object2) {
            FrostSearchItem frostSearchItem = (FrostSearchItem)object;
            FrostSearchItem frostSearchItem2 = (FrostSearchItem)object2;
            return frostSearchItem.getSize().compareTo(frostSearchItem2.getSize());
        }
    }

    private class AgeComparator
    implements Comparator {
        private AgeComparator() {
        }

        public int compare(Object object, Object object2) {
            FrostSearchItem frostSearchItem = (FrostSearchItem)object;
            FrostSearchItem frostSearchItem2 = (FrostSearchItem)object2;
            String string = SearchTableFormat.this.getAgeString(frostSearchItem.getDate(), frostSearchItem.getState());
            String string2 = SearchTableFormat.this.getAgeString(frostSearchItem2.getDate(), frostSearchItem2.getState());
            return string.compareToIgnoreCase(string2);
        }
    }
}

