/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.search;

import frost.SettingsClass;
import frost.SettingsUpdater;
import frost.boards.TofTreeModel;
import frost.fileTransfer.download.DownloadModel;
import frost.fileTransfer.search.FrostSearchItem;
import frost.fileTransfer.search.SearchManager;
import frost.fileTransfer.search.SearchModel;
import frost.fileTransfer.search.SearchTableFormat;
import frost.fileTransfer.search.SearchThread;
import frost.fileTransfer.upload.UploadModel;
import frost.gui.objects.Board;
import frost.identities.FrostIdentities;
import frost.identities.Identity;
import frost.util.gui.JSkinnablePopupMenu;
import frost.util.gui.MiscToolkit;
import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.JTranslatableComboBox;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import frost.util.model.ModelItem;
import frost.util.model.ModelListener;
import frost.util.model.OrderedModel;
import frost.util.model.gui.SortedModelTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class SearchPanel
extends JPanel
implements SettingsUpdater {
    private SearchManager searchManager;
    private FrostIdentities identities;
    private static Logger logger = Logger.getLogger(SearchPanel.class.getName());
    private PopupMenuSearch popupMenuSearch = null;
    private Listener listener = new Listener();
    private SearchModel model = null;
    private DownloadModel downloadModel = null;
    private UploadModel uploadModel = null;
    private TofTreeModel tofTreeModel = null;
    private SettingsClass settingsClass = null;
    private String keypool = null;
    private Language language = null;
    private JPanel searchTopPanel = new JPanel();
    private JCheckBox searchAllBoardsCheckBox = new JCheckBox("", true);
    private JTranslatableComboBox searchComboBox = null;
    private JButton searchButton = new JButton(new ImageIcon(this.getClass().getResource("/data/search.gif")));
    private JButton downloadButton = new JButton(new ImageIcon(this.getClass().getResource("/data/save.gif")));
    private JLabel searchResultsCountLabel = new JLabel();
    private JTextField searchTextField = new JTextField(25);
    private SortedModelTable modelTable;
    private boolean initialized = false;
    private boolean allBoardsSelected = true;
    private long searchResultsCount = 0L;

    private void downloadButton_actionPerformed(ActionEvent actionEvent) {
        ModelItem[] modelItemArray = this.modelTable.getSelectedItems();
        this.model.addItemsToDownloadModel(modelItemArray);
    }

    public SearchPanel(SettingsClass settingsClass, SearchManager searchManager) {
        this.settingsClass = settingsClass;
        settingsClass.addUpdater(this);
        this.searchManager = searchManager;
        this.language = Language.getInstance();
        this.language.addLanguageListener(this.listener);
        this.setAllBoardsSelected(settingsClass.getBoolValue("searchAllBoards"));
    }

    public void initialize() {
        if (!this.initialized) {
            this.refreshLanguage();
            this.searchAllBoardsCheckBox.setEnabled(true);
            new TextComponentClipboardMenu(this.searchTextField, this.language);
            String[] stringArray = new String[]{"All files", "Audio", "Video", "Images", "Documents", "Executables", "Archives"};
            this.searchComboBox = new JTranslatableComboBox(this.language, stringArray);
            MiscToolkit miscToolkit = MiscToolkit.getInstance();
            miscToolkit.configureButton(this.searchButton, "/data/search_rollover.gif");
            miscToolkit.configureButton(this.downloadButton, "/data/save_rollover.gif");
            this.downloadButton.setEnabled(false);
            this.searchComboBox.setMaximumSize(this.searchComboBox.getPreferredSize());
            this.searchTextField.setMaximumSize(this.searchTextField.getPreferredSize());
            BoxLayout boxLayout = new BoxLayout(this.searchTopPanel, 0);
            Dimension dimension = new Dimension(8, 0);
            this.searchTopPanel.setLayout(boxLayout);
            this.searchTopPanel.add(this.searchTextField);
            this.searchTopPanel.add(Box.createRigidArea(dimension));
            this.searchTopPanel.add(this.searchComboBox);
            this.searchTopPanel.add(Box.createRigidArea(dimension));
            this.searchTopPanel.add(this.searchButton);
            this.searchTopPanel.add(Box.createRigidArea(dimension));
            this.searchTopPanel.add(this.downloadButton);
            this.searchTopPanel.add(Box.createRigidArea(dimension));
            this.searchTopPanel.add(this.searchAllBoardsCheckBox);
            this.searchTopPanel.add(Box.createRigidArea(new Dimension(80, 0)));
            this.searchTopPanel.add(Box.createHorizontalGlue());
            this.searchTopPanel.add(this.searchResultsCountLabel);
            SearchTableFormat searchTableFormat = new SearchTableFormat();
            this.modelTable = new SortedModelTable((OrderedModel)this.model, searchTableFormat);
            this.setLayout(new BorderLayout());
            this.add((Component)this.searchTopPanel, "North");
            this.add((Component)this.modelTable.getScrollPane(), "Center");
            this.fontChanged();
            this.searchTextField.addActionListener(this.listener);
            this.downloadButton.addActionListener(this.listener);
            this.searchButton.addActionListener(this.listener);
            this.modelTable.getScrollPane().addMouseListener(this.listener);
            this.modelTable.getTable().addMouseListener(this.listener);
            this.settingsClass.addPropertyChangeListener("fileListFontName", this.listener);
            this.settingsClass.addPropertyChangeListener("fileListFontSize", this.listener);
            this.settingsClass.addPropertyChangeListener("fileListFontStyle", this.listener);
            this.modelTable.getTable().getSelectionModel().addListSelectionListener(this.listener);
            this.model.addModelListener(this.listener);
            this.initialized = true;
        }
    }

    private void refreshLanguage() {
        this.searchAllBoardsCheckBox.setText(this.language.getString("all boards"));
        this.searchButton.setToolTipText(this.language.getString("Search"));
        this.downloadButton.setToolTipText(this.language.getString("Download selected keys"));
        String string = this.language.getString("Results");
        Dimension dimension = this.calculateLabelSize(string + " : 00000");
        this.searchResultsCountLabel.setPreferredSize(dimension);
        this.searchResultsCountLabel.setMinimumSize(dimension);
        this.searchResultsCountLabel.setText(string + " : " + this.searchResultsCount);
    }

    private Dimension calculateLabelSize(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.doLayout();
        return jLabel.getPreferredSize();
    }

    private void searchButton_actionPerformed(ActionEvent actionEvent) {
        Object object;
        Vector<Board> vector;
        this.searchButton.setEnabled(false);
        this.model.clear();
        if (this.searchAllBoardsCheckBox.isSelected()) {
            vector = this.tofTreeModel.getAllBoards();
        } else if (!this.tofTreeModel.getSelectedNode().isFolder()) {
            vector = new Vector<Board>();
            vector.add(this.tofTreeModel.getSelectedNode());
        } else {
            object = this.tofTreeModel.getSelectedNode().depthFirstEnumeration();
            vector = new Vector();
            while (object.hasMoreElements()) {
                Board board = (Board)object.nextElement();
                if (board.isFolder()) continue;
                vector.add(board);
            }
        }
        object = new SearchThread(this.searchTextField.getText(), vector, this.searchComboBox.getSelectedKey(), this.searchManager);
        ((SearchThread)object).setDownloadModel(this.downloadModel);
        ((SearchThread)object).setUploadModel(this.uploadModel);
        ((Thread)object).start();
    }

    private void searchTextField_actionPerformed(ActionEvent actionEvent) {
        if (this.searchButton.isEnabled()) {
            this.searchButton_actionPerformed(actionEvent);
        }
    }

    private void showSearchTablePopupMenu(MouseEvent mouseEvent) {
        this.getPopupMenuSearch().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private void updateSearchResultCountLabel() {
        this.searchResultsCount = this.model.getItemCount();
        String string = this.language.getString("Results");
        if (this.searchResultsCount == 0L) {
            this.searchResultsCountLabel.setText(string + " : 0");
        }
        this.searchResultsCountLabel.setText(string + " : " + this.searchResultsCount);
    }

    private void fontChanged() {
        int n;
        int n2;
        String string = this.settingsClass.getValue("fileListFontName");
        Font font = new Font(string, n2 = this.settingsClass.getIntValue("fileListFontStyle"), n = this.settingsClass.getIntValue("fileListFontSize"));
        if (!font.getFamily().equals(string)) {
            logger.severe("The selected font was not found in your system\nThat selection will be changed to \"SansSerif\".");
            this.settingsClass.setValue("fileListFontName", "SansSerif");
            font = new Font("SansSerif", n2, n);
        }
        this.modelTable.setFont(font);
    }

    private void searchTableDoubleClick(MouseEvent mouseEvent) {
        ModelItem[] modelItemArray = this.modelTable.getSelectedItems();
        this.model.addItemsToDownloadModel(modelItemArray);
    }

    public void setAllBoardsSelected(boolean bl) {
        this.allBoardsSelected = bl;
        this.searchAllBoardsCheckBox.setSelected(this.allBoardsSelected);
    }

    public void setSearchEnabled(boolean bl) {
        this.searchButton.setEnabled(bl);
    }

    public void setDownloadModel(DownloadModel downloadModel) {
        this.downloadModel = downloadModel;
    }

    public void setModel(SearchModel searchModel) {
        this.model = searchModel;
    }

    public void setTofTreeModel(TofTreeModel tofTreeModel) {
        this.tofTreeModel = tofTreeModel;
    }

    public void setKeypool(String string) {
        this.keypool = string;
    }

    private PopupMenuSearch getPopupMenuSearch() {
        if (this.popupMenuSearch == null) {
            this.popupMenuSearch = new PopupMenuSearch();
            this.language.addLanguageListener(this.popupMenuSearch);
        }
        return this.popupMenuSearch;
    }

    public void setIdentities(FrostIdentities frostIdentities) {
        this.identities = frostIdentities;
    }

    public void updateSettings() {
        this.settingsClass.setValue("searchAllBoards", this.allBoardsSelected);
    }

    private void listSelectionChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (this.modelTable.getSelectedCount() > 0) {
                this.downloadButton.setEnabled(true);
            } else {
                this.downloadButton.setEnabled(false);
            }
        }
    }

    public void setUploadModel(UploadModel uploadModel) {
        this.uploadModel = uploadModel;
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    MouseListener,
    LanguageListener,
    PropertyChangeListener,
    ListSelectionListener,
    ModelListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == SearchPanel.this.searchTextField) {
                SearchPanel.this.searchTextField_actionPerformed(actionEvent);
            }
            if (actionEvent.getSource() == SearchPanel.this.downloadButton) {
                SearchPanel.this.downloadButton_actionPerformed(actionEvent);
            }
            if (actionEvent.getSource() == SearchPanel.this.searchButton) {
                SearchPanel.this.searchButton_actionPerformed(actionEvent);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                if (mouseEvent.getSource() == SearchPanel.this.modelTable.getTable()) {
                    SearchPanel.this.searchTableDoubleClick(mouseEvent);
                }
            } else if (mouseEvent.isPopupTrigger() && (mouseEvent.getSource() == SearchPanel.this.modelTable.getTable() || mouseEvent.getSource() == SearchPanel.this.modelTable.getScrollPane())) {
                SearchPanel.this.showSearchTablePopupMenu(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 1 && mouseEvent.isPopupTrigger() && (mouseEvent.getSource() == SearchPanel.this.modelTable.getTable() || mouseEvent.getSource() == SearchPanel.this.modelTable.getScrollPane())) {
                SearchPanel.this.showSearchTablePopupMenu(mouseEvent);
            }
        }

        public void languageChanged(LanguageEvent languageEvent) {
            SearchPanel.this.refreshLanguage();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("fileListFontName")) {
                SearchPanel.this.fontChanged();
            }
            if (propertyChangeEvent.getPropertyName().equals("fileListFontSize")) {
                SearchPanel.this.fontChanged();
            }
            if (propertyChangeEvent.getPropertyName().equals("fileListFontStyle")) {
                SearchPanel.this.fontChanged();
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            SearchPanel.this.listSelectionChanged(listSelectionEvent);
        }

        public void itemChanged(ModelItem modelItem, int n, Object object, Object object2) {
        }

        public void itemChanged(ModelItem modelItem) {
        }

        public void itemAdded(ModelItem modelItem) {
            SearchPanel.this.updateSearchResultCountLabel();
        }

        public void modelCleared() {
            SearchPanel.this.updateSearchResultCountLabel();
        }

        public void itemsRemoved(ModelItem[] modelItemArray) {
            SearchPanel.this.updateSearchResultCountLabel();
        }
    }

    private class PopupMenuSearch
    extends JSkinnablePopupMenu
    implements ActionListener,
    LanguageListener,
    ClipboardOwner {
        JMenuItem cancelItem = new JMenuItem();
        JMenuItem downloadAllKeysItem = new JMenuItem();
        JMenuItem downloadSelectedKeysItem = new JMenuItem();
        JMenuItem setBadItem = new JMenuItem();
        JMenuItem setGoodItem = new JMenuItem();
        private JMenu copyToClipboardMenu = new JMenu();
        private JMenuItem copyKeysAndNamesItem = new JMenuItem();
        private JMenuItem copyKeysItem = new JMenuItem();
        private JMenuItem copyExtendedInfoItem = new JMenuItem();
        private String keyNotAvailableMessage;
        private String fileMessage;
        private String keyMessage;
        private String bytesMessage;
        private Clipboard clipboard;

        public PopupMenuSearch() {
            this.initialize();
        }

        private void initialize() {
            this.refreshLanguage();
            this.copyToClipboardMenu.add(this.copyKeysAndNamesItem);
            this.copyToClipboardMenu.add(this.copyKeysItem);
            this.copyToClipboardMenu.add(this.copyExtendedInfoItem);
            this.downloadSelectedKeysItem.addActionListener(this);
            this.downloadAllKeysItem.addActionListener(this);
            this.setGoodItem.addActionListener(this);
            this.setBadItem.addActionListener(this);
            this.copyKeysAndNamesItem.addActionListener(this);
            this.copyKeysItem.addActionListener(this);
            this.copyExtendedInfoItem.addActionListener(this);
        }

        private void refreshLanguage() {
            this.downloadSelectedKeysItem.setText(SearchPanel.this.language.getString("Download selected keys"));
            this.downloadAllKeysItem.setText(SearchPanel.this.language.getString("Download all keys"));
            this.setGoodItem.setText(SearchPanel.this.language.getString("help user (sets to GOOD)"));
            this.setBadItem.setText(SearchPanel.this.language.getString("block user (sets to BAD)"));
            this.cancelItem.setText(SearchPanel.this.language.getString("Cancel"));
            this.keyNotAvailableMessage = SearchPanel.this.language.getString("Key not available yet");
            this.fileMessage = SearchPanel.this.language.getString("clipboard.File:");
            this.keyMessage = SearchPanel.this.language.getString("clipboard.Key:");
            this.bytesMessage = SearchPanel.this.language.getString("clipboard.Bytes:");
            this.copyKeysItem.setText(SearchPanel.this.language.getString("Copy keys only"));
            this.copyKeysAndNamesItem.setText(SearchPanel.this.language.getString("Copy keys with filenames"));
            this.copyExtendedInfoItem.setText(SearchPanel.this.language.getString("Copy extended info"));
            this.copyToClipboardMenu.setText(SearchPanel.this.language.getString("Copy to clipboard") + "...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.downloadSelectedKeysItem) {
                this.downloadSelectedKeys();
            }
            if (actionEvent.getSource() == this.downloadAllKeysItem) {
                this.downloadAllKeys();
            }
            if (actionEvent.getSource() == this.setGoodItem) {
                this.setGood();
            }
            if (actionEvent.getSource() == this.setBadItem) {
                this.setBad();
            }
            if (actionEvent.getSource() == this.copyKeysItem) {
                this.copyKeys();
            }
            if (actionEvent.getSource() == this.copyKeysAndNamesItem) {
                this.copyKeysAndNames();
            }
            if (actionEvent.getSource() == this.copyExtendedInfoItem) {
                this.copyExtendedInfo();
            }
        }

        private void copyKeysAndNames() {
            ModelItem[] modelItemArray = SearchPanel.this.modelTable.getSelectedItems();
            if (modelItemArray.length > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < modelItemArray.length; ++i) {
                    FrostSearchItem frostSearchItem = (FrostSearchItem)modelItemArray[i];
                    String string = frostSearchItem.getKey();
                    if (string == null) {
                        string = this.keyNotAvailableMessage;
                    }
                    stringBuffer.append(string);
                    stringBuffer.append("/");
                    stringBuffer.append(frostSearchItem.getFilename());
                    stringBuffer.append("\n");
                }
                StringSelection stringSelection = new StringSelection(stringBuffer.toString());
                this.getClipboard().setContents(stringSelection, this);
            }
        }

        private Clipboard getClipboard() {
            if (this.clipboard == null) {
                this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            return this.clipboard;
        }

        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }

        private void copyExtendedInfo() {
            ModelItem[] modelItemArray = SearchPanel.this.modelTable.getSelectedItems();
            if (modelItemArray.length > 0) {
                Object object;
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < modelItemArray.length; ++i) {
                    object = (FrostSearchItem)modelItemArray[i];
                    String string = ((FrostSearchItem)object).getKey();
                    if (string == null) {
                        string = this.keyNotAvailableMessage;
                    }
                    stringBuffer.append(this.fileMessage);
                    stringBuffer.append(((FrostSearchItem)object).getFilename() + "\n");
                    stringBuffer.append(this.keyMessage);
                    stringBuffer.append(string + "\n");
                    stringBuffer.append(this.bytesMessage);
                    stringBuffer.append(((FrostSearchItem)object).getSize() + "\n\n");
                }
                String string = stringBuffer.substring(0, stringBuffer.length() - 1);
                object = new StringSelection(string);
                this.getClipboard().setContents((Transferable)object, this);
            }
        }

        private void copyKeys() {
            ModelItem[] modelItemArray = SearchPanel.this.modelTable.getSelectedItems();
            if (modelItemArray.length > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < modelItemArray.length; ++i) {
                    FrostSearchItem frostSearchItem = (FrostSearchItem)modelItemArray[i];
                    String string = frostSearchItem.getKey();
                    if (string == null) {
                        string = this.keyNotAvailableMessage;
                    }
                    stringBuffer.append(string);
                    stringBuffer.append("\n");
                }
                StringSelection stringSelection = new StringSelection(stringBuffer.toString());
                this.getClipboard().setContents(stringSelection, this);
            }
        }

        private void setBad() {
            ModelItem[] modelItemArray = SearchPanel.this.modelTable.getSelectedItems();
            Iterator iterator = SearchPanel.this.model.getSelectedItemsOwners(modelItemArray);
            while (iterator.hasNext()) {
                Identity identity = (Identity)iterator.next();
                SearchPanel.this.identities.changeTrust(identity.getUniqueName(), 4);
            }
        }

        private void setGood() {
            ModelItem[] modelItemArray = SearchPanel.this.modelTable.getSelectedItems();
            Iterator iterator = SearchPanel.this.model.getSelectedItemsOwners(modelItemArray);
            while (iterator.hasNext()) {
                Identity identity = (Identity)iterator.next();
                SearchPanel.this.identities.changeTrust(identity.getUniqueName(), 1);
            }
        }

        private void downloadAllKeys() {
            SearchPanel.this.model.addAllItemsToDownloadModel();
        }

        private void downloadSelectedKeys() {
            ModelItem[] modelItemArray = SearchPanel.this.modelTable.getSelectedItems();
            SearchPanel.this.model.addItemsToDownloadModel(modelItemArray);
        }

        public void languageChanged(LanguageEvent languageEvent) {
            this.refreshLanguage();
        }

        public void show(Component component, int n, int n2) {
            this.removeAll();
            ModelItem[] modelItemArray = SearchPanel.this.modelTable.getSelectedItems();
            if (modelItemArray.length > 0) {
                this.add(this.copyToClipboardMenu);
                this.addSeparator();
            }
            if (modelItemArray.length != 0) {
                this.add(this.downloadSelectedKeysItem);
                this.addSeparator();
            }
            this.add(this.downloadAllKeysItem);
            this.addSeparator();
            if (modelItemArray.length != 0) {
                this.add(this.setGoodItem);
                this.add(this.setBadItem);
                this.addSeparator();
            }
            this.add(this.cancelItem);
            super.show(component, n, n2);
        }
    }
}

