/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.search;

import frost.SettingsClass;
import frost.fileTransfer.download.DownloadModel;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.fileTransfer.search.FrostSearchItem;
import frost.identities.FrostIdentities;
import frost.identities.Identity;
import frost.util.model.ModelItem;
import frost.util.model.OrderedModel;
import java.util.Iterator;
import java.util.LinkedList;

public class SearchModel
extends OrderedModel {
    private FrostIdentities identities;
    private DownloadModel downloadModel;
    private SettingsClass settings;

    public SearchModel(SettingsClass settingsClass) {
        this.settings = settingsClass;
    }

    public void addSearchItem(FrostSearchItem frostSearchItem) {
        this.addItem(frostSearchItem);
    }

    public void setDownloadModel(DownloadModel downloadModel) {
        this.downloadModel = downloadModel;
    }

    public void addItemsToDownloadModel(ModelItem[] modelItemArray) {
        for (int i = 0; i < modelItemArray.length; ++i) {
            FrostSearchItem frostSearchItem = (FrostSearchItem)modelItemArray[i];
            FrostDownloadItem frostDownloadItem = new FrostDownloadItem(frostSearchItem);
            this.downloadModel.addDownloadItem(frostDownloadItem);
        }
    }

    public synchronized void addAllItemsToDownloadModel() {
        for (FrostSearchItem frostSearchItem : this.data) {
            FrostDownloadItem frostDownloadItem = new FrostDownloadItem(frostSearchItem);
            this.downloadModel.addDownloadItem(frostDownloadItem);
        }
    }

    public Iterator getSelectedItemsOwners(ModelItem[] modelItemArray) {
        LinkedList<Identity> linkedList = new LinkedList<Identity>();
        for (int i = 0; i < modelItemArray.length; ++i) {
            Identity identity;
            FrostSearchItem frostSearchItem = (FrostSearchItem)modelItemArray[i];
            String string = frostSearchItem.getOwner();
            if (string == null || string.compareTo(this.identities.getMyId().getUniqueName()) == 0 || (identity = this.identities.getIdentity(string)) == null) continue;
            linkedList.add(identity);
        }
        return linkedList.iterator();
    }

    public void setIdentities(FrostIdentities frostIdentities) {
        this.identities = frostIdentities;
    }
}

