/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.search;

import frost.MainFrame;
import frost.SettingsClass;
import frost.boards.TofTreeModel;
import frost.fileTransfer.download.DownloadModel;
import frost.fileTransfer.search.SearchModel;
import frost.fileTransfer.search.SearchPanel;
import frost.fileTransfer.upload.UploadModel;
import frost.identities.FrostIdentities;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class SearchManager
implements PropertyChangeListener {
    private TofTreeModel tofTreeModel;
    private DownloadModel downloadModel;
    private UploadModel uploadModel;
    private String keypool;
    private FrostIdentities identities;
    private MainFrame mainFrame;
    private SettingsClass settings;
    private SearchModel model;
    private SearchPanel panel;

    public SearchManager(SettingsClass settingsClass) {
        this.settings = settingsClass;
    }

    public void initialize() {
        this.mainFrame.addPanel("Search", this.getPanel());
        this.settings.addPropertyChangeListener("disableDownloads", this);
        this.updateDownloadStatus();
    }

    public void setMainFrame(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public void setIdentities(FrostIdentities frostIdentities) {
        this.identities = frostIdentities;
    }

    public void setKeypool(String string) {
        this.keypool = string;
    }

    public void setDownloadModel(DownloadModel downloadModel) {
        this.downloadModel = downloadModel;
    }

    public void setTofTreeModel(TofTreeModel tofTreeModel) {
        this.tofTreeModel = tofTreeModel;
    }

    public SearchPanel getPanel() {
        if (this.panel == null) {
            this.panel = new SearchPanel(this.settings, this);
            this.panel.setModel(this.getModel());
            this.panel.setDownloadModel(this.downloadModel);
            this.panel.setUploadModel(this.uploadModel);
            this.panel.setTofTreeModel(this.tofTreeModel);
            this.panel.setKeypool(this.keypool);
            this.panel.setIdentities(this.identities);
            this.panel.initialize();
        }
        return this.panel;
    }

    public SearchModel getModel() {
        if (this.model == null) {
            this.model = new SearchModel(this.settings);
            this.model.setDownloadModel(this.downloadModel);
            this.model.setIdentities(this.identities);
        }
        return this.model;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("disableDownloads")) {
            this.updateDownloadStatus();
        }
    }

    private void updateDownloadStatus() {
        boolean bl = this.settings.getBoolValue("disableDownloads");
        this.mainFrame.setPanelEnabled("Search", !bl);
    }

    public FrostIdentities getIdentities() {
        return this.identities;
    }

    public String getKeypool() {
        return this.keypool;
    }

    public SettingsClass getSettings() {
        return this.settings;
    }

    public void setUploadModel(UploadModel uploadModel) {
        this.uploadModel = uploadModel;
    }
}

