/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.download;

import frost.fileTransfer.search.FrostSearchItem;
import frost.gui.objects.Board;
import frost.util.model.ModelItem;

public class FrostDownloadItem
extends ModelItem {
    public static final int FIELD_ID_DONE_BLOCKS = 100;
    public static final int FIELD_ID_ENABLED = 101;
    public static final int FIELD_ID_FILE_AGE = 102;
    public static final int FIELD_ID_FILE_NAME = 103;
    public static final int FIELD_ID_FILE_SIZE = 104;
    public static final int FIELD_ID_KEY = 105;
    public static final int FIELD_ID_OWNER = 106;
    public static final int FIELD_ID_REQUIRED_BLOCKS = 107;
    public static final int FIELD_ID_RETRIES = 108;
    public static final int FIELD_ID_SHA1 = 109;
    public static final int FIELD_ID_STATE = 110;
    public static final int FIELD_ID_SOURCE_BOARD = 111;
    public static final int FIELD_ID_TOTAL_BLOCKS = 112;
    public static final int STATE_WAITING = 1;
    public static final int STATE_TRYING = 2;
    public static final int STATE_DONE = 3;
    public static final int STATE_FAILED = 4;
    public static final int STATE_REQUESTING = 5;
    public static final int STATE_PROGRESS = 6;
    public static final int STATE_REQUESTED = 7;
    public static final int STATE_DECODING = 8;
    private String fileName = null;
    private Long fileSize = null;
    private String fileAge = null;
    private String key = null;
    private Board sourceBoard;
    private int retries;
    private Boolean enableDownload = new Boolean(true);
    private String owner = null;
    private String sha1 = null;
    private int state = 0;
    private int doneBlocks = 0;
    private int requiredBlocks = 0;
    private int totalBlocks = 0;
    private String batch = null;
    private String redirect;
    private long lastDownloadStopTimeMillis = 0L;

    public FrostDownloadItem(FrostSearchItem frostSearchItem) {
        this.fileName = frostSearchItem.getFilename();
        this.fileSize = frostSearchItem.getSize();
        this.fileAge = frostSearchItem.getDate();
        this.key = frostSearchItem.getKey();
        this.owner = frostSearchItem.getOwner();
        this.sourceBoard = frostSearchItem.getBoard();
        this.sha1 = frostSearchItem.getSHA1();
        this.batch = frostSearchItem.getBatch();
        this.retries = 0;
        this.state = 1;
        this.redirect = frostSearchItem.getRedirect();
    }

    public FrostDownloadItem(String string, String string2, Board board) {
        this.fileName = string;
        this.fileSize = null;
        this.fileAge = null;
        this.key = string2;
        this.sourceBoard = board;
        this.retries = 0;
        this.state = 1;
    }

    public FrostDownloadItem(String string, String string2, String string3, String string4, String string5, String string6, String string7, int n, boolean bl, Board board) {
        this.fileName = string;
        if (string2 != null) {
            this.fileSize = new Long(string2);
        }
        this.retries = string5 != null ? Integer.parseInt(string5) : 0;
        this.fileAge = string3;
        this.key = string4;
        this.sourceBoard = board;
        this.state = n;
        this.sha1 = string7;
        this.enableDownload = bl;
        this.owner = string6;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(Long l) {
        Long l2 = this.fileSize;
        this.fileSize = l;
        this.fireFieldChange(104, l2, l);
    }

    public String getFileAge() {
        return this.fileAge;
    }

    public void setFileAge(String string) {
        String string2 = this.fileAge;
        this.fileAge = string;
        this.fireFieldChange(102, string2, string);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        String string2 = this.key;
        this.key = string;
        this.fireFieldChange(105, string2, string);
    }

    public Board getSourceBoard() {
        return this.sourceBoard;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        int n2 = this.state;
        this.state = n;
        this.fireFieldChange(110, n2, n);
    }

    public long getLastDownloadStopTimeMillis() {
        return this.lastDownloadStopTimeMillis;
    }

    public void setLastDownloadStopTimeMillis(long l) {
        this.lastDownloadStopTimeMillis = l;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int n) {
        int n2 = this.retries;
        this.retries = n;
        this.fireFieldChange(108, n2, n);
    }

    public String getBatch() {
        return this.batch;
    }

    public void setBatch(String string) {
        this.batch = string;
    }

    public Boolean getEnableDownload() {
        return this.enableDownload;
    }

    public void setEnableDownload(Boolean bl) {
        if (bl == null && this.enableDownload != null) {
            boolean bl2 = this.enableDownload;
            bl = new Boolean(!bl2);
        }
        Boolean bl3 = this.enableDownload;
        this.enableDownload = bl;
        this.fireFieldChange(101, bl3, bl);
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String string) {
        String string2 = this.owner;
        this.owner = string;
        this.fireFieldChange(106, string2, string);
    }

    public String getSHA1() {
        return this.sha1;
    }

    public void setSHA1(String string) {
        String string2 = this.sha1;
        this.sha1 = string;
        this.fireFieldChange(109, string2, string);
    }

    public void setFileName(String string) {
        String string2 = this.fileName;
        this.fileName = string;
        this.fireFieldChange(103, string2, string);
    }

    public String getRedirect() {
        return this.redirect;
    }

    public void setRedirect(String string) {
        this.redirect = string;
    }

    public int getDoneBlocks() {
        return this.doneBlocks;
    }

    public int getRequiredBlocks() {
        return this.requiredBlocks;
    }

    public int getTotalBlocks() {
        return this.totalBlocks;
    }

    public void setDoneBlocks(int n) {
        int n2 = this.doneBlocks;
        this.doneBlocks = n;
        this.fireFieldChange(100, n2, n);
    }

    public void setRequiredBlocks(int n) {
        int n2 = this.requiredBlocks;
        this.requiredBlocks = n;
        this.fireFieldChange(107, n2, n);
    }

    public void setTotalBlocks(int n) {
        int n2 = this.totalBlocks;
        this.totalBlocks = n;
        this.fireFieldChange(112, n2, n);
    }
}

