/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.download;

import frost.Mixed;
import frost.SettingsClass;
import frost.fileTransfer.download.DownloadModel;
import frost.fileTransfer.download.DownloadPanel;
import frost.fileTransfer.download.DownloadThread;
import frost.fileTransfer.download.DownloadTickerListener;
import frost.fileTransfer.download.FrostDownloadItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.event.EventListenerList;

public class DownloadTicker
extends Thread {
    private SettingsClass settings;
    private DownloadPanel panel;
    private DownloadModel model;
    private int counter;
    private int allocatedThreads = 0;
    private int runningThreads = 0;
    private Object threadCountLock = new Object();
    protected EventListenerList listenerList = new EventListenerList();
    static final Comparator downloadDlStopMillisCmp = new Comparator(){

        public int compare(Object object, Object object2) {
            FrostDownloadItem frostDownloadItem = (FrostDownloadItem)object;
            FrostDownloadItem frostDownloadItem2 = (FrostDownloadItem)object2;
            if (frostDownloadItem.getLastDownloadStopTimeMillis() > frostDownloadItem2.getLastDownloadStopTimeMillis()) {
                return 1;
            }
            if (frostDownloadItem.getLastDownloadStopTimeMillis() < frostDownloadItem2.getLastDownloadStopTimeMillis()) {
                return -1;
            }
            return 0;
        }
    };

    public DownloadTicker(SettingsClass settingsClass, DownloadModel downloadModel, DownloadPanel downloadPanel) {
        super("Download");
        this.settings = settingsClass;
        this.model = downloadModel;
        this.panel = downloadPanel;
    }

    public void addDownloadTickerListener(DownloadTickerListener downloadTickerListener) {
        this.listenerList.add(DownloadTickerListener.class, downloadTickerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean allocateThread() {
        Object object = this.threadCountLock;
        synchronized (object) {
            if (this.allocatedThreads < this.settings.getIntValue("downloadThreads")) {
                ++this.allocatedThreads;
                return true;
            }
        }
        return false;
    }

    protected void fireThreadCountChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DownloadTickerListener.class) continue;
            ((DownloadTickerListener)objectArray[i + 1]).threadCountChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseThread() {
        Object object = this.threadCountLock;
        synchronized (object) {
            if (this.allocatedThreads > 0) {
                --this.allocatedThreads;
            }
        }
    }

    public int getRunningThreads() {
        return this.runningThreads;
    }

    public void run() {
        super.run();
        while (true) {
            Mixed.wait(1000);
            ++this.counter;
            this.updateDownloadCountLabel();
            this.startDownloadThread();
            this.removeFinishedDownloads();
        }
    }

    void threadFinished() {
        --this.runningThreads;
        this.fireThreadCountChanged();
        this.releaseThread();
    }

    void threadStarted() {
        ++this.runningThreads;
        this.fireThreadCountChanged();
    }

    private void removeFinishedDownloads() {
        if (this.counter % 300 == 0 && this.settings.getBoolValue("removeFinishedDownloads")) {
            this.model.removeFinishedDownloads();
        }
    }

    public void removeDownloadTickerListener(DownloadTickerListener downloadTickerListener) {
        this.listenerList.remove(DownloadTickerListener.class, downloadTickerListener);
    }

    public void updateDownloadCountLabel() {
        if (this.settings.getBoolValue("disableDownloads")) {
            return;
        }
        int n = 0;
        for (int i = 0; i < this.model.getItemCount(); ++i) {
            FrostDownloadItem frostDownloadItem = (FrostDownloadItem)this.model.getItemAt(i);
            if (frostDownloadItem.getState() != 1) continue;
            ++n;
        }
        this.panel.setDownloadItemCount(n);
    }

    private void startDownloadThread() {
        if (this.panel.isDownloadingActivated() && this.allocateThread()) {
            boolean bl = false;
            FrostDownloadItem frostDownloadItem = this.selectNextDownloadItem();
            if (frostDownloadItem != null) {
                frostDownloadItem.setState(2);
                DownloadThread downloadThread = new DownloadThread(this, frostDownloadItem, this.model, this.settings);
                downloadThread.start();
                bl = true;
            }
            if (!bl) {
                this.releaseThread();
            }
        }
    }

    private FrostDownloadItem selectNextDownloadItem() {
        ArrayList<FrostDownloadItem> arrayList = new ArrayList<FrostDownloadItem>();
        for (int i = 0; i < this.model.getItemCount(); ++i) {
            FrostDownloadItem frostDownloadItem = (FrostDownloadItem)this.model.getItemAt(i);
            if ((frostDownloadItem.getState() != 1 || frostDownloadItem.getEnableDownload() != null && !frostDownloadItem.getEnableDownload().booleanValue()) && (frostDownloadItem.getState() != 7 && frostDownloadItem.getState() != 5 || frostDownloadItem.getKey() == null || frostDownloadItem.getEnableDownload() != null && !frostDownloadItem.getEnableDownload().booleanValue())) continue;
            long l = this.settings.getIntValue("downloadWaittime") * 60 * 1000;
            if (!this.settings.getBoolValue("downloadRestartFailedDownloads") || System.currentTimeMillis() - frostDownloadItem.getLastDownloadStopTimeMillis() <= l) continue;
            arrayList.add(frostDownloadItem);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() > 1) {
            Collections.sort(arrayList, downloadDlStopMillisCmp);
        }
        return (FrostDownloadItem)arrayList.get(0);
    }
}

