/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.download;

import frost.Core;
import frost.DateFun;
import frost.FileAccess;
import frost.Mixed;
import frost.SettingsClass;
import frost.fcp.FcpInsert;
import frost.fcp.FcpRequest;
import frost.fcp.FcpResults;
import frost.fileTransfer.Index;
import frost.fileTransfer.download.DownloadModel;
import frost.fileTransfer.download.DownloadTicker;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.gui.objects.Board;
import frost.messages.SharedFileObject;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DownloadThread
extends Thread {
    private SettingsClass settings;
    private DownloadTicker ticker;
    private static Logger logger = Logger.getLogger(DownloadThread.class.getName());
    public static final String KEYCOLL_INDICATOR = "ERROR: key collision";
    private String filename;
    private Long size;
    private String key;
    private String SHA1;
    private String batch;
    private String owner;
    private Board board;
    private FrostDownloadItem downloadItem;
    private DownloadModel downloadModel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block22: {
            this.ticker.threadStarted();
            try {
                Object object;
                String string = DateFun.getExtendedDate();
                File file = new File(this.settings.getValue("downloadDirectory") + this.filename);
                if (this.key == null) {
                    logger.info("FILEDN: Requesting " + this.filename);
                    this.downloadItem.setState(5);
                    try {
                        this.request();
                        logger.info("FILEDN: Uploaded request for " + this.filename);
                    }
                    catch (Throwable throwable) {
                        logger.log(Level.SEVERE, "FILEDN: Uploading request failed for " + this.filename, throwable);
                    }
                    this.downloadItem.setState(7);
                    this.downloadItem.setLastDownloadStopTimeMillis(System.currentTimeMillis());
                    this.ticker.threadFinished();
                    return;
                }
                logger.info("FILEDN: Download of '" + this.filename + "' started.");
                FcpResults fcpResults = null;
                try {
                    fcpResults = FcpRequest.getFile(this.key, this.size, file, 25, true, false, false, this.downloadItem);
                }
                catch (Throwable throwable) {
                    logger.log(Level.SEVERE, "Exception thrown in run()", throwable);
                }
                boolean bl = false;
                for (int i = 0; i < this.downloadModel.getItemCount(); ++i) {
                    object = (FrostDownloadItem)this.downloadModel.getItemAt(i);
                    if (((FrostDownloadItem)object).getKey() == null || !((FrostDownloadItem)object).getKey().equals(this.downloadItem.getKey())) continue;
                    bl = true;
                    break;
                }
                if (fcpResults == null) {
                    this.downloadItem.setRetries(this.downloadItem.getRetries() + 1);
                    logger.warning("FILEDN: Download of " + this.filename + " failed.");
                    if (bl) {
                        if (this.settings.getBoolValue("downloadEnableRequesting") && this.downloadItem.getRetries() >= this.settings.getIntValue("downloadRequestAfterTries") && this.board != null && !this.board.isFolder() && this.owner != null) {
                            logger.info("FILEDN: Download failed, uploading request for " + this.filename);
                            this.downloadItem.setState(5);
                            try {
                                this.request();
                                logger.info("FILEDN: Uploaded request for " + this.filename);
                            }
                            catch (Throwable throwable) {
                                logger.log(Level.SEVERE, "FILEDN: Uploading request failed for " + this.filename, throwable);
                            }
                        } else {
                            logger.info("FILEDN: Download failed (file is NOT requested).");
                        }
                        if (this.downloadItem.getRetries() > this.settings.getIntValue("downloadMaxRetries")) {
                            if (this.settings.getBoolValue("downloadRestartFailedDownloads")) {
                                this.downloadItem.setState(1);
                                this.downloadItem.setRetries(0);
                            } else {
                                this.downloadItem.setState(4);
                            }
                        } else {
                            this.downloadItem.setState(1);
                        }
                    }
                    break block22;
                }
                if (this.board != null && !this.board.isFolder() && this.SHA1 != null && Core.frostSettings.getBoolValue("shareDownloads")) {
                    SharedFileObject sharedFileObject = new SharedFileObject(this.key);
                    sharedFileObject.setFilename(this.filename);
                    sharedFileObject.setSize(file.length());
                    sharedFileObject.setSHA1(this.SHA1);
                    sharedFileObject.setDate(string);
                    Object object2 = object = Index.getInstance();
                    synchronized (object2) {
                        ((Index)object).addMine(sharedFileObject, this.board);
                    }
                }
                this.downloadItem.setFileSize(new Long(file.length()));
                this.downloadItem.setState(3);
                this.downloadItem.setEnableDownload(false);
                logger.info("FILEDN: Download of " + this.filename + " was successful.");
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, "Oo. EXCEPTION in requestThread.run", throwable);
            }
        }
        this.ticker.threadFinished();
        this.downloadItem.setLastDownloadStopTimeMillis(System.currentTimeMillis());
    }

    private void request() {
        Object object;
        int n = this.settings.getIntValue("tofUploadHtl");
        boolean bl = false;
        logger.info("FILEDN: Uploading request for '" + this.filename + "' to board '" + this.board.getName() + "'");
        if (this.batch == null || this.owner == null) {
            logger.severe("FILEDN: NO batch or owner, skipping upload of request for " + this.filename);
            return;
        }
        String string = new StringBuffer().append("requests").append(File.separator).append(this.owner).append("-").append(this.batch).append("-").append(DateFun.getDate()).toString();
        File file = new File(string);
        if (!file.isDirectory()) {
            file.mkdirs();
        }
        File[] fileArray = file.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".req.sha");
            }
        });
        for (int i = 0; i < fileArray.length; ++i) {
            object = FileAccess.readFile(fileArray[i]).trim();
            if (!((String)object).equals(this.SHA1)) continue;
            bl = true;
            logger.info("FILEDN: File '" + this.filename + "' was already requested");
            break;
        }
        if (!bl) {
            String string2 = DateFun.getDate();
            object = null;
            try {
                object = File.createTempFile("reqUpload_", null, new File(this.settings.getValue("temp.dir")));
            }
            catch (Exception exception) {
                object = new File(this.settings.getValue("temp.dir") + System.currentTimeMillis() + ".tmp");
            }
            FileAccess.writeFile(this.SHA1, (File)object);
            boolean bl2 = false;
            int n2 = 0;
            int n3 = 0;
            boolean bl3 = false;
            File file2 = null;
            while (!bl2) {
                file2 = new File(new StringBuffer().append(string).append(File.separator).append(n2).append(".req.sha").toString());
                if (file2.length() > 0L) {
                    ++n2;
                    continue;
                }
                File file3 = new File(file2.getPath() + ".lock");
                boolean bl4 = false;
                try {
                    bl4 = file3.createNewFile();
                }
                catch (IOException iOException) {
                    logger.log(Level.SEVERE, "ERROR: requestThread.request(): unexpected IOException, terminating thread ...", iOException);
                    return;
                }
                if (!bl4) {
                    logger.fine("FILEDN: Other thread tries this index, increasing index to " + ++n2);
                    continue;
                }
                file3.deleteOnExit();
                String[] stringArray = new String[2];
                String string3 = new StringBuffer().append("KSK@frost/request/").append(this.settings.getValue("messageBase")).append("/").append(this.owner).append("-").append(this.batch).append("-").append(string2).append("-").append(n2).append(".req.sha").toString();
                logger.fine(string3);
                stringArray = FcpInsert.putFile(string3, (File)object, n, false);
                logger.fine("FcpInsert result[0] = " + stringArray[0] + " result[1] = " + stringArray[1]);
                if (stringArray[0] == null || stringArray[1] == null) {
                    stringArray[0] = "Error";
                    stringArray[1] = "Error";
                }
                if (stringArray[0].equals("Success")) {
                    bl2 = true;
                } else if (stringArray[0].equals("KeyCollision")) {
                    File file4 = null;
                    try {
                        file4 = File.createTempFile("reqUploadCmpDnload_", null, new File(this.settings.getValue("temp.dir")));
                    }
                    catch (Exception exception) {
                        file4 = new File(this.settings.getValue("temp.dir") + System.currentTimeMillis() + ".tmp");
                    }
                    file4.deleteOnExit();
                    String string4 = string3;
                    if (FcpRequest.getFile(string4, null, file4, 25, false) != null) {
                        String string5;
                        File file5 = file4;
                        Object object2 = object;
                        String string6 = FileAccess.readFile(file5).trim();
                        if (string6.equals(string5 = FileAccess.readFile((File)object2).trim())) {
                            logger.fine("FILEDN: Key Collision and file was already requested");
                            bl2 = true;
                        } else {
                            logger.fine("FILEDN: Request Upload collided, increasing index to " + ++n2);
                            if (this.settings.getBoolValue("disableRequests")) {
                                FileAccess.writeFile(KEYCOLL_INDICATOR, file2);
                            }
                        }
                    } else {
                        logger.info("FILEDN: Request upload failed (" + n3 + "), retrying index " + n2);
                        if (n3 > 5) {
                            bl2 = true;
                            bl3 = true;
                        }
                        ++n3;
                    }
                    file4.delete();
                }
                file3.delete();
            }
            if (!bl3) {
                ((File)object).renameTo(file2);
                logger.info("*********************************************************************\nRequest for '" + this.filename + "' successfully uploaded to board '" + this.board + "'.\n" + "*********************************************************************");
            } else {
                logger.warning("FILEDN: Error while uploading request for '" + this.filename + "' to board '" + this.board + "'.");
                ((File)object).delete();
            }
            logger.info("FILEDN: Request Upload Thread finished");
        }
    }

    public DownloadThread(DownloadTicker downloadTicker, FrostDownloadItem frostDownloadItem, DownloadModel downloadModel, SettingsClass settingsClass) {
        this.settings = settingsClass;
        this.filename = frostDownloadItem.getFileName();
        this.size = frostDownloadItem.getFileSize();
        this.key = frostDownloadItem.getKey();
        this.board = frostDownloadItem.getSourceBoard();
        this.SHA1 = frostDownloadItem.getSHA1();
        this.batch = frostDownloadItem.getBatch();
        this.owner = frostDownloadItem.getOwner() != null ? Mixed.makeFilename(frostDownloadItem.getOwner()) : null;
        this.ticker = downloadTicker;
        this.downloadItem = frostDownloadItem;
        this.downloadModel = downloadModel;
    }
}

