/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.download;

import frost.fileTransfer.download.FrostDownloadItem;
import frost.gui.objects.Board;
import frost.util.gui.BooleanCell;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import frost.util.model.ModelItem;
import frost.util.model.gui.ModelTable;
import frost.util.model.gui.SortedTableFormat;
import java.awt.Component;
import java.util.Comparator;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;

class DownloadTableFormat
extends SortedTableFormat
implements LanguageListener {
    private Language language = Language.getInstance();
    private static final int COLUMN_COUNT = 10;
    String stateWaiting;
    String stateTrying;
    String stateFailed;
    String stateDone;
    String stateRequesting;
    String stateRequested;
    String stateDecoding;
    String offline;
    String unknown;
    String anonymous;

    public DownloadTableFormat() {
        super(10);
        this.language.addLanguageListener(this);
        this.refreshLanguage();
        this.setComparator(new EnabledComparator(), 0);
        this.setComparator(new FileNameComparator(), 1);
        this.setComparator(new SizeComparator(), 2);
        this.setComparator(new AgeComparator(), 3);
        this.setComparator(new StateComparator(), 4);
        this.setComparator(new BlocksComparator(), 5);
        this.setComparator(new TriesComparator(), 6);
        this.setComparator(new SourceComparator(), 7);
        this.setComparator(new FromComparator(), 8);
        this.setComparator(new KeyComparator(), 9);
    }

    private void refreshLanguage() {
        this.setColumnName(0, this.language.getString("DownloadTableFormat.Enabled"));
        this.setColumnName(1, this.language.getString("Filename"));
        this.setColumnName(2, this.language.getString("Size"));
        this.setColumnName(3, this.language.getString("Age"));
        this.setColumnName(4, this.language.getString("State"));
        this.setColumnName(5, this.language.getString("Blocks"));
        this.setColumnName(6, this.language.getString("Tries"));
        this.setColumnName(7, this.language.getString("Source"));
        this.setColumnName(8, this.language.getString("From"));
        this.setColumnName(9, this.language.getString("Key"));
        this.stateWaiting = this.language.getString("Waiting");
        this.stateTrying = this.language.getString("Trying");
        this.stateFailed = this.language.getString("Failed");
        this.stateDone = this.language.getString("Done");
        this.stateRequesting = this.language.getString("Requesting");
        this.stateRequested = this.language.getString("Requested");
        this.stateDecoding = this.language.getString("Decoding segment") + "...";
        this.offline = this.language.getString("FrostSearchItemObject.Offline");
        this.unknown = this.language.getString("Unknown");
        this.anonymous = this.language.getString("FrostSearchItemObject.Anonymous");
        this.refreshColumnNames();
    }

    public void languageChanged(LanguageEvent languageEvent) {
        this.refreshLanguage();
    }

    public Object getCellValue(ModelItem modelItem, int n) {
        FrostDownloadItem frostDownloadItem = (FrostDownloadItem)modelItem;
        switch (n) {
            case 0: {
                return frostDownloadItem.getEnableDownload();
            }
            case 1: {
                return frostDownloadItem.getFileName();
            }
            case 2: {
                if (frostDownloadItem.getFileSize() == null) {
                    return this.unknown;
                }
                return frostDownloadItem.getFileSize();
            }
            case 3: {
                if (frostDownloadItem.getFileAge() == null) {
                    return this.offline;
                }
                return frostDownloadItem.getFileAge();
            }
            case 4: {
                return this.getStateAsString(frostDownloadItem.getState(), frostDownloadItem.getTotalBlocks(), frostDownloadItem.getDoneBlocks(), frostDownloadItem.getRequiredBlocks());
            }
            case 5: {
                return this.getBlocksAsString(frostDownloadItem.getTotalBlocks(), frostDownloadItem.getDoneBlocks(), frostDownloadItem.getRequiredBlocks());
            }
            case 6: {
                return new Integer(frostDownloadItem.getRetries());
            }
            case 7: {
                if (frostDownloadItem.getSourceBoard() == null) {
                    return "";
                }
                return frostDownloadItem.getSourceBoard().getName();
            }
            case 8: {
                if (frostDownloadItem.getOwner() == null) {
                    return this.anonymous;
                }
                return frostDownloadItem.getOwner();
            }
            case 9: {
                if (frostDownloadItem.getKey() == null) {
                    return " ?";
                }
                return frostDownloadItem.getKey();
            }
        }
        return "**ERROR**";
    }

    private String getBlocksAsString(int n, int n2, int n3) {
        if (n == 0) {
            return "";
        }
        return n2 + " / " + n3 + " (" + n + ")";
    }

    private String getStateAsString(int n, int n2, int n3, int n4) {
        switch (n) {
            case 1: {
                return this.stateWaiting;
            }
            case 2: {
                return this.stateTrying;
            }
            case 4: {
                return this.stateFailed;
            }
            case 3: {
                return this.stateDone;
            }
            case 5: {
                return this.stateRequesting;
            }
            case 7: {
                return this.stateRequested;
            }
            case 8: {
                return this.stateDecoding;
            }
            case 6: {
                if (n2 > 0) {
                    return n3 * 100 / n4 + "%";
                }
                return "0%";
            }
        }
        return "**ERROR**";
    }

    public int[] getColumnNumbers(int n) {
        switch (n) {
            case 100: {
                return new int[]{4, 5};
            }
            case 101: {
                return new int[]{0};
            }
            case 102: {
                return new int[]{3};
            }
            case 103: {
                return new int[]{1};
            }
            case 104: {
                return new int[]{2};
            }
            case 105: {
                return new int[]{9};
            }
            case 106: {
                return new int[]{8};
            }
            case 107: {
                return new int[]{4, 5};
            }
            case 108: {
                return new int[]{6};
            }
            case 109: {
                return new int[0];
            }
            case 110: {
                return new int[]{4};
            }
            case 111: {
                return new int[]{7};
            }
            case 112: {
                return new int[]{4, 5};
            }
        }
        return new int[0];
    }

    public void customizeTable(ModelTable modelTable) {
        super.customizeTable(modelTable);
        TableColumnModel tableColumnModel = modelTable.getTable().getColumnModel();
        int[] nArray = new int[]{30, 170, 80, 70, 70, 75, 25, 60, 60, 40};
        for (int i = 0; i < nArray.length; ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth(nArray[i]);
        }
        tableColumnModel.getColumn(0).setCellRenderer(BooleanCell.RENDERER);
        tableColumnModel.getColumn(0).setCellEditor(BooleanCell.EDITOR);
        this.setColumnEditable(0, true);
        tableColumnModel.getColumn(2).setCellRenderer(new SizeRenderer());
    }

    public void setCellValue(Object object, ModelItem modelItem, int n) {
        FrostDownloadItem frostDownloadItem = (FrostDownloadItem)modelItem;
        switch (n) {
            case 0: {
                Boolean bl = (Boolean)object;
                frostDownloadItem.setEnableDownload(bl);
                break;
            }
            default: {
                super.setCellValue(object, modelItem, n);
            }
        }
    }

    private class EnabledComparator
    implements Comparator {
        private EnabledComparator() {
        }

        public int compare(Object object, Object object2) {
            FrostDownloadItem frostDownloadItem = (FrostDownloadItem)object;
            FrostDownloadItem frostDownloadItem2 = (FrostDownloadItem)object2;
            return frostDownloadItem.getEnableDownload().equals(frostDownloadItem2.getEnableDownload()) ? 0 : 1;
        }
    }

    private class FileNameComparator
    implements Comparator {
        private FileNameComparator() {
        }

        public int compare(Object object, Object object2) {
            FrostDownloadItem frostDownloadItem = (FrostDownloadItem)object;
            FrostDownloadItem frostDownloadItem2 = (FrostDownloadItem)object2;
            return frostDownloadItem.getFileName().compareToIgnoreCase(frostDownloadItem2.getFileName());
        }
    }

    private class SizeComparator
    implements Comparator {
        private SizeComparator() {
        }

        public int compare(Object object, Object object2) {
            Long l = ((FrostDownloadItem)object).getFileSize();
            Long l2 = ((FrostDownloadItem)object2).getFileSize();
            if (l == null) {
                l = new Long(-1L);
            }
            if (l2 == null) {
                l2 = new Long(-1L);
            }
            return l.compareTo(l2);
        }
    }

    private class AgeComparator
    implements Comparator {
        private AgeComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = ((FrostDownloadItem)object).getFileAge();
            String string2 = ((FrostDownloadItem)object2).getFileAge();
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            return string.compareToIgnoreCase(string2);
        }
    }

    private class StateComparator
    implements Comparator {
        private StateComparator() {
        }

        public int compare(Object object, Object object2) {
            FrostDownloadItem frostDownloadItem = (FrostDownloadItem)object;
            FrostDownloadItem frostDownloadItem2 = (FrostDownloadItem)object2;
            String string = DownloadTableFormat.this.getStateAsString(frostDownloadItem.getState(), frostDownloadItem.getTotalBlocks(), frostDownloadItem.getDoneBlocks(), frostDownloadItem.getRequiredBlocks());
            String string2 = DownloadTableFormat.this.getStateAsString(frostDownloadItem2.getState(), frostDownloadItem2.getTotalBlocks(), frostDownloadItem2.getDoneBlocks(), frostDownloadItem2.getRequiredBlocks());
            return string.compareToIgnoreCase(string2);
        }
    }

    private class BlocksComparator
    implements Comparator {
        private BlocksComparator() {
        }

        public int compare(Object object, Object object2) {
            FrostDownloadItem frostDownloadItem = (FrostDownloadItem)object;
            FrostDownloadItem frostDownloadItem2 = (FrostDownloadItem)object2;
            String string = DownloadTableFormat.this.getBlocksAsString(frostDownloadItem.getTotalBlocks(), frostDownloadItem.getDoneBlocks(), frostDownloadItem.getRequiredBlocks());
            String string2 = DownloadTableFormat.this.getBlocksAsString(frostDownloadItem2.getTotalBlocks(), frostDownloadItem2.getDoneBlocks(), frostDownloadItem2.getRequiredBlocks());
            return string.compareToIgnoreCase(string2);
        }
    }

    private class TriesComparator
    implements Comparator {
        private TriesComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = ((FrostDownloadItem)object).getRetries();
            int n2 = ((FrostDownloadItem)object2).getRetries();
            return new Integer(n).compareTo(new Integer(n2));
        }
    }

    private class SourceComparator
    implements Comparator {
        private SourceComparator() {
        }

        public int compare(Object object, Object object2) {
            Board board = ((FrostDownloadItem)object).getSourceBoard();
            Board board2 = ((FrostDownloadItem)object2).getSourceBoard();
            String string = "";
            String string2 = "";
            if (board != null) {
                string = board.getName();
            }
            if (board2 != null) {
                string2 = board2.getName();
            }
            return string.compareToIgnoreCase(string2);
        }
    }

    private class FromComparator
    implements Comparator {
        private FromComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = ((FrostDownloadItem)object).getOwner();
            String string2 = ((FrostDownloadItem)object2).getOwner();
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            return string.compareToIgnoreCase(string2);
        }
    }

    private class KeyComparator
    implements Comparator {
        private KeyComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = ((FrostDownloadItem)object).getKey();
            String string2 = ((FrostDownloadItem)object2).getKey();
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            return string.compareToIgnoreCase(string2);
        }
    }

    private class SizeRenderer
    extends DefaultTableCellRenderer {
        private SizeRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setHorizontalAlignment(4);
            this.setBorder(new EmptyBorder(0, 0, 0, 3));
            return this;
        }
    }
}

