/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.download;

import frost.fileTransfer.download.DownloadTicker;
import frost.fileTransfer.download.DownloadTickerListener;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DownloadStatusPanel
extends JPanel {
    private DownloadTicker ticker;
    private Language language;
    private JLabel downloadingLabel = new JLabel();
    private JLabel countLabel = new JLabel();
    private JLabel filesLabel = new JLabel();
    int count = 0;
    private Listener listener = new Listener();

    public DownloadStatusPanel(DownloadTicker downloadTicker) {
        this.ticker = downloadTicker;
        this.language = Language.getInstance();
        this.initialize();
    }

    private void initialize() {
        this.refreshLanguage();
        this.setLayout(new FlowLayout(0, 5, 0));
        this.count = this.ticker.getRunningThreads();
        this.countLabel.setText("" + this.count);
        this.add(this.downloadingLabel);
        this.add(this.countLabel);
        this.add(this.filesLabel);
        this.ticker.addDownloadTickerListener(this.listener);
        this.language.addLanguageListener(this.listener);
    }

    private void refreshLanguage() {
        this.downloadingLabel.setText(this.language.getString("DownloadStatusPanel.Downloading"));
        if (this.count == 1) {
            this.filesLabel.setText(this.language.getString("StatusPanel.file"));
        } else {
            this.filesLabel.setText(this.language.getString("StatusPanel.files"));
        }
    }

    private void numberChanged() {
        this.count = this.ticker.getRunningThreads();
        this.countLabel.setText("" + this.count);
        this.refreshLanguage();
    }

    private class Listener
    implements DownloadTickerListener,
    LanguageListener {
        private Listener() {
        }

        public void threadCountChanged() {
            DownloadStatusPanel.this.numberChanged();
        }

        public void languageChanged(LanguageEvent languageEvent) {
            DownloadStatusPanel.this.refreshLanguage();
        }
    }
}

