/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.download;

import frost.SettingsClass;
import frost.SettingsUpdater;
import frost.ext.Execute;
import frost.fileTransfer.download.DownloadModel;
import frost.fileTransfer.download.DownloadTableFormat;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.util.gui.JSkinnablePopupMenu;
import frost.util.gui.MiscToolkit;
import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import frost.util.model.ModelItem;
import frost.util.model.OrderedModel;
import frost.util.model.gui.SortedModelTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DownloadPanel
extends JPanel
implements SettingsUpdater {
    private PopupMenuDownload popupMenuDownload = null;
    private Listener listener = new Listener();
    private static Logger logger = Logger.getLogger(DownloadPanel.class.getName());
    private DownloadModel model = null;
    private SettingsClass settingsClass = null;
    private Language language = null;
    private JPanel downloadTopPanel = new JPanel();
    private JButton downloadActivateButton = new JButton(new ImageIcon(this.getClass().getResource("/data/down_selected.gif")));
    private JButton downloadPauseButton = new JButton(new ImageIcon(this.getClass().getResource("/data/down.gif")));
    private JTextField downloadTextField = new JTextField(25);
    private JLabel downloadItemCountLabel = new JLabel();
    private SortedModelTable modelTable;
    private boolean initialized = false;
    private String fileSeparator = System.getProperty("file.separator");
    private boolean downloadingActivated = false;
    private long downloadItemCount = 0L;

    public DownloadPanel(SettingsClass settingsClass) {
        this.settingsClass = settingsClass;
        settingsClass.addUpdater(this);
        this.language = Language.getInstance();
        this.language.addLanguageListener(this.listener);
    }

    public void initialize() {
        if (!this.initialized) {
            this.refreshLanguage();
            MiscToolkit miscToolkit = MiscToolkit.getInstance();
            miscToolkit.configureButton(this.downloadActivateButton, "/data/down_selected_rollover.gif");
            miscToolkit.configureButton(this.downloadPauseButton, "/data/down_rollover.gif");
            new TextComponentClipboardMenu(this.downloadTextField, this.language);
            BoxLayout boxLayout = new BoxLayout(this.downloadTopPanel, 0);
            this.downloadTopPanel.setLayout(boxLayout);
            this.downloadTextField.setMaximumSize(this.downloadTextField.getPreferredSize());
            this.downloadTopPanel.add(this.downloadTextField);
            this.downloadTopPanel.add(Box.createRigidArea(new Dimension(8, 0)));
            this.downloadTopPanel.add(this.downloadActivateButton);
            this.downloadTopPanel.add(this.downloadPauseButton);
            this.downloadTopPanel.add(Box.createRigidArea(new Dimension(80, 0)));
            this.downloadTopPanel.add(Box.createHorizontalGlue());
            this.downloadTopPanel.add(this.downloadItemCountLabel);
            DownloadTableFormat downloadTableFormat = new DownloadTableFormat();
            this.modelTable = new SortedModelTable((OrderedModel)this.model, downloadTableFormat);
            this.setLayout(new BorderLayout());
            this.add((Component)this.downloadTopPanel, "North");
            this.add((Component)this.modelTable.getScrollPane(), "Center");
            this.fontChanged();
            this.downloadTextField.addActionListener(this.listener);
            this.downloadActivateButton.addActionListener(this.listener);
            this.downloadPauseButton.addActionListener(this.listener);
            this.modelTable.getScrollPane().addMouseListener(this.listener);
            this.modelTable.getTable().addKeyListener(this.listener);
            this.modelTable.getTable().addMouseListener(this.listener);
            this.settingsClass.addPropertyChangeListener("fileListFontName", this.listener);
            this.settingsClass.addPropertyChangeListener("fileListFontSize", this.listener);
            this.settingsClass.addPropertyChangeListener("fileListFontStyle", this.listener);
            this.setDownloadingActivated(this.settingsClass.getBoolValue("downloadingActivated"));
            this.initialized = true;
        }
    }

    private Dimension calculateLabelSize(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.doLayout();
        return jLabel.getPreferredSize();
    }

    private void refreshLanguage() {
        this.downloadActivateButton.setToolTipText(this.language.getString("Activate downloading"));
        this.downloadPauseButton.setToolTipText(this.language.getString("Pause downloading"));
        String string = this.language.getString("Waiting");
        Dimension dimension = this.calculateLabelSize(string + " : 00000");
        this.downloadItemCountLabel.setPreferredSize(dimension);
        this.downloadItemCountLabel.setMinimumSize(dimension);
        this.downloadItemCountLabel.setText(string + " : " + this.downloadItemCount);
    }

    public void setModel(DownloadModel downloadModel) {
        this.model = downloadModel;
    }

    private void configureCheckBox(JCheckBox jCheckBox, String string, String string2, String string3) {
        jCheckBox.setRolloverIcon(new ImageIcon(this.getClass().getResource(string)));
        jCheckBox.setSelectedIcon(new ImageIcon(this.getClass().getResource(string2)));
        jCheckBox.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource(string3)));
        jCheckBox.setMargin(new Insets(0, 0, 0, 0));
        jCheckBox.setFocusPainted(false);
    }

    private void downloadTextField_actionPerformed(ActionEvent actionEvent) {
        String string = this.downloadTextField.getText().trim();
        if (string.length() == 0) {
            this.downloadTextField.setText("");
            return;
        }
        String[] stringArray = string.split(";");
        if (stringArray == null || stringArray.length == 0) {
            this.downloadTextField.setText("");
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            String string3 = stringArray[i].trim();
            if (string3.length() == 0) continue;
            String string4 = "http://127.0.0.1:8888/";
            if (string3.startsWith(string4)) {
                string3 = string3.substring(string4.length());
            }
            if (string3.startsWith(string4 = "freenet:")) {
                string3 = string3.substring(string4.length());
            }
            if (string3.length() < 5) {
                this.showInvalidKeyErrorDialog(string3);
                continue;
            }
            String[] stringArray2 = new String[]{"SSK@", "CHK@", "KSK@"};
            int n = -1;
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!string3.startsWith(stringArray2[j])) continue;
                n = j;
                break;
            }
            if (n < 0) {
                this.showInvalidKeyErrorDialog(string3);
                continue;
            }
            int n2 = string3.lastIndexOf(":");
            if (n2 > -1) {
                string2 = string3.substring(n2 + 1);
                string3 = string3.substring(0, n2);
            } else {
                n2 = string3.lastIndexOf("/");
                string2 = n2 > -1 ? string3.substring(n2 + 1) : string3.substring(4);
            }
            if (n == 1 && string3.indexOf("/") > -1) {
                string3 = string3.substring(0, string3.indexOf("/"));
            }
            FrostDownloadItem frostDownloadItem = new FrostDownloadItem(string2, string3, null);
            this.model.addDownloadItem(frostDownloadItem);
        }
        this.downloadTextField.setText("");
    }

    private void showInvalidKeyErrorDialog(String string) {
        JOptionPane.showMessageDialog(this, "<html>" + this.language.getString("Invalid key.  Key must begin with one of") + " SSK@, KSK@, @CHK: <br>" + string + "</html>", this.language.getString("Invalid key"), 0);
    }

    private void downloadTable_keyPressed(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == '\u007f' && !this.modelTable.getTable().isEditing()) {
            ModelItem[] modelItemArray = this.modelTable.getSelectedItems();
            this.model.removeItems(modelItemArray);
        }
    }

    public boolean isDownloadingActivated() {
        return this.downloadingActivated;
    }

    public void setDownloadingActivated(boolean bl) {
        this.downloadingActivated = bl;
        this.downloadActivateButton.setEnabled(!this.downloadingActivated);
        this.downloadPauseButton.setEnabled(this.downloadingActivated);
    }

    public void setDownloadItemCount(long l) {
        this.downloadItemCount = l;
        String string = new StringBuffer().append(this.language.getString("Waiting")).append(" : ").append(this.downloadItemCount).toString();
        this.downloadItemCountLabel.setText(string);
    }

    private PopupMenuDownload getPopupMenuDownload() {
        if (this.popupMenuDownload == null) {
            this.popupMenuDownload = new PopupMenuDownload();
            this.language.addLanguageListener(this.popupMenuDownload);
        }
        return this.popupMenuDownload;
    }

    private void showDownloadTablePopupMenu(MouseEvent mouseEvent) {
        this.getPopupMenuDownload().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private void fontChanged() {
        int n;
        int n2;
        String string = this.settingsClass.getValue("fileListFontName");
        Font font = new Font(string, n2 = this.settingsClass.getIntValue("fileListFontStyle"), n = this.settingsClass.getIntValue("fileListFontSize"));
        if (!font.getFamily().equals(string)) {
            logger.severe("The selected font was not found in your system\nThat selection will be changed to \"SansSerif\".");
            this.settingsClass.setValue("fileListFontName", "SansSerif");
            font = new Font("SansSerif", n2, n);
        }
        this.modelTable.setFont(font);
    }

    private void downloadActivateButtonPressed(ActionEvent actionEvent) {
        this.setDownloadingActivated(true);
    }

    private void downloadPauseButtonPressed(ActionEvent actionEvent) {
        this.setDownloadingActivated(false);
    }

    private void downloadTableDoubleClick(MouseEvent mouseEvent) {
        int n = this.modelTable.getTable().columnAtPoint(mouseEvent.getPoint());
        int n2 = this.modelTable.getTable().getColumnModel().getColumn(n).getModelIndex();
        if (n2 == 0) {
            return;
        }
        ModelItem modelItem = this.modelTable.getSelectedItem();
        if (modelItem != null) {
            FrostDownloadItem frostDownloadItem = (FrostDownloadItem)modelItem;
            String string = new StringBuffer().append(System.getProperty("user.dir")).append(this.fileSeparator).append(this.settingsClass.getValue("downloadDirectory")).append(frostDownloadItem.getFileName()).toString();
            File file = new File(string);
            logger.info("Executing: " + file.getPath());
            if (file.exists()) {
                Execute.run("exec.bat \"" + file.getPath() + "\"");
            }
        }
    }

    public void updateSettings() {
        this.settingsClass.setValue("downloadingActivated", this.isDownloadingActivated());
    }

    private class Listener
    extends MouseAdapter
    implements LanguageListener,
    ActionListener,
    KeyListener,
    MouseListener,
    PropertyChangeListener {
        public void languageChanged(LanguageEvent languageEvent) {
            DownloadPanel.this.refreshLanguage();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == DownloadPanel.this.downloadTextField) {
                DownloadPanel.this.downloadTextField_actionPerformed(actionEvent);
            } else if (actionEvent.getSource() == DownloadPanel.this.downloadActivateButton) {
                DownloadPanel.this.downloadActivateButtonPressed(actionEvent);
            } else if (actionEvent.getSource() == DownloadPanel.this.downloadPauseButton) {
                DownloadPanel.this.downloadPauseButtonPressed(actionEvent);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getSource() == DownloadPanel.this.modelTable.getTable()) {
                DownloadPanel.this.downloadTable_keyPressed(keyEvent);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                if (mouseEvent.getSource() == DownloadPanel.this.modelTable.getTable()) {
                    DownloadPanel.this.downloadTableDoubleClick(mouseEvent);
                }
            } else if (mouseEvent.isPopupTrigger() && (mouseEvent.getSource() == DownloadPanel.this.modelTable.getTable() || mouseEvent.getSource() == DownloadPanel.this.modelTable.getScrollPane())) {
                DownloadPanel.this.showDownloadTablePopupMenu(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 1 && mouseEvent.isPopupTrigger() && (mouseEvent.getSource() == DownloadPanel.this.modelTable.getTable() || mouseEvent.getSource() == DownloadPanel.this.modelTable.getScrollPane())) {
                DownloadPanel.this.showDownloadTablePopupMenu(mouseEvent);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("fileListFontName")) {
                DownloadPanel.this.fontChanged();
            }
            if (propertyChangeEvent.getPropertyName().equals("fileListFontSize")) {
                DownloadPanel.this.fontChanged();
            }
            if (propertyChangeEvent.getPropertyName().equals("fileListFontStyle")) {
                DownloadPanel.this.fontChanged();
            }
        }
    }

    private class PopupMenuDownload
    extends JSkinnablePopupMenu
    implements ActionListener,
    LanguageListener,
    ClipboardOwner {
        private JMenuItem cancelItem = new JMenuItem();
        private JMenuItem copyKeysAndNamesItem = new JMenuItem();
        private JMenuItem copyKeysItem = new JMenuItem();
        private JMenuItem copyExtendedInfoItem = new JMenuItem();
        private JMenuItem disableAllDownloadsItem = new JMenuItem();
        private JMenuItem disableSelectedDownloadsItem = new JMenuItem();
        private JMenuItem enableAllDownloadsItem = new JMenuItem();
        private JMenuItem enableSelectedDownloadsItem = new JMenuItem();
        private JMenuItem invertEnabledAllItem = new JMenuItem();
        private JMenuItem invertEnabledSelectedItem = new JMenuItem();
        private JMenuItem removeAllDownloadsItem = new JMenuItem();
        private JMenuItem removeFinishedItem = new JMenuItem();
        private JMenuItem removeSelectedDownloadsItem = new JMenuItem();
        private JMenuItem restartSelectedDownloadsItem = new JMenuItem();
        private JMenu copyToClipboardMenu = new JMenu();
        private String keyNotAvailableMessage;
        private String fileMessage;
        private String keyMessage;
        private String bytesMessage;
        private Clipboard clipboard;

        public PopupMenuDownload() {
            this.initialize();
        }

        private void initialize() {
            this.refreshLanguage();
            this.copyToClipboardMenu.add(this.copyKeysAndNamesItem);
            this.copyToClipboardMenu.add(this.copyKeysItem);
            this.copyToClipboardMenu.add(this.copyExtendedInfoItem);
            this.copyKeysAndNamesItem.addActionListener(this);
            this.copyKeysItem.addActionListener(this);
            this.copyExtendedInfoItem.addActionListener(this);
            this.restartSelectedDownloadsItem.addActionListener(this);
            this.removeSelectedDownloadsItem.addActionListener(this);
            this.removeAllDownloadsItem.addActionListener(this);
            this.removeFinishedItem.addActionListener(this);
            this.enableAllDownloadsItem.addActionListener(this);
            this.disableAllDownloadsItem.addActionListener(this);
            this.enableSelectedDownloadsItem.addActionListener(this);
            this.disableSelectedDownloadsItem.addActionListener(this);
            this.invertEnabledAllItem.addActionListener(this);
            this.invertEnabledSelectedItem.addActionListener(this);
        }

        private void refreshLanguage() {
            this.keyNotAvailableMessage = DownloadPanel.this.language.getString("Key not available yet");
            this.fileMessage = DownloadPanel.this.language.getString("clipboard.File:");
            this.keyMessage = DownloadPanel.this.language.getString("clipboard.Key:");
            this.bytesMessage = DownloadPanel.this.language.getString("clipboard.Bytes:");
            this.cancelItem.setText(DownloadPanel.this.language.getString("Cancel"));
            this.copyKeysItem.setText(DownloadPanel.this.language.getString("Copy keys only"));
            this.copyKeysAndNamesItem.setText(DownloadPanel.this.language.getString("Copy keys with filenames"));
            this.copyExtendedInfoItem.setText(DownloadPanel.this.language.getString("Copy extended info"));
            this.restartSelectedDownloadsItem.setText(DownloadPanel.this.language.getString("Restart selected downloads"));
            this.removeSelectedDownloadsItem.setText(DownloadPanel.this.language.getString("Remove selected downloads"));
            this.removeAllDownloadsItem.setText(DownloadPanel.this.language.getString("Remove all downloads"));
            this.removeFinishedItem.setText(DownloadPanel.this.language.getString("Remove finished downloads"));
            this.enableAllDownloadsItem.setText(DownloadPanel.this.language.getString("Enable all downloads"));
            this.disableAllDownloadsItem.setText(DownloadPanel.this.language.getString("Disable all downloads"));
            this.enableSelectedDownloadsItem.setText(DownloadPanel.this.language.getString("Enable selected downloads"));
            this.disableSelectedDownloadsItem.setText(DownloadPanel.this.language.getString("Disable selected downloads"));
            this.invertEnabledAllItem.setText(DownloadPanel.this.language.getString("Invert enabled state for all downloads"));
            this.invertEnabledSelectedItem.setText(DownloadPanel.this.language.getString("Invert enabled state for selected downloads"));
            this.copyToClipboardMenu.setText(DownloadPanel.this.language.getString("Copy to clipboard") + "...");
        }

        private Clipboard getClipboard() {
            if (this.clipboard == null) {
                this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            return this.clipboard;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.copyKeysItem) {
                this.copyKeys();
            }
            if (actionEvent.getSource() == this.copyKeysAndNamesItem) {
                this.copyKeysAndNames();
            }
            if (actionEvent.getSource() == this.copyExtendedInfoItem) {
                this.copyExtendedInfo();
            }
            if (actionEvent.getSource() == this.restartSelectedDownloadsItem) {
                this.restartSelectedDownloads();
            }
            if (actionEvent.getSource() == this.removeSelectedDownloadsItem) {
                this.removeSelectedDownloads();
            }
            if (actionEvent.getSource() == this.removeAllDownloadsItem) {
                this.removeAllDownloads();
            }
            if (actionEvent.getSource() == this.removeFinishedItem) {
                this.removeFinished();
            }
            if (actionEvent.getSource() == this.enableAllDownloadsItem) {
                this.enableAllDownloads();
            }
            if (actionEvent.getSource() == this.disableAllDownloadsItem) {
                this.disableAllDownloads();
            }
            if (actionEvent.getSource() == this.enableSelectedDownloadsItem) {
                this.enableSelectedDownloads();
            }
            if (actionEvent.getSource() == this.disableSelectedDownloadsItem) {
                this.disableSelectedDownloads();
            }
            if (actionEvent.getSource() == this.invertEnabledAllItem) {
                this.invertEnabledAll();
            }
            if (actionEvent.getSource() == this.invertEnabledSelectedItem) {
                this.invertEnabledSelected();
            }
        }

        private void invertEnabledSelected() {
            ModelItem[] modelItemArray = DownloadPanel.this.modelTable.getSelectedItems();
            DownloadPanel.this.model.setItemsEnabled(null, modelItemArray);
        }

        private void invertEnabledAll() {
            DownloadPanel.this.model.setAllItemsEnabled(null);
        }

        private void disableSelectedDownloads() {
            ModelItem[] modelItemArray = DownloadPanel.this.modelTable.getSelectedItems();
            DownloadPanel.this.model.setItemsEnabled(new Boolean(false), modelItemArray);
        }

        private void enableSelectedDownloads() {
            ModelItem[] modelItemArray = DownloadPanel.this.modelTable.getSelectedItems();
            DownloadPanel.this.model.setItemsEnabled(new Boolean(true), modelItemArray);
        }

        private void disableAllDownloads() {
            DownloadPanel.this.model.setAllItemsEnabled(new Boolean(false));
        }

        private void enableAllDownloads() {
            DownloadPanel.this.model.setAllItemsEnabled(new Boolean(true));
        }

        private void removeFinished() {
            DownloadPanel.this.model.removeFinishedDownloads();
        }

        private void removeAllDownloads() {
            DownloadPanel.this.model.removeAllItems();
        }

        private void removeSelectedDownloads() {
            ModelItem[] modelItemArray = DownloadPanel.this.modelTable.getSelectedItems();
            DownloadPanel.this.model.removeItems(modelItemArray);
        }

        private void restartSelectedDownloads() {
            ModelItem[] modelItemArray = DownloadPanel.this.modelTable.getSelectedItems();
            DownloadPanel.this.model.restartItems(modelItemArray);
        }

        private void copyKeysAndNames() {
            ModelItem[] modelItemArray = DownloadPanel.this.modelTable.getSelectedItems();
            if (modelItemArray.length > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < modelItemArray.length; ++i) {
                    FrostDownloadItem frostDownloadItem = (FrostDownloadItem)modelItemArray[i];
                    String string = frostDownloadItem.getKey();
                    if (string == null) {
                        string = this.keyNotAvailableMessage;
                    }
                    stringBuffer.append(string);
                    stringBuffer.append("/");
                    stringBuffer.append(frostDownloadItem.getFileName());
                    stringBuffer.append("\n");
                }
                StringSelection stringSelection = new StringSelection(stringBuffer.toString());
                this.getClipboard().setContents(stringSelection, this);
            }
        }

        private void copyExtendedInfo() {
            ModelItem[] modelItemArray = DownloadPanel.this.modelTable.getSelectedItems();
            if (modelItemArray.length > 0) {
                Object object;
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < modelItemArray.length; ++i) {
                    object = (FrostDownloadItem)modelItemArray[i];
                    String string = ((FrostDownloadItem)object).getKey();
                    if (string == null) {
                        string = this.keyNotAvailableMessage;
                    }
                    stringBuffer.append(this.fileMessage);
                    stringBuffer.append(((FrostDownloadItem)object).getFileName() + "\n");
                    stringBuffer.append(this.keyMessage);
                    stringBuffer.append(string + "\n");
                    stringBuffer.append(this.bytesMessage);
                    stringBuffer.append(((FrostDownloadItem)object).getFileSize() + "\n\n");
                }
                String string = stringBuffer.substring(0, stringBuffer.length() - 1);
                object = new StringSelection(string);
                this.getClipboard().setContents((Transferable)object, this);
            }
        }

        private void copyKeys() {
            ModelItem[] modelItemArray = DownloadPanel.this.modelTable.getSelectedItems();
            if (modelItemArray.length > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < modelItemArray.length; ++i) {
                    FrostDownloadItem frostDownloadItem = (FrostDownloadItem)modelItemArray[i];
                    String string = frostDownloadItem.getKey();
                    if (string == null) {
                        string = this.keyNotAvailableMessage;
                    }
                    stringBuffer.append(string);
                    stringBuffer.append("\n");
                }
                StringSelection stringSelection = new StringSelection(stringBuffer.toString());
                this.getClipboard().setContents(stringSelection, this);
            }
        }

        public void languageChanged(LanguageEvent languageEvent) {
            this.refreshLanguage();
        }

        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }

        public void show(Component component, int n, int n2) {
            this.removeAll();
            ModelItem[] modelItemArray = DownloadPanel.this.modelTable.getSelectedItems();
            if (modelItemArray.length > 0) {
                this.add(this.copyToClipboardMenu);
                this.addSeparator();
            }
            if (modelItemArray.length != 0) {
                this.add(this.restartSelectedDownloadsItem);
                this.addSeparator();
            }
            JMenu jMenu = new JMenu(DownloadPanel.this.language.getString("Enable downloads") + "...");
            if (modelItemArray.length != 0) {
                jMenu.add(this.enableSelectedDownloadsItem);
                jMenu.add(this.disableSelectedDownloadsItem);
                jMenu.add(this.invertEnabledSelectedItem);
                jMenu.addSeparator();
            }
            jMenu.add(this.enableAllDownloadsItem);
            jMenu.add(this.disableAllDownloadsItem);
            jMenu.add(this.invertEnabledAllItem);
            this.add(jMenu);
            JMenu jMenu2 = new JMenu(DownloadPanel.this.language.getString("Remove") + "...");
            if (modelItemArray.length != 0) {
                jMenu2.add(this.removeSelectedDownloadsItem);
            }
            jMenu2.add(this.removeAllDownloadsItem);
            this.add(jMenu2);
            this.addSeparator();
            this.add(this.removeFinishedItem);
            this.addSeparator();
            this.add(this.cancelItem);
            super.show(component, n, n2);
        }
    }
}

