/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.download;

import frost.FileAccess;
import frost.MainFrame;
import frost.SettingsClass;
import frost.XMLTools;
import frost.fileTransfer.download.DownloadModel;
import frost.fileTransfer.download.DownloadModelDAO;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.gui.objects.Board;
import frost.storage.StorageException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class DownloadModelXmlDAO
implements DownloadModelDAO {
    private static Logger logger = Logger.getLogger(DownloadModelXmlDAO.class.getName());
    private static ResourceBundle langRes = ResourceBundle.getBundle("res.LangRes");
    private static final String XML_FILENAME = "downloads.xml";
    private static final String TMP_FILENAME = "downloads.xml.tmp";
    private static final String BAK_FILENAME = "downloads.xml.bak";
    private String directory;

    public DownloadModelXmlDAO(SettingsClass settingsClass) {
        this.directory = settingsClass.getValue("config.dir");
    }

    public void create() throws StorageException {
        File file = new File(this.directory + XML_FILENAME);
        try {
            boolean bl = file.createNewFile();
            if (!bl) {
                throw new StorageException("There was a problem while creating the storage.");
            }
        }
        catch (IOException iOException) {
            throw new StorageException("There was a problem while creating the storage.", iOException);
        }
    }

    private FrostDownloadItem createDownloadItem(Element element) {
        String string = XMLTools.getChildElementsCDATAValue(element, "filename");
        String string2 = XMLTools.getChildElementsTextValue(element, "filesize");
        String string3 = XMLTools.getChildElementsTextValue(element, "fileage");
        String string4 = XMLTools.getChildElementsCDATAValue(element, "key");
        String string5 = XMLTools.getChildElementsTextValue(element, "retries");
        String string6 = XMLTools.getChildElementsTextValue(element, "state");
        String string7 = XMLTools.getChildElementsTextValue(element, "owner");
        String string8 = XMLTools.getChildElementsTextValue(element, "sourceboard");
        String string9 = element.getAttribute("enableDownload");
        String string10 = XMLTools.getChildElementsTextValue(element, "SHA1");
        String string11 = XMLTools.getChildElementsTextValue(element, "batch");
        String string12 = XMLTools.getChildElementsCDATAValue(element, "redirect");
        if (string == null || string6 == null || string4 == null && string10 == null) {
            logger.warning("Invalid download item found. Removed.");
            return null;
        }
        int n = -1;
        try {
            n = Integer.parseInt(string6);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        if (n < 0) {
            if (!string6.equals(langRes.getString("Done"))) {
                n = 1;
            }
        } else if (n != 3) {
            n = 1;
        }
        boolean bl = false;
        if (string9 == null || string9.length() == 0 || string9.toLowerCase().equals("true")) {
            bl = true;
        }
        Board board = null;
        if (string8 != null && (board = MainFrame.getInstance().getTofTreeModel().getBoardByName(string8)) == null) {
            logger.warning("Download item found (" + string + ") whose source board (" + string8 + ") does not exist. Removed.");
            return null;
        }
        FrostDownloadItem frostDownloadItem = new FrostDownloadItem(string, string2, string3, string4, string5, string7, string10, n, bl, board);
        frostDownloadItem.setBatch(string11);
        frostDownloadItem.setRedirect(string12);
        return frostDownloadItem;
    }

    private Element createElement(FrostDownloadItem frostDownloadItem, Document document) {
        Text text;
        Element element = document.createElement("FrostDownloadTableItem");
        String string = frostDownloadItem.getEnableDownload() == null ? "true" : frostDownloadItem.getEnableDownload().toString();
        element.setAttribute("enableDownload", string);
        Element element2 = document.createElement("filename");
        CDATASection cDATASection = document.createCDATASection(frostDownloadItem.getFileName());
        element2.appendChild(cDATASection);
        element.appendChild(element2);
        if (frostDownloadItem.getFileSize() != null) {
            element2 = document.createElement("filesize");
            text = document.createTextNode(frostDownloadItem.getFileSize().toString());
            element2.appendChild(text);
            element.appendChild(element2);
        }
        element2 = document.createElement("fileage");
        text = document.createTextNode(frostDownloadItem.getFileAge());
        element2.appendChild(text);
        element.appendChild(element2);
        element2 = document.createElement("key");
        cDATASection = document.createCDATASection(frostDownloadItem.getKey());
        element2.appendChild(cDATASection);
        element.appendChild(element2);
        element2 = document.createElement("retries");
        text = document.createTextNode(String.valueOf(frostDownloadItem.getRetries()));
        element2.appendChild(text);
        element.appendChild(element2);
        element2 = document.createElement("state");
        text = document.createTextNode(String.valueOf(frostDownloadItem.getState()));
        element2.appendChild(text);
        element.appendChild(element2);
        element2 = document.createElement("SHA1");
        text = document.createTextNode(frostDownloadItem.getSHA1());
        element2.appendChild(text);
        element.appendChild(element2);
        if (frostDownloadItem.getBatch() != null) {
            element2 = document.createElement("batch");
            text = document.createTextNode(frostDownloadItem.getBatch());
            element2.appendChild(text);
            element.appendChild(element2);
        }
        if (frostDownloadItem.getRedirect() != null) {
            element2 = document.createElement("redirect");
            cDATASection = document.createCDATASection(frostDownloadItem.getRedirect());
            element2.appendChild(cDATASection);
            element.appendChild(element2);
        }
        if (frostDownloadItem.getOwner() != null && frostDownloadItem.getOwner().compareToIgnoreCase("anonymous") != 0) {
            element2 = document.createElement("owner");
            text = document.createTextNode(String.valueOf(frostDownloadItem.getOwner()));
            element2.appendChild(text);
            element.appendChild(element2);
        }
        if (frostDownloadItem.getSourceBoard() != null) {
            element2 = document.createElement("sourceboard");
            text = document.createTextNode(frostDownloadItem.getSourceBoard().getName());
            element2.appendChild(text);
            element.appendChild(element2);
        }
        return element;
    }

    public boolean exists() {
        File file = new File(this.directory + XML_FILENAME);
        if (file.length() == 0L) {
            file.delete();
        }
        return file.exists();
    }

    public void load(DownloadModel downloadModel) throws StorageException {
        Document document = null;
        try {
            document = XMLTools.parseXmlFile(this.directory + XML_FILENAME, false);
        }
        catch (Exception exception) {
            throw new StorageException("Exception while parsing the downloads model XML file.");
        }
        if (document == null) {
            throw new StorageException("Could not parse the downloads model XML file.");
        }
        Element element = document.getDocumentElement();
        if (!element.getTagName().equals("FrostDownloadTable")) {
            throw new StorageException("The downloads model XML file is invalid: does not contain the root tag FrostDownloadTable.");
        }
        ArrayList arrayList = XMLTools.getChildElementsByTagName(element, "FrostDownloadTableItemList");
        if (arrayList.size() != 1) {
            throw new StorageException("The downloads model XML file is invalid: FrostDownloadTableItemList not found or duplicated.");
        }
        Element element2 = (Element)arrayList.get(0);
        if ((arrayList = XMLTools.getChildElementsByTagName(element2, "FrostDownloadTableItem")).size() == 0) {
            logger.info("The downloads model XML file has no items.");
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                Element element3 = (Element)arrayList.get(i);
                FrostDownloadItem frostDownloadItem = this.createDownloadItem(element3);
                if (frostDownloadItem == null) continue;
                downloadModel.addDownloadItem(frostDownloadItem);
            }
            logger.info("Loaded " + arrayList.size() + " items into the downloads model.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save(DownloadModel downloadModel) throws StorageException {
        Object object;
        Document document = XMLTools.createDomDocument();
        if (document == null) {
            throw new StorageException("Could not create the XML document.");
        }
        Element element = document.createElement("FrostDownloadTable");
        document.appendChild(element);
        Element element2 = document.createElement("FrostDownloadTableItemList");
        element.appendChild(element2);
        for (int i = 0; i < downloadModel.getItemCount(); ++i) {
            object = (FrostDownloadItem)downloadModel.getItemAt(i);
            Element element3 = this.createElement((FrostDownloadItem)object, document);
            element2.appendChild(element3);
        }
        File file = new File(this.directory + XML_FILENAME);
        if (file.exists()) {
            object = new File(this.directory + BAK_FILENAME);
            ((File)object).delete();
            if (!FileAccess.copyFile(this.directory + XML_FILENAME, this.directory + BAK_FILENAME)) {
                logger.log(Level.SEVERE, "Error while copying downloads.xml to downloads.xml.bak");
            }
        }
        if (((File)(object = new File(this.directory + TMP_FILENAME))).exists()) {
            ((File)object).delete();
        }
        if (!XMLTools.writeXmlFile(document, this.directory + TMP_FILENAME)) throw new StorageException("Could not save downloads.xml");
        if (!((File)object).exists()) throw new StorageException("Could not save downloads.xml");
        file.delete();
        if (((File)object).renameTo(file) || FileAccess.copyFile(this.directory + BAK_FILENAME, this.directory + XML_FILENAME)) return;
        throw new StorageException("Error while restoring downloads.xml");
    }
}

