/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.download;

import frost.SettingsClass;
import frost.fileTransfer.download.DownloadModelDAO;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.storage.DAOFactory;
import frost.storage.Savable;
import frost.storage.StorageException;
import frost.util.model.ModelItem;
import frost.util.model.OrderedModel;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Logger;

public class DownloadModel
extends OrderedModel
implements Savable {
    private static Logger logger = Logger.getLogger(DownloadModel.class.getName());
    private SettingsClass settings;

    public DownloadModel(SettingsClass settingsClass) {
        this.settings = settingsClass;
    }

    public synchronized boolean addDownloadItem(FrostDownloadItem frostDownloadItem) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            FrostDownloadItem frostDownloadItem2 = (FrostDownloadItem)this.getItemAt(i);
            if (frostDownloadItem2.getSHA1() != null && frostDownloadItem2.getSHA1().equals(frostDownloadItem.getSHA1()) && frostDownloadItem2.getSourceBoard().getName().equals(frostDownloadItem.getSourceBoard().getName())) {
                return false;
            }
            if (frostDownloadItem.getKey() != null && frostDownloadItem2.getKey() != null && frostDownloadItem2.getKey().equals(frostDownloadItem.getKey())) {
                return false;
            }
            if (!frostDownloadItem2.getFileName().equals(frostDownloadItem.getFileName())) continue;
            int n = 2;
            while (true) {
                String string = frostDownloadItem.getFileName() + "_" + n;
                frostDownloadItem.setFileName(string);
                if (this.addDownloadItem(frostDownloadItem)) {
                    return true;
                }
                ++n;
            }
        }
        this.addItem(frostDownloadItem);
        return true;
    }

    public synchronized boolean containsItemWithKey(String string) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            FrostDownloadItem frostDownloadItem = (FrostDownloadItem)this.getItemAt(i);
            if (frostDownloadItem.getSHA1() == null || !frostDownloadItem.getSHA1().equals(string)) continue;
            return true;
        }
        return false;
    }

    public synchronized void removeFinishedDownloads() {
        ArrayList<FrostDownloadItem> arrayList = new ArrayList<FrostDownloadItem>();
        for (int i = this.getItemCount() - 1; i >= 0; --i) {
            FrostDownloadItem frostDownloadItem = (FrostDownloadItem)this.getItemAt(i);
            if (frostDownloadItem.getState() != 3) continue;
            arrayList.add(frostDownloadItem);
        }
        if (arrayList.size() > 0) {
            ModelItem[] modelItemArray = new FrostDownloadItem[arrayList.size()];
            for (int i = 0; i < modelItemArray.length; ++i) {
                modelItemArray[i] = (FrostDownloadItem)arrayList.get(i);
            }
            this.removeItems(modelItemArray);
        }
    }

    public boolean removeItems(ModelItem[] modelItemArray) {
        ArrayList<String> arrayList = new ArrayList<String>(modelItemArray.length);
        String string = this.settings.getValue("downloadDirectory");
        for (int i = 0; i < modelItemArray.length; ++i) {
            FrostDownloadItem frostDownloadItem = (FrostDownloadItem)modelItemArray[i];
            arrayList.add(frostDownloadItem.getFileName());
        }
        RemoveChunksThread removeChunksThread = new RemoveChunksThread(arrayList, string);
        removeChunksThread.start();
        return super.removeItems(modelItemArray);
    }

    public void restartItems(ModelItem[] modelItemArray) {
        for (int i = modelItemArray.length - 1; i >= 0; --i) {
            FrostDownloadItem frostDownloadItem = (FrostDownloadItem)modelItemArray[i];
            if (frostDownloadItem.getState() != 4 && frostDownloadItem.getState() != 1 && frostDownloadItem.getState() != 3) continue;
            frostDownloadItem.setState(1);
            frostDownloadItem.setRetries(0);
            frostDownloadItem.setLastDownloadStopTimeMillis(0L);
            frostDownloadItem.setEnableDownload(true);
        }
    }

    public synchronized void setAllItemsEnabled(Boolean bl) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            FrostDownloadItem frostDownloadItem = (FrostDownloadItem)this.getItemAt(i);
            if (frostDownloadItem.getState() == 3) continue;
            frostDownloadItem.setEnableDownload(bl);
        }
    }

    public void setItemsEnabled(Boolean bl, ModelItem[] modelItemArray) {
        for (int i = 0; i < modelItemArray.length; ++i) {
            FrostDownloadItem frostDownloadItem = (FrostDownloadItem)modelItemArray[i];
            if (frostDownloadItem.getState() == 3) continue;
            frostDownloadItem.setEnableDownload(bl);
        }
    }

    public synchronized void removeAllItems() {
        ArrayList<String> arrayList = new ArrayList<String>(this.getItemCount());
        String string = this.settings.getValue("downloadDirectory");
        for (int i = 0; i < this.getItemCount(); ++i) {
            FrostDownloadItem frostDownloadItem = (FrostDownloadItem)this.getItemAt(i);
            arrayList.add(frostDownloadItem.getFileName());
        }
        RemoveChunksThread removeChunksThread = new RemoveChunksThread(arrayList, string);
        removeChunksThread.start();
        this.clear();
    }

    public void save() throws StorageException {
        DownloadModelDAO downloadModelDAO = DAOFactory.getFactory(1).getDownloadModelDAO();
        downloadModelDAO.save(this);
    }

    public void initialize() throws StorageException {
        DownloadModelDAO downloadModelDAO = DAOFactory.getFactory(1).getDownloadModelDAO();
        if (!downloadModelDAO.exists()) {
            downloadModelDAO.create();
        } else {
            downloadModelDAO.load(this);
        }
    }

    private class RemoveChunksThread
    extends Thread {
        private ArrayList oldChunkFilesList;
        private String dlDir;

        public RemoveChunksThread(ArrayList arrayList, String string) {
            this.oldChunkFilesList = arrayList;
            this.dlDir = string;
        }

        public void run() {
            File[] fileArray = new File(this.dlDir).listFiles();
            for (int i = 0; i < this.oldChunkFilesList.size(); ++i) {
                String string = (String)this.oldChunkFilesList.get(i);
                for (int j = 0; j < fileArray.length; ++j) {
                    if (!fileArray[j].getName().equals(string + ".data") && !fileArray[j].getName().equals(string + ".redirect") && !fileArray[j].getName().equals(string + ".checkblocks")) continue;
                    logger.info("Removing " + fileArray[j].getName());
                    fileArray[j].delete();
                }
            }
        }
    }
}

