/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.download;

import frost.MainFrame;
import frost.SettingsClass;
import frost.fileTransfer.download.DownloadModel;
import frost.fileTransfer.download.DownloadPanel;
import frost.fileTransfer.download.DownloadStatusPanel;
import frost.fileTransfer.download.DownloadTicker;
import frost.storage.StorageException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class DownloadManager
implements PropertyChangeListener {
    private MainFrame mainFrame;
    private SettingsClass settings;
    private DownloadModel model;
    private DownloadPanel panel;
    private DownloadTicker ticker;
    private DownloadStatusPanel statusPanel;
    private boolean freenetIsOnline;

    public DownloadManager(SettingsClass settingsClass) {
        this.settings = settingsClass;
    }

    public void setMainFrame(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public void initialize() throws StorageException {
        this.mainFrame.addPanel("Downloads", this.getPanel());
        this.mainFrame.addStatusPanel(this.getStatusPanel(), 0);
        this.settings.addPropertyChangeListener("disableDownloads", this);
        this.updateDownloadStatus();
        this.getModel().initialize();
        if (this.freenetIsOnline) {
            this.getTicker().start();
        }
    }

    private DownloadStatusPanel getStatusPanel() {
        if (this.statusPanel == null) {
            this.statusPanel = new DownloadStatusPanel(this.getTicker());
        }
        return this.statusPanel;
    }

    private void updateDownloadStatus() {
        boolean bl = this.settings.getBoolValue("disableDownloads");
        this.mainFrame.setPanelEnabled("Downloads", !bl && this.freenetIsOnline);
    }

    public DownloadPanel getPanel() {
        if (this.panel == null) {
            this.panel = new DownloadPanel(this.settings);
            this.panel.setModel(this.getModel());
            this.panel.initialize();
        }
        return this.panel;
    }

    public DownloadModel getModel() {
        if (this.model == null) {
            this.model = new DownloadModel(this.settings);
        }
        return this.model;
    }

    private DownloadTicker getTicker() {
        if (this.ticker == null) {
            this.ticker = new DownloadTicker(this.settings, this.getModel(), this.getPanel());
        }
        return this.ticker;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("disableDownloads")) {
            this.updateDownloadStatus();
        }
    }

    public void setFreenetIsOnline(boolean bl) {
        this.freenetIsOnline = bl;
    }
}

