/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer;

import frost.Core;
import frost.DateFun;
import frost.FileAccess;
import frost.MainFrame;
import frost.XMLTools;
import frost.fileTransfer.download.DownloadModel;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.gui.objects.Board;
import frost.identities.Identity;
import frost.messages.FrostIndex;
import frost.messages.SharedFileObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;

public class Index {
    private static Logger logger = Logger.getLogger(Index.class.getName());
    private DownloadModel downloadModel;
    private static Index instance = null;

    public static Index getInstance() {
        return instance;
    }

    private Index(DownloadModel downloadModel) {
        this.downloadModel = downloadModel;
    }

    public static void initialize(DownloadModel downloadModel) {
        if (instance == null) {
            instance = new Index(downloadModel);
        }
    }

    public void add(FrostIndex frostIndex, Board board, String string) {
        this.add(frostIndex.getFilesMap().values(), board, "files.xml", string);
    }

    public void add(SharedFileObject sharedFileObject, Board board) {
        this.add(Collections.singletonList(sharedFileObject), board, "files.xml", null);
    }

    public void addMine(SharedFileObject sharedFileObject, Board board) {
        this.add(Collections.singletonList(sharedFileObject), board, "new_files.xml", null);
    }

    private void add(Collection collection, Board board, String string, String string2) {
        if (collection.size() == 0) {
            return;
        }
        File file = new File(MainFrame.keypool + board.getBoardFilename());
        if (!file.exists() || !file.isDirectory()) {
            file.mkdir();
        }
        File file2 = new File(MainFrame.keypool + board.getBoardFilename() + File.separator + string);
        FrostIndex frostIndex = null;
        if (file2.isFile()) {
            frostIndex = this.readKeyFile(file2);
        }
        if (frostIndex == null) {
            frostIndex = new FrostIndex(new HashMap());
        }
        for (SharedFileObject sharedFileObject : collection) {
            SharedFileObject sharedFileObject2;
            if (sharedFileObject.getSHA1() == null) {
                logger.log(Level.WARNING, "Index.add(): keys SHA1 is null: " + sharedFileObject.getFilename());
                continue;
            }
            if (string2 != null && sharedFileObject.getOwner() != null && !sharedFileObject.getOwner().equals(string2)) continue;
            if (!sharedFileObject.isValid()) {
                logger.info("Index.add(): Refused to add an invalid key to the index " + file2.getPath() + " (key=" + sharedFileObject.getFilename() + ")");
                continue;
            }
            if (sharedFileObject.getKey() != null) {
                this.updateDownloadTable(sharedFileObject);
            }
            if ((sharedFileObject2 = (SharedFileObject)frostIndex.getFilesMap().get(sharedFileObject.getSHA1())) == null) {
                frostIndex.getFilesMap().put(sharedFileObject.getSHA1(), sharedFileObject);
                continue;
            }
            sharedFileObject2.setDate(sharedFileObject.getDate());
            sharedFileObject2.setLastSharedDate(sharedFileObject.getLastSharedDate());
            sharedFileObject2.setKey(sharedFileObject.getKey());
        }
        this.writeKeyFile(frostIndex, file2);
    }

    private long determineZippedSize(FrostIndex frostIndex) {
        File file = null;
        try {
            file = File.createTempFile("index_", ".ziptmp", new File(MainFrame.frostSettings.getValue("temp.dir")));
        }
        catch (Exception exception) {
            file = new File("index_" + System.currentTimeMillis());
        }
        FileAccess.writeZipFile(XMLTools.getRawXMLDocument(frostIndex), "entry", file);
        long l = file.length();
        file.delete();
        return l;
    }

    /*
     * Unable to fully structure code
     */
    public Map getUploadKeys(Board var1_1) {
        block17: {
            block18: {
                var6_2 = 60;
                var7_3 = var1_1.getBoardFilename();
                Index.logger.fine("Index.getUploadKeys for board " + var7_3);
                var8_4 = new File(MainFrame.keypool + var7_3);
                if (!var8_4.exists() || !var8_4.isDirectory()) {
                    return null;
                }
                var9_5 = new File(MainFrame.keypool + var7_3 + File.separator + "files.xml");
                var10_6 = new File(MainFrame.keypool + var7_3 + File.separator + "new_files.xml");
                var11_7 = new HashMap<String, SharedFileObject>();
                var12_8 = this.readKeyFile(var10_6);
                while (true) {
                    for (SharedFileObject var14_11 : var12_8.getFilesMap().values()) {
                        if (var11_7.size() >= var6_2) break;
                        var11_7.put(var14_11.getSHA1(), var14_11);
                    }
                    if (var11_7.size() == 0) break;
                    var13_9 = this.determineZippedSize(new FrostIndex(var11_7));
                    if (var13_9 == 0L) {
                        Index.logger.severe("FATAL ERROR: determineZippedSize() did not create a zip file.");
                        return null;
                    }
                    if (var13_9 <= 30000L) break;
                    var11_7.clear();
                    if (var6_2 == 1) {
                        Index.logger.severe("FATAL ERROR: a single file does not fit into the index file. zipsize=" + var13_9);
                        return null;
                    }
                    if ((var6_2 -= 5) > 0) ** continue;
                    var6_2 = 1;
                }
                for (SharedFileObject var14_11 : var11_7.values()) {
                    var12_8.getFilesMap().remove(var14_11.getSHA1());
                }
                if (var12_8.getFilesMap().size() == 0) {
                    if (var10_6.isFile()) {
                        var10_6.delete();
                    }
                } else {
                    this.writeKeyFile(var12_8, var10_6);
                }
                var13_10 = null;
                var14_12 = false;
                if (var6_2 != 60) break block17;
                var13_10 = this.readKeyFile(var9_5);
                var15_13 = Core.getInstance().getIdentities().getMyId().getUniqueName();
                var16_14 = MainFrame.frostSettings.getIntValue("maxAge");
                Index.logger.info("re-sharing files shared before " + DateFun.getDate(var16_14));
                var17_16 = DateFun.getExtendedDate(var16_14);
                var18_17 = new HashMap<String, SharedFileObject>();
                var19_18 = new ArrayList<SharedFileObject>();
                do {
                    var18_17.putAll(var11_7);
                    for (SharedFileObject var21_21 : var13_10.getFilesMap().values()) {
                        if (var18_17.size() >= var6_2) break;
                        if (var21_21.getOwner() == null || var21_21.getOwner().compareTo(var15_13) != 0 || var21_21.getLastSharedDate() == null || var17_16.compareTo(var21_21.getLastSharedDate()) <= 0) continue;
                        var18_17.put(var21_21.getSHA1(), var21_21);
                        var19_18.add(var21_21);
                    }
                    if (var19_18.size() == 0) break block17;
                    var20_19 = this.determineZippedSize(new FrostIndex(var18_17));
                    if (var20_19 == 0L) {
                        Index.logger.severe("FATAL ERROR: determineZippedSize() did not create a zip file.");
                        return null;
                    }
                    if (var20_19 <= 30000L) break block18;
                    var18_17.clear();
                    var19_18.clear();
                    if (var6_2 == 1) {
                        Index.logger.severe("FATAL ERROR: a single file does not fit into the index file. zipsize=" + var20_19);
                        return null;
                    }
                    if ((var6_2 -= 5) > 0) continue;
                    var6_2 = 1;
                } while (var6_2 > var11_7.size());
                break block17;
            }
            var11_7 = var18_17;
            var14_12 = true;
            for (SharedFileObject var23_23 : var19_18) {
                if (var23_23.checkDate()) continue;
                var23_23.setDate(null);
            }
        }
        if (var11_7.size() == 0) {
            return null;
        }
        var15_13 = DateFun.getExtendedDate();
        for (Object var17_16 : var11_7.values()) {
            var17_16.setLastSharedDate(var15_13);
        }
        if (var14_12) {
            this.writeKeyFile((FrostIndex)var13_10, var9_5);
        }
        return var11_7;
    }

    private void updateDownloadTable(SharedFileObject sharedFileObject) {
        if (sharedFileObject == null || sharedFileObject.getSHA1() == null) {
            logger.warning("null value in index.updateDownloadTable");
            if (sharedFileObject != null) {
                logger.warning("SHA1 null!");
            } else {
                logger.warning("key null!");
            }
            return;
        }
        for (int i = 0; i < this.downloadModel.getItemCount(); ++i) {
            FrostDownloadItem frostDownloadItem = (FrostDownloadItem)this.downloadModel.getItemAt(i);
            if (frostDownloadItem.getState() != 7 || frostDownloadItem.getSHA1() == null || frostDownloadItem.getSHA1().compareTo(sharedFileObject.getSHA1()) != 0) continue;
            if (sharedFileObject.getKey() != null && sharedFileObject.getKey().length() > 0) {
                frostDownloadItem.setKey(sharedFileObject.getKey());
            }
            frostDownloadItem.setFileAge(sharedFileObject.getDate());
            break;
        }
    }

    public FrostIndex readKeyFile(File file) {
        Object object;
        if (!file.isFile() || file.length() <= 0L) {
            return new FrostIndex(new HashMap());
        }
        Document document = null;
        try {
            document = XMLTools.parseXmlFile(file.getPath(), false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.log(Level.SEVERE, "Exception thrown in readKeyFile(File source): \nOffending file saved as badfile.xml - send it to a dev for analysis", illegalArgumentException);
            object = new File("badfile.xml");
            file.renameTo((File)object);
        }
        if (document == null) {
            logger.warning("Couldn't parse index file.");
            return null;
        }
        FrostIndex frostIndex = new FrostIndex(document.getDocumentElement());
        object = frostIndex.getFilesMap().values().iterator();
        while (object.hasNext()) {
            SharedFileObject sharedFileObject = (SharedFileObject)object.next();
            if (sharedFileObject.isValid()) continue;
            object.remove();
        }
        return frostIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeKeyFile(FrostIndex frostIndex, File file) {
        Object object;
        if (frostIndex.getFilesMap().size() == 0) {
            return;
        }
        File file2 = new File(file.getPath() + ".tmp");
        int n = 0;
        FrostIndex frostIndex2 = frostIndex;
        synchronized (frostIndex2) {
            object = frostIndex.getFilesMap().values().iterator();
            while (object.hasNext()) {
                Identity identity;
                SharedFileObject sharedFileObject = (SharedFileObject)object.next();
                if (sharedFileObject.getOwner() != null && (identity = Core.getInstance().getIdentities().getIdentity(sharedFileObject.getOwner())) != null && identity.getState() == 4) {
                    object.remove();
                    continue;
                }
                ++n;
            }
        }
        if (n == 0) {
            return;
        }
        boolean bl = false;
        try {
            object = XMLTools.getXMLDocument(frostIndex);
            bl = XMLTools.writeXmlFile((Document)object, file2.getPath());
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "Exception thrown in writeKeyFile(FrostIndex idx, File destination)", throwable);
        }
        if (bl) {
            object = new File(file.getPath() + ".old");
            ((File)object).delete();
            file.renameTo((File)object);
            file2.renameTo(file);
        } else {
            file2.delete();
        }
    }
}

